using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
    public partial class FindTextForm : Form
    {

        public string TargetText
        {
            get { return _targetText.Text; }
            set { _targetText.Text = value; }
        }

        public bool SenseCase
        {
            get { return _senseCaseCheck.Checked; }
            set { _senseCaseCheck.Checked = value; }
        }
	
	
        public FindTextForm()
        {
            InitializeComponent();
            SenseCase = Properties.Settings.Default.LatestFindTextSenseCase;
            TargetText = Properties.Settings.Default.LatestFindTextKeyword;
        }

        private void _findButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Properties.Settings.Default.LatestFindTextSenseCase = SenseCase;
            Properties.Settings.Default.LatestFindTextKeyword = TargetText;
            Close();
        }

        private void FindForm_Load(object sender, EventArgs e)
        {
            Text = ProgramUtility.LoadStringsFromResource(typeof(FindTextForm), "Title", Text);
            ProgramUtility.LoadControlStringsFromResource(this.Controls, typeof(FindTextForm).FullName);
			this.ActiveControl = _targetText;
            if (_targetText.Text.Length == 0)
            {
                _findButton.Enabled = false;
            }

        }

		private void _targetText_KeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Escape)
			{
				Close();
			}
		}

        private void _targetText_TextChanged(object sender, EventArgs e)
        {
            if (_targetText.Text.Length == 0)
            {
                _findButton.Enabled = false;
            }
            else
            {
                _findButton.Enabled = true;
            }

        }
    }
}