using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace Oratorio
{
    public partial class ImportForm : Form
    {
        public ImportForm()
        {
            InitializeComponent();
        }

        public string FilePath
        {
            get { return _fileText.Text; }
            set { _fileText.Text = value; }
        }
	
        private void ImportForm_Load(object sender, EventArgs e)
        {
            _formatCombo.SelectedIndex = 0;
            if (_fileText.Text.Length > 0 && Path.GetExtension(_fileText.Text).Length == 0)
            {
                _fileText.Text = _fileText.Text + ".csv";
            }
        }

        private void _browseButton_Click(object sender, EventArgs e)
        {
            FileDialog fileDialog = new OpenFileDialog();
            fileDialog.InitialDirectory = Path.GetDirectoryName(_fileText.Text);
            fileDialog.Filter = "CSV/TSV/SQL Files (*.csv;*.tsv;*.txt;*.sql)|*.csv;*.tsv;*.txt;*.sql|CSV Files (*.csv)|*.csv|TSV Files (*.tsv;*.txt)|*.txt|SQL Files (*.sql)|*.sql|All Files (*.*)|*.*";
            fileDialog.FileName = Path.GetFileName(_fileText.Text);
            if (fileDialog.ShowDialog(this) != DialogResult.OK)
            {
                return;
            }
            _fileText.Text = fileDialog.FileName;

        }

        private void _okButton_Click(object sender, EventArgs e)
        {
            if (_fileText.Text.Length == 0)
            {
                MessageBox.Show(this, "Input File Path", Application.ProductName, MessageBoxButtons.OK);
                return;
            }
            if (!File.Exists(_fileText.Text))
            {
                MessageBox.Show(this, "File Path not found.", Application.ProductName, MessageBoxButtons.OK);
                return;
            }
            DialogResult = DialogResult.OK;
        }
    }
}