using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using Microsoft.VisualBasic.FileIO;
using System.Data.Common;

namespace Oratorio
{
    public partial class ImportGridForm : Form
    {
        public ImportGridForm()
        {
            InitializeComponent();
        }

        private void ImportGridForm_Load(object sender, EventArgs e)
        {

        }

        protected void OpenFileData(DataGridView dataGrid, TextReader reader)
        {
            string delimiter = ",";
            TextFieldParser parser = new TextFieldParser(reader);
            parser.SetDelimiters(delimiter);
            if (parser.EndOfData)
            {
                throw new ProgramException("File is empty.");
                //ProgramUtility.ShowError(this, "File is empty.", null);
                //return;
            }
            string[] headerFields = null;
            try
            {
                headerFields = parser.ReadFields();
            }
            catch (MalformedLineException mle)
            {
                throw new ProgramException("Text parse failed.", mle);
            }
            if (headerFields.Length == 0)
            {
                throw new ProgramException("File is empty.");
                //ProgramUtility.ShowError(this, "File is empty.", null);
                //return;
            }
            int maxColumn = headerFields.Length;
//            DataGridView dataGrid = _dataGridView;
            for (int headerIndex = 0; headerIndex < maxColumn; headerIndex++)
            {
                dataGrid.Columns.Add(headerFields[headerIndex], headerFields[headerIndex]);
            }
            while (!parser.EndOfData)
            {
                string[] textFields = null;
                try
                {
                    textFields = parser.ReadFields();
                }
                catch (MalformedLineException mle)
                {
                    throw new ProgramException("Text parse failed.", mle);
                }
                if (textFields.Length == 0)
                {
                    continue;
                }
                object[] fields = new object[maxColumn];
                Array.Copy(textFields, 0, fields, 0, Math.Min(maxColumn, textFields.Length));

                int maxFields = Math.Min(fields.Length, textFields.Length);
                for (int index = 0; index < maxFields; index++)
                {
                    if (dataGrid.Columns[index].ValueType == typeof(Decimal))
                    {
                        string text = textFields[index];
                        text = text.Trim();
                        Decimal value;
                        if (Decimal.TryParse(text, out value))
                        {
                            fields[index] = value;
                        }
                        else
                        {
                            fields[index] = DBNull.Value;
                        }
                    }
                    else if (dataGrid.Columns[index].ValueType == typeof(DateTime))
                    {
                        string text = textFields[index];
                        text = text.Trim();
                        DateTime value;
                        if (DateTime.TryParse(text, out value))
                        {
                            fields[index] = value;
                        }
                        else
                        {
                            fields[index] = DBNull.Value;
                        }

                    }
                }
                dataGrid.Rows.Add(fields);
            }
        }
        public void OpenFile(string fileName)
        {
            try
            {
                using (StreamReader reader = new StreamReader(fileName, Encoding.Default))
                {
                    OpenFileData(_dataGridView, reader);
                }
                _targetTableCombo.Text = Path.GetFileNameWithoutExtension(fileName);
            }
            catch (ProgramException pe)
            {
                ProgramUtility.ShowError(this, "CSV file load failed.", pe);
            }

        }

        protected DatabaseContext Database
        {
            get
            {
                return ((MainForm)MdiParent).Database;
            }
        }

        private void _importButton_Click(object sender, EventArgs e)
        {
            if (Database == null)
            {
                ProgramUtility.ShowError(this, "Not connected database.", null);
                return;
            }
            string targetTable = _targetTableCombo.Text;
            if (targetTable.Length == 0)
            {
                ProgramUtility.ShowError(this, "Input table name for import target.", null);
                return;
            }
            List<DatabaseColumn> columnList = new List<DatabaseColumn>();
            Database.GetTableColumnList(Database.CurrentCatalogName, Database.CurrentSchemaName, targetTable, columnList);
            string insertSql = Database.ScriptGenerator.GetInsertScript(Database.CurrentCatalogName, Database.CurrentSchemaName, targetTable, columnList);
            DataGridView dataGrid = _dataGridView;
            DbCommand command = Database.CreateCommand(insertSql);
            for (int rowIndex = 0; rowIndex < dataGrid.Rows.Count; rowIndex++)
            {
                command.Parameters.Clear();
                DataGridViewRow row = dataGrid.Rows[rowIndex];
                int nullCount = 0;
                foreach (DatabaseColumn column in columnList)
                {
                    object cellValueObj = row.Cells[column.ColumnName].Value;
                    if (column.IsDate)
                    {
                        DateTime obj;
                        if (cellValueObj == null)
                        {
                        }
                        else if (String.Compare(cellValueObj.ToString(), "sysdate", true) == 0)
                        {
                            cellValueObj = DateTime.Now;
                        }
                        else
                        {
                            if (DateTime.TryParse(cellValueObj.ToString(), out obj))
                            {
                                cellValueObj = obj;
                            }
                            else
                            {
                                cellValueObj = null;
                            }
                        }
                    }
                    if (cellValueObj == null)
                    {
                        nullCount++;
                    }
#if DEBUG
                    System.Diagnostics.Debug.WriteLine(column.ColumnName + " type:" + column.TypeName + " value:" + cellValueObj);
#endif
                    command.Parameters.Add(Database.CreateParameter(null, cellValueObj));
                }
                if (nullCount == columnList.Count)
                {
                    continue;
                }
                command.ExecuteNonQuery();
            }

            /*
            StringBuilder builder = new StringBuilder();
            StringBuilder valueBuilder = new StringBuilder();
            foreach (DatabaseColumn column in columnList)
            {
                if (builder.Length > 0)
                {
                    builder.Append(",\r\n");
                    valueBuilder.Append(",\r\n");
                }
                builder.Append("\t");
                valueBuilder.Append("\t");
                string columnName = column.ColumnName;
                columnName = columnName.ToLower();
                builder.Append(columnName);
                valueBuilder.Append("?");
            }

            targetTable = targetTable.ToLower();
            string sColumns = builder.ToString();
            string result = "INSERT INTO " + targetTable + "\r\n(\r\n" + sColumns + "\r\n";
            result += ")\r\nVALUES\r\n(";
            result += "\r\n";
            result += valueBuilder.ToString();
            result += "\r\n)\r\n";
            */
            //int maxColumn = Math.Min(table.Columns.Count, _dataGridView.ColumnCount);
            //string insertSql = Database.ScriptGenerator.GetInsertScript(Database.CurrentCatalogName, Database.CurrentSchemaName, targetTable);
            //for (int column = 0; column < columnList.Count; column++)
            //{
            //    columnList[column].IsKey
            //}
            //DbCommand command = Database.CreateCommand("SELECT * FROM " + targetTable);
            //DbDataAdapter adapter = Database.CreateDataAdapter();
            //adapter.SelectCommand = command;
            //DataSet dataSet = new DataSet();
            //adapter.FillSchema(dataSet, SchemaType.Source);
            //DataTable table = dataSet.Tables[0];
            //int maxColumn = Math.Min(table.Columns.Count, _dataGridView.ColumnCount);
            //for (int column = 0; column < maxColumn; column++)
            //{
            //    _dataGridView.Columns[column].Name = table.Columns[column].ColumnName;
            //}
            //DbCommandBuilder builder = _database.CreateCommandBuilder();
            //builder.DataAdapter = adapter;

//            DataAdapter adapter = 
        }
    }
}