﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Configuration;
using System.Reflection;
using System.Resources;
using System.IO;

namespace Oratorio
{
	public partial class MainForm : Form
	{
		private int childFormNumber = 1;

		private DatabaseContext _database;

		public DatabaseContext Database
		{
			get { return _database; }
			set { _database = value; }
		}

		public MainForm()
		{
			InitializeComponent();
            _setStatusMessageDelegate = SetStatusMessageCallback;
        }

		private void ShowNewForm(object sender, EventArgs e)
		{
//			ScriptForm childForm = CreateNewForm(ScriptForm.SheetTypes.Query);
//            childForm.Show();
            ScriptForm childForm = CreateEditForm();
			childForm.EditControl.TextBox.Focus();
		}

        //private void OpenFile(object sender, EventArgs e)
        //{
        //}

		private void _saveAsMenuItem_Click(object sender, EventArgs e)
		{
			ScriptForm scriptForm = (ScriptForm)ActiveMdiChild;
			if (scriptForm.IsGridFocused)
			{
				SaveFileDialog saveFileDialog = new SaveFileDialog();
				saveFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
				saveFileDialog.Filter = "CSV Files (*.csv)|*.csv|All Files (*.*)|*.*";
				saveFileDialog.FileName = scriptForm.TableName;
				if (saveFileDialog.ShowDialog(this) == DialogResult.OK)
				{
					string fileName = saveFileDialog.FileName;
					scriptForm.SaveFileFromGrid(fileName);
				}
			}
			if (scriptForm.IsScriptFocused)
			{
				SaveFileDialog saveFileDialog = new SaveFileDialog();
				saveFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
				saveFileDialog.Filter = "SQL Files (*.sql)|*.sql|Text Files (*.txt)|*.txt|All Files (*.*)|*.*";
				saveFileDialog.FileName = scriptForm.TableName;
				if (saveFileDialog.ShowDialog(this) == DialogResult.OK)
				{
					string fileName = saveFileDialog.FileName;
					scriptForm.SaveFile(fileName);
				}
			}
		}

		private void _exitMenuItem_Click(object sender, EventArgs e)
		{
			Application.Exit();
		}

		private void _cutMenuItem_Click(object sender, EventArgs e)
		{
            const ProgramUtility.CallEditActionModes mode = ProgramUtility.CallEditActionModes.CUT;
            Control activeControl = ActiveControl;
            if (activeControl is ScriptForm)
            {
                ScriptForm scriptForm = (ScriptForm)activeControl;
                if (scriptForm.IsCallEditActionEnable(mode))
                {
                    scriptForm.CallEditAction(mode);
                    return;
                }
            }
            Control target = ProgramUtility.FindFocus(this);
			ProgramUtility.CallEditAction(target, mode);
		}

		private void _copyMenuItem_Click(object sender, EventArgs e)
		{
            const ProgramUtility.CallEditActionModes mode = ProgramUtility.CallEditActionModes.COPY;
            Control activeControl = ActiveControl;
            if (activeControl is ScriptForm)
            {
                ScriptForm scriptForm = (ScriptForm)activeControl;
                if (scriptForm.IsCallEditActionEnable(mode))
                {
                    scriptForm.CallEditAction(mode);
                    return;
                }
            }
            Control target = ProgramUtility.FindFocus(this);
            ProgramUtility.CallEditAction(target, mode);
        }
        private void _pasteMenuItem_Click(object sender, EventArgs e)
        {
            const ProgramUtility.CallEditActionModes mode = ProgramUtility.CallEditActionModes.PASTE;
            Control activeControl = ActiveControl;
            if (activeControl is ScriptForm)
            {
                ScriptForm scriptForm = (ScriptForm)activeControl;
                if (scriptForm.IsCallEditActionEnable(mode))
                {
                    scriptForm.CallEditAction(mode);
                    return;
                }
            }
            Control target = ProgramUtility.FindFocus(this);
            ProgramUtility.CallEditAction(target, mode);
        }
        private void _selectAllMenuItem_Click(object sender, EventArgs e)
		{
            const ProgramUtility.CallEditActionModes mode = ProgramUtility.CallEditActionModes.SELECT_ALL;
            Control activeControl = ActiveControl;
            if (activeControl is ScriptForm)
            {
                ScriptForm scriptForm = (ScriptForm)activeControl;
                if (scriptForm.IsCallEditActionEnable(mode))
                {
                    scriptForm.CallEditAction(mode);
                    return;
                }
            }
            Control target = ProgramUtility.FindFocus(this);
            ProgramUtility.CallEditAction(target, mode);
        }

        private void _deleteMenuItem_Click(object sender, EventArgs e)
        {
            const ProgramUtility.CallEditActionModes mode = ProgramUtility.CallEditActionModes.DELETE;
            Control activeControl = ActiveControl;
            if (activeControl is ScriptForm)
            {
                ScriptForm scriptForm = (ScriptForm)activeControl;
                if (scriptForm.IsCallEditActionEnable(mode))
                {
                    scriptForm.CallEditAction(mode);
                    return;
                }
            }
            Control target = ProgramUtility.FindFocus(this);
            ProgramUtility.CallEditAction(target, mode);
        }


		private void ToolBarToolStripMenuItem_Click(object sender, EventArgs e)
		{
			toolStrip.Visible = _showToolBarMenuItem.Checked;
		}

		private void StatusBarToolStripMenuItem_Click(object sender, EventArgs e)
		{
			_statusStrip.Visible = _showStatusBarMenuItem.Checked;
		}

		private void CascadeToolStripMenuItem_Click(object sender, EventArgs e)
		{
			LayoutMdi(MdiLayout.Cascade);
		}

		private void TileVerticalToolStripMenuItem_Click(object sender, EventArgs e)
		{
			LayoutMdi(MdiLayout.TileVertical);
		}

		private void TileHorizontalToolStripMenuItem_Click(object sender, EventArgs e)
		{
			LayoutMdi(MdiLayout.TileHorizontal);
		}

		private void ArrangeIconsToolStripMenuItem_Click(object sender, EventArgs e)
		{
			LayoutMdi(MdiLayout.ArrangeIcons);
		}

		private void CloseAllToolStripMenuItem_Click(object sender, EventArgs e)
		{
			foreach (Form childForm in MdiChildren)
			{
				childForm.Close();
			}
		}

        protected void ConnectDialog()
        {

            ConnectListForm form = new ConnectListForm();
            if (form.ShowDialog(this) != DialogResult.OK)
            {
                return;
            }
            _database = form.Database;
            _objectTree.Database = _database;
            RefreshObjectTree();
            SetStatusMessage("Connect database [" + _database.CurrentCatalogName + "]");

            if (MdiChildren.Length == 0)
            {
                ScriptForm childForm = CreateEditForm();
            }

            _objectTree.TreeView.Focus();
            System.Diagnostics.Debug.WriteLine("ConnectDialog success.");
        }

        protected void Disconnect()
        {
            _objectTree.TreeView.Nodes.Clear();
            lock (this)
            {
                if (_database != null)
                {
                    _database.Close();
                    _database = null;
                    SetStatusMessage("Disconnect database");
                }
            }
        }

		private void _connectMenuItem_Click(object sender, EventArgs e)
		{
            ConnectDialog();
        }

        public void OutputScriptLogLine(string message)
        {
#if DEBUG
            ProgramUtility.WriteLine(message);
#endif
            _scriptLog.WriteLogLine(message, Color.Transparent);
        }

        public void OutputScriptLogLine(string message, Color color)
        {
#if DEBUG
            ProgramUtility.WriteLine(message);
#endif
            _scriptLog.WriteLogLine(message, color);
        }

        private void MainForm_Load(object sender, EventArgs e)
		{
            try
            {
                string version = Properties.Settings.Default.ProductVersion;
            }
            catch (ConfigurationException ce)
            {
                ProgramUtility.ShowError(ce);
                Close();
                return;
            }

//            toolStrip.Items["newToolStripButton"].Enabled = false;
            toolStrip.Visible = false;
//            statusStrip.Visible = false;
            SetStatusMessage(ProductName + " Ver " + ProductVersion);
//            _statusStrip.Items[0].Text = ProductName + " Ver " + ProductVersion;

			Text = ProgramUtility.GetAssemblyAttribute(typeof(AssemblyTitleAttribute));
            ProgramUtility.LoadMenuStringsFromResource(_mainMenuStrip.Items, GetType().FullName);
#if DEBUG
			Text = Text + " (DEBUG)";
#endif
            OutputScriptLogLine("-- #" + Application.ProductName + " Ver " + Application.ProductVersion, Color.Blue);
            OutputScriptLogLine("-- #Date: " + DateTime.Now, Color.Blue);
            Visible = true;
            
            _connectMenuItem_Click(sender, e);
        }

        protected delegate void SetStatusMessageDelegate(string message);
        protected SetStatusMessageDelegate _setStatusMessageDelegate;

        public void SetStatusMessage(string message)
        {
            Invoke(_setStatusMessageDelegate, new object[] { message });
        }

        protected void SetStatusMessageCallback(string message)
        {
            _statusStrip.Items[0].Text = message;
        }


        protected void RefreshObjectTree()
		{
            _objectTree.RefreshNode();
		}

		public bool IsConnected
		{
			get { return (_database != null); }
		}

		private void _mainMenuStrip_MenuActivate(object sender, EventArgs e)
		{
			bool bConnected = IsConnected;

            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _disconnectMenuItem, bConnected);
//            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _newMenuItem, bConnected);
            //			ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _saveMenuItem, bConnected && (ActiveMdiChild is ScriptForm));
			ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _saveAsMenuItem, (ActiveMdiChild is ScriptForm));
            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _saveMenuItem, (ActiveMdiChild is ScriptForm));

            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _scriptRunMenuItem, bConnected && MdiChildren.Length > 0);
            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _refreshMenuItem, bConnected);

            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _findColumnMenuItem, (ActiveMdiChild is ScriptForm));

            bool bEditMenuEnable = (MdiChildren.Length > 0);
            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _cutMenuItem, bEditMenuEnable);
            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _pasteMenuItem, bEditMenuEnable);
            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _copyMenuItem, bEditMenuEnable);
            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _deleteMenuItem, bEditMenuEnable);
            ProgramUtility.EnableStripMenuItem(_mainMenuStrip, _selectAllMenuItem, bEditMenuEnable);
        }

        protected void AddMdiChild(Form childForm)
        {
            childForm.MdiParent = this;
            if (ActiveMdiChild == null || ActiveMdiChild.WindowState == FormWindowState.Maximized)
            {
                childForm.WindowState = FormWindowState.Maximized;
            }
            //if (AllowDrop)
            //{
            //    childForm.AllowDrop = true;
            //    childForm.DragEnter += new DragEventHandler(MainForm_DragEnter);
            //    childForm.DragDrop += new DragEventHandler(MainForm_DragDrop);
            //}
        }

        //protected ScriptForm CreateNewForm(ScriptForm.SheetTypes type)
        //{
        //    ScriptForm childForm = new ScriptForm(_database, type);
        //    childForm.MdiParent = this;
        //    childForm.Text = "Editor " + childFormNumber++;
        //    if (ActiveMdiChild == null || ActiveMdiChild.WindowState == FormWindowState.Maximized)
        //    {
        //        childForm.WindowState = FormWindowState.Maximized;
        //    }
        //    return childForm;
        //}

        public ScriptForm CreateGridForm(string sCatalog, string sSchema, string sTableName, bool schemaOnly)
		{
//            ScriptForm childForm = CreateNewForm((schemaOnly? ScriptForm.SheetTypes.Schema: ScriptForm.SheetTypes.Table));
            ScriptForm childForm = new ScriptForm(_database, (schemaOnly ? ScriptForm.SheetTypes.Schema : ScriptForm.SheetTypes.Table));
            AddMdiChild(childForm);
            try
			{
                childForm.DoQueryTable(sCatalog, sSchema, sTableName);
			}
			catch (ProgramException dnafe)
			{
				dnafe.Report(this);
                childForm.Dispose();
				return null;
			}

			childForm.Show();
            return childForm;
		}

        public ScriptForm CreateEditForm()
        {
            ScriptForm childForm = new ScriptForm(_database, ScriptForm.SheetTypes.Query);
            childForm.Text = "Editor " + childFormNumber++;
            AddMdiChild(childForm);
            childForm.Show();
            return childForm;
        }

        public TableDefineForm CreateTableDefineForm(string catalogName, string schemaName, string tableName)
        {
            TableDefineForm childForm = new TableDefineForm(_database, catalogName, schemaName, tableName);
            childForm.Text = tableName;
            AddMdiChild(childForm);
            childForm.Show();
            try
            {
                childForm.RefreshPanel();
            }
            catch (ProgramException pe)
            {
                ProgramUtility.ShowError(pe);
                throw new ProgramCancelException(pe);
            }
            return childForm;
        }

        private void _scriptRunMenuItem_Click(object sender, EventArgs e)
		{
			ScriptForm scriptForm = (ScriptForm)ActiveMdiChild;
			scriptForm.ExecuteScript();
		}

		//private void _aboutMenuItem_Click_old(object sender, EventArgs e)
		//{
		//    AboutBox about = new AboutBox();
		//    about.ShowDialog(this);
		//}

		private void _saveMenuItem_Click(object sender, EventArgs e)
		{
			ScriptForm scriptForm = (ScriptForm)ActiveMdiChild;
			if (scriptForm.FilePath == null)
			{
				_saveAsMenuItem_Click(sender, e);
				return;
			}
			scriptForm.SaveFileFromGrid(scriptForm.FilePath);
		}

		private void MainForm_Activated(object sender, EventArgs e)
		{
			_mainMenuStrip_MenuActivate(sender, e);
		}

        private void MainForm_MdiChildActivate(object sender, EventArgs e)
        {
            _mainMenuStrip_MenuActivate(sender, e);
        }

        private void _disconnectMenuItem_Click(object sender, EventArgs e)
        {
            Disconnect();
        }

        private void _refreshMenuItem_Click(object sender, EventArgs e)
        {
			ScriptForm scriptForm = (ScriptForm)ActiveMdiChild;
            if (scriptForm != null && (scriptForm.IsGridFocused || scriptForm.IsScriptFocused))
            {
                scriptForm.ExecuteScript();
                return;
            }
            RefreshObjectTree();
        }

		private void _newMenuItem_Click(object sender, EventArgs e)
		{
//			ScriptForm childForm = CreateNewForm(ScriptForm.SheetTypes.Query);
//            childForm.Show();
            ScriptForm childForm = CreateEditForm();
			childForm.EditControl.TextBox.Focus();
		}

		private void _openMenuItem_Click(object sender, EventArgs e)
		{
			OpenFileDialog openFileDialog = new OpenFileDialog();
			openFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            //openFileDialog.Filter = "Script File (*.sql)|*.sql|Text File (*.txt)|*.txt|All Files (*.*)|*.*";
            openFileDialog.Filter = "Supported Files (*.sql;*.txt;*.csv)|*.sql;*.txt;*.csv|CSV File (*.csv)|*.csv|Script File (*.sql)|*.sql|Text File (*.txt)|*.txt|All Files (*.*)|*.*";
            if (openFileDialog.ShowDialog(this) == DialogResult.OK)
			{
				string fileName = openFileDialog.FileName;
                string fileExt = Path.GetExtension(fileName);
                if (fileExt.Equals(".sql", StringComparison.OrdinalIgnoreCase))
                {
                    ScriptForm childForm = CreateEditForm();
                    childForm.OpenFile(fileName);
                    childForm.Show();
                }
                else if (fileExt.Equals(".csv", StringComparison.OrdinalIgnoreCase))
                {
                    ImportGridForm childForm = new ImportGridForm();
                    childForm.OpenFile(fileName);
                    AddMdiChild(childForm);
                    //                    childForm.OpenFile(fileName);
                    childForm.Show();
                }
                else
                {
                    ProgramUtility.ShowError(this, "Not supported file. [" + fileExt + "]", null);
                }
			}
		}

        public void MainForm_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.All;
            }
        }

        public void MainForm_DragDrop(object sender, DragEventArgs e)
        {
            string[] aPath = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            foreach (string path in aPath)
            {
                ScriptForm childForm = CreateEditForm();
                childForm.OpenFile(path);
                childForm.Show();
            }
        }

        private void _findMenuItem_Click(object sender, EventArgs e)
        {
            if (ActiveMdiChild != null && ActiveMdiChild.ContainsFocus)
            {
                if (ActiveMdiChild is ScriptForm)
                {
                    ScriptForm childForm = (ScriptForm)ActiveMdiChild;
                    childForm.ShowFindForm();
                }
                if (ActiveMdiChild is TableDefineForm)
                {
                    TableDefineForm childForm = (TableDefineForm)ActiveMdiChild;
                    childForm.ShowFindForm();
                }
            }
            if (_objectTree.ContainsFocus)
            {
                _objectTree.ShowFindForm();
            }
        }

		private void _aboutMenuItem_Click(object sender, EventArgs e)
		{
			AboutBox about = new AboutBox();
			about.ShowDialog(this);
		}

		private void _datasourceAdministratorMenuItem_Click(object sender, EventArgs e)
		{
			CommonUtility.OpenOdbcAdmin();
		}

        private void _findColumnMenuItem_Click(object sender, EventArgs e)
        {
            if (!(ActiveMdiChild is ScriptForm))
            {
                return;
            }
			ScriptForm scriptForm = (ScriptForm)ActiveMdiChild;
            if (!scriptForm.IsGridFocused)
            {
                return;
            }

            FindColumnForm form = new FindColumnForm();
            DataGridViewCell cell = scriptForm.GridCtrl.CurrentCell;
            if(cell == null)
            {
                cell = scriptForm.GridCtrl.Rows[0].Cells[0];
            }
            form.ColumnName = scriptForm.GridCtrl.Columns[cell.ColumnIndex].Name;
            List<string> columnList = new List<string>();
            foreach (DataGridViewColumn col in scriptForm.GridCtrl.Columns)
            {
                columnList.Add(col.Name);
            }
            form.ColumnList = columnList;
            if (form.ShowDialog() != DialogResult.OK)
            {
                return;
            }
            string columnName = form.ColumnName;
            foreach (DataGridViewColumn col in scriptForm.GridCtrl.Columns)
            {
                if (col.Name == columnName)
                {
                    scriptForm.GridCtrl.CurrentCell = scriptForm.GridCtrl.Rows[cell.RowIndex].Cells[col.Index];
                    break;
                }
            }
        }


	}
}
