using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace Oratorio
{
	public partial class ScriptLogControl : UserControl
	{
		public ScriptLogControl()
		{
			InitializeComponent();
		}

        public void WriteLogLine(string message, Color color)
        {
            
            if (!message.EndsWith("\r\n"))
            {
                if (message.EndsWith("\r"))
                {
                    message += "\n";
                }
                else if (message.EndsWith("\n"))
                {
                    message = message.Substring(0, message.Length - 1);
                    message += "\r\n";
                }
                else
                {
                    message += "\r\n";
                }
            }
            int nBeforeTextLen = _logText.Text.Length;

            _logText.SuspendLayout();
            _logText.AppendText(message);

            if (color != Color.Transparent)
            {
                _logText.SelectionStart = nBeforeTextLen;
                _logText.SelectionLength = _logText.Text.Length - nBeforeTextLen;
                _logText.SelectionColor = color;
                _logText.SelectionStart = _logText.Text.Length;
                //            _logText.SelectionLength = 0;
            }
            _logText.ScrollToCaret();
            _logText.ResumeLayout();
        }

        private void _copyMenuItem_Click(object sender, EventArgs e)
        {
            this._logText.Copy();
        }

        private void _clearMenuItem_Click(object sender, EventArgs e)
        {
            _logText.Clear();
        }

        private void _saveAsMenuItem_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog = new SaveFileDialog();
            saveFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            saveFileDialog.Filter = "Log Files (*.log)|*.log|All Files (*.*)|*.*";
            saveFileDialog.FileName = "script.log";
            if (saveFileDialog.ShowDialog(this) != DialogResult.OK)
            {
                return;
            }
            string fileName = saveFileDialog.FileName;

            string script = _logText.Text;
            try
            {
                Encoding encoding = Encoding.Default;
                byte[] byteBuffer = encoding.GetBytes(script);
                using (FileStream stream = new FileStream(fileName, FileMode.Create, FileAccess.Write))
                {
                    stream.Write(byteBuffer, 0, byteBuffer.Length);
                }
            }
            catch (IOException ioe)
            {
                ProgramUtility.ShowError(ioe);
                return;
            }
        }


        private void _selectAllMenuItem_Click(object sender, EventArgs e)
        {
            _logText.SelectAll();
		}

		private void ScriptLogControl_Load(object sender, EventArgs e)
		{
			ProgramUtility.LoadMenuStringsFromResource(_contextMenuStrip.Items, typeof(ScriptLogControl).FullName);
		}
    
    }
}
