<?php
/**
 * DefaultApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.jp/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.jp/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20160304
 * Contact: admin@osdn.jp
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * DefaultApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DefaultApi
{

    /**
     * API Client
     *
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\OSDN\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.jp/api/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \OSDN\ApiClient $apiClient set the API client
     *
     * @return DefaultApi
     */
    public function setApiClient(\OSDN\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation ping
     *
     * 
     *
     * @return \OSDN\Model\Pong
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function ping()
    {
        list($response) = $this->pingWithHttpInfo();
        return $response;
    }

    /**
     * Operation pingWithHttpInfo
     *
     * 
     *
     * @return Array of \OSDN\Model\Pong, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function pingWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/ping";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Pong',
                '/ping'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Pong', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Pong', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation token
     *
     * 
     *
     * @param string $client_id Your application ID (required)
     * @param string $client_secret Your application secret (key) (required)
     * @param string $grant_type \&quot;authorization_code\&quot; or \&quot;refresh_token\&quot; (optional, default to authorization_code)
     * @param string $code Set auth code issued by https://osdn.jp/account/oauth2ui/authorize for grant_type&#x3D;authorization_code (optional)
     * @param string $refresh_token Set refresh token to update access token. (optional)
     * @return \OSDN\Model\Token
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function token($client_id, $client_secret, $grant_type = null, $code = null, $refresh_token = null)
    {
        list($response) = $this->tokenWithHttpInfo($client_id, $client_secret, $grant_type, $code, $refresh_token);
        return $response;
    }

    /**
     * Operation tokenWithHttpInfo
     *
     * 
     *
     * @param string $client_id Your application ID (required)
     * @param string $client_secret Your application secret (key) (required)
     * @param string $grant_type \&quot;authorization_code\&quot; or \&quot;refresh_token\&quot; (optional, default to authorization_code)
     * @param string $code Set auth code issued by https://osdn.jp/account/oauth2ui/authorize for grant_type&#x3D;authorization_code (optional)
     * @param string $refresh_token Set refresh token to update access token. (optional)
     * @return Array of \OSDN\Model\Token, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function tokenWithHttpInfo($client_id, $client_secret, $grant_type = null, $code = null, $refresh_token = null)
    {
        // verify the required parameter 'client_id' is set
        if ($client_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $client_id when calling token');
        }
        // verify the required parameter 'client_secret' is set
        if ($client_secret === null) {
            throw new \InvalidArgumentException('Missing the required parameter $client_secret when calling token');
        }
        // parse inputs
        $resourcePath = "/token";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($client_id !== null) {
            $formParams['client_id'] = $this->apiClient->getSerializer()->toFormValue($client_id);
        }
        // form params
        if ($client_secret !== null) {
            $formParams['client_secret'] = $this->apiClient->getSerializer()->toFormValue($client_secret);
        }
        // form params
        if ($grant_type !== null) {
            $formParams['grant_type'] = $this->apiClient->getSerializer()->toFormValue($grant_type);
        }
        // form params
        if ($code !== null) {
            $formParams['code'] = $this->apiClient->getSerializer()->toFormValue($code);
        }
        // form params
        if ($refresh_token !== null) {
            $formParams['refresh_token'] = $this->apiClient->getSerializer()->toFormValue($refresh_token);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Token',
                '/token'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Token', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Token', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
