# coding: utf-8

"""
    OSDN REST API v0 beta

    OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.jp/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.jp/projects/osdn-codes/releases/p14859 . 

    OpenAPI spec version: 0.0.20160304
    Contact: admin@osdn.jp
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProjectApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_news(self, title, body, group_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news(title, body, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :param int group_id: group_id the news created in (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_news_with_http_info(title, body, group_id, **kwargs)
        else:
            (data) = self.create_news_with_http_info(title, body, group_id, **kwargs)
            return data

    def create_news_with_http_info(self, title, body, group_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_with_http_info(title, body, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :param int group_id: group_id the news created in (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['title', 'body', 'group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `create_news`")

        resource_path = '/news'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_news_0(self, id_or_name, title, body, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_0(id_or_name, title, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_news_0_with_http_info(id_or_name, title, body, **kwargs)
        else:
            (data) = self.create_news_0_with_http_info(id_or_name, title, body, **kwargs)
            return data

    def create_news_0_with_http_info(self, id_or_name, title, body, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_0_with_http_info(id_or_name, title, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_news_0`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news_0`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news_0`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_package(self, id_or_name, name, **kwargs):
        """
        
        Create a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_package(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: package name (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_package_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_package_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_package_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_package_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: package name (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_package`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_package`")

        resource_path = '/project/{id_or_name}/frs'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Package',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_release(self, id_or_name, package_id, name, **kwargs):
        """
        
        Create new release in specified package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release(id_or_name, package_id, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: Release name (required)
        :param str visibility: visibility status (public, hidden or private)
        :param str time: Release datetime. If you set future time, the release hide until specified time.
        :param str release_note: Release note body text.
        :param str change_log: Changelog body text.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_release_with_http_info(id_or_name, package_id, name, **kwargs)
        else:
            (data) = self.create_release_with_http_info(id_or_name, package_id, name, **kwargs)
            return data

    def create_release_with_http_info(self, id_or_name, package_id, name, **kwargs):
        """
        
        Create new release in specified package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release_with_http_info(id_or_name, package_id, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: Release name (required)
        :param str visibility: visibility status (public, hidden or private)
        :param str time: Release datetime. If you set future time, the release hide until specified time.
        :param str release_note: Release note body text.
        :param str change_log: Changelog body text.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'name', 'visibility', 'time', 'release_note', 'change_log']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `create_release`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'time' in params:
            form_params.append(('time', params['time']))
        if 'release_note' in params:
            form_params.append(('release_note', params['release_note']))
        if 'change_log' in params:
            form_params.append(('change_log', params['change_log']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_release_file(self, id_or_name, package_id, release_id, file, **kwargs):
        """
        
        Create new file in target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release_file(id_or_name, package_id, release_id, file, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param file file: Upload file in \"multipart/form-data\". (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_release_file_with_http_info(id_or_name, package_id, release_id, file, **kwargs)
        else:
            (data) = self.create_release_file_with_http_info(id_or_name, package_id, release_id, file, **kwargs)
            return data

    def create_release_file_with_http_info(self, id_or_name, package_id, release_id, file, **kwargs):
        """
        
        Create new file in target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release_file_with_http_info(id_or_name, package_id, release_id, file, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param file file: Upload file in \"multipart/form-data\". (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `create_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `create_release_file`")
        # verify the required parameter 'file' is set
        if ('file' not in params) or (params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `create_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))
        if 'file' in params:
            local_var_files['file'] = params['file']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelFile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.delete_news_with_http_info(news_id, **kwargs)
            return data

    def delete_news_with_http_info(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_news_0(self, id_or_name, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_0(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_news_0_with_http_info(id_or_name, news_id, **kwargs)
        else:
            (data) = self.delete_news_0_with_http_info(id_or_name, news_id, **kwargs)
            return data

    def delete_news_0_with_http_info(self, id_or_name, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_0_with_http_info(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_news_0`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_package(self, id_or_name, package_id, **kwargs):
        """
        
        Delete taret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_package(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_package_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.delete_package_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def delete_package_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Delete taret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_package_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_package`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `delete_package`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_release(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Delete target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
        else:
            (data) = self.delete_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
            return data

    def delete_release_with_http_info(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Delete target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release_with_http_info(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `delete_release`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `delete_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_release_file(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Delete target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release_file(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
        else:
            (data) = self.delete_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
            return data

    def delete_release_file_with_http_info(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Delete target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release_file_with_http_info(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `delete_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `delete_release_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `delete_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']
        if 'file_id' in params:
            path_params['file_id'] = params['file_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def draft_release(self, id_or_name, package_id, **kwargs):
        """
        
        Get release draft in specified package. If draft is not exist, it will be created automatically.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.draft_release(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.draft_release_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.draft_release_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def draft_release_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Get release draft in specified package. If draft is not exist, it will be created automatically.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.draft_release_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method draft_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `draft_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `draft_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/draft'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_news(self, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.get_news_with_http_info(news_id, **kwargs)
            return data

    def get_news_with_http_info(self, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_news_0(self, id_or_name, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_0(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_news_0_with_http_info(id_or_name, news_id, **kwargs)
        else:
            (data) = self.get_news_0_with_http_info(id_or_name, news_id, **kwargs)
            return data

    def get_news_0_with_http_info(self, id_or_name, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_0_with_http_info(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_news_0`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_package(self, id_or_name, package_id, **kwargs):
        """
        
        Get specified package info and release list of the package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_package_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.get_package_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def get_package_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Get specified package info and release list of the package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_package`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `get_package`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Package',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project(self, id_or_name, **kwargs):
        """
        
        Get project info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project`")

        resource_path = '/project/{id_or_name}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Group',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_release(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Get specified release info and file list of the release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
        else:
            (data) = self.get_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
            return data

    def get_release_with_http_info(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Get specified release info and file list of the release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release_with_http_info(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `get_release`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `get_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_release_file(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Get single file object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release_file(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
        else:
            (data) = self.get_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
            return data

    def get_release_file_with_http_info(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Get single file object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release_file_with_http_info(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `get_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `get_release_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']
        if 'file_id' in params:
            path_params['file_id'] = params['file_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelFile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_news(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int group_id: filter by group ID
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_news_with_http_info(**kwargs)
        else:
            (data) = self.list_news_with_http_info(**kwargs)
            return data

    def list_news_with_http_info(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int group_id: filter by group ID
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/news'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_news_0(self, id_or_name, **kwargs):
        """
        
        Get news list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_0(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_news_0_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_news_0_with_http_info(id_or_name, **kwargs)
            return data

    def list_news_0_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get news list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_0_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_news_0`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_packages(self, id_or_name, **kwargs):
        """
        
        Get package list of specified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_packages(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[Package]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_packages_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_packages_with_http_info(id_or_name, **kwargs)
            return data

    def list_packages_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get package list of specified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_packages_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[Package]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_packages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_packages`")

        resource_path = '/project/{id_or_name}/frs'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Package]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.update_news_with_http_info(news_id, **kwargs)
            return data

    def update_news_with_http_info(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_news_0(self, news_id, id_or_name, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_0(news_id, id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_news_0_with_http_info(news_id, id_or_name, **kwargs)
        else:
            (data) = self.update_news_0_with_http_info(news_id, id_or_name, **kwargs)
            return data

    def update_news_0_with_http_info(self, news_id, id_or_name, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_0_with_http_info(news_id, id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'id_or_name', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news_0`")
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_package(self, id_or_name, package_id, **kwargs):
        """
        
        Update tagret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_package(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: package name
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_package_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.update_package_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def update_package_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Update tagret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_package_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: package name
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'name', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_package`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `update_package`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Package',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_release(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Update target release. (Note: If you update draft release, the release will be public automatically.) 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :param str name: Release name
        :param str time: Release datetime. If you set future time, the release hide until specified time.
        :param int move_to_package_id: If this parameter is specified, the release move to another package.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
        else:
            (data) = self.update_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
            return data

    def update_release_with_http_info(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Update target release. (Note: If you update draft release, the release will be public automatically.) 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release_with_http_info(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :param str name: Release name
        :param str time: Release datetime. If you set future time, the release hide until specified time.
        :param int move_to_package_id: If this parameter is specified, the release move to another package.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'visibility', 'name', 'time', 'move_to_package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `update_release`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `update_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'time' in params:
            form_params.append(('time', params['time']))
        if 'move_to_package_id' in params:
            form_params.append(('move_to_package_id', params['move_to_package_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_release_file(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Change visibility of target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release_file(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
        else:
            (data) = self.update_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
            return data

    def update_release_file_with_http_info(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Change visibility of target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release_file_with_http_info(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file_id', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `update_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `update_release_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `update_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']
        if 'file_id' in params:
            path_params['file_id'] = params['file_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelFile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
