# osdn-client

OSDNClient - JavaScript client for osdn-client
OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.20161003
- Package version: 0.0.20161003
- Build date: 2016-10-04T16:32:46.082+09:00
- Build package: class io.swagger.codegen.languages.JavascriptClientCodegen
For more information, please visit [https://osdn.net/projects/osdn-codes/wiki/APIGuide](https://osdn.net/projects/osdn-codes/wiki/APIGuide)

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install osdn-client --save
```

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/OSDN/Client
then install it via:

```shell
    npm install OSDN/Client --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var OSDNClient = require('osdn-client');

var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = "YOUR ACCESS TOKEN"

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = "YOUR ACCESS TOKEN"

var api = new OSDNClient.DefaultApi()

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.ping(callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://osdn.net/api/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OSDNClient.DefaultApi* | [**ping**](docs/DefaultApi.md#ping) | **GET** /ping | 
*OSDNClient.DefaultApi* | [**token**](docs/DefaultApi.md#token) | **POST** /token | 
*OSDNClient.ProjectApi* | [**createNews**](docs/ProjectApi.md#createNews) | **POST** /news | 
*OSDNClient.ProjectApi* | [**createNews_0**](docs/ProjectApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
*OSDNClient.ProjectApi* | [**createPackage**](docs/ProjectApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
*OSDNClient.ProjectApi* | [**createRelease**](docs/ProjectApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**createReleaseFile**](docs/ProjectApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**deleteNews**](docs/ProjectApi.md#deleteNews) | **DELETE** /news/{news_id} | 
*OSDNClient.ProjectApi* | [**deleteNews_0**](docs/ProjectApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectApi* | [**deletePackage**](docs/ProjectApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**deleteRelease**](docs/ProjectApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**deleteReleaseFile**](docs/ProjectApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectApi* | [**draftRelease**](docs/ProjectApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*OSDNClient.ProjectApi* | [**getNews**](docs/ProjectApi.md#getNews) | **GET** /news/{news_id} | 
*OSDNClient.ProjectApi* | [**getNews_0**](docs/ProjectApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectApi* | [**getPackage**](docs/ProjectApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**getProject**](docs/ProjectApi.md#getProject) | **GET** /project/{id_or_name} | 
*OSDNClient.ProjectApi* | [**getRelease**](docs/ProjectApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**getReleaseFile**](docs/ProjectApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectApi* | [**listNews**](docs/ProjectApi.md#listNews) | **GET** /news | 
*OSDNClient.ProjectApi* | [**listNews_0**](docs/ProjectApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
*OSDNClient.ProjectApi* | [**listPackages**](docs/ProjectApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
*OSDNClient.ProjectApi* | [**updateNews**](docs/ProjectApi.md#updateNews) | **PATCH** /news/{news_id} | 
*OSDNClient.ProjectApi* | [**updateNews_0**](docs/ProjectApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectApi* | [**updatePackage**](docs/ProjectApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**updateRelease**](docs/ProjectApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**updateReleaseFile**](docs/ProjectApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectFrsApi* | [**createPackage**](docs/ProjectFrsApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
*OSDNClient.ProjectFrsApi* | [**createRelease**](docs/ProjectFrsApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**createReleaseFile**](docs/ProjectFrsApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**deletePackage**](docs/ProjectFrsApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**deleteRelease**](docs/ProjectFrsApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**deleteReleaseFile**](docs/ProjectFrsApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectFrsApi* | [**draftRelease**](docs/ProjectFrsApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*OSDNClient.ProjectFrsApi* | [**getPackage**](docs/ProjectFrsApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**getRelease**](docs/ProjectFrsApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**getReleaseFile**](docs/ProjectFrsApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectFrsApi* | [**listPackages**](docs/ProjectFrsApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
*OSDNClient.ProjectFrsApi* | [**updatePackage**](docs/ProjectFrsApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**updateRelease**](docs/ProjectFrsApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**updateReleaseFile**](docs/ProjectFrsApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectNewsApi* | [**createNews**](docs/ProjectNewsApi.md#createNews) | **POST** /news | 
*OSDNClient.ProjectNewsApi* | [**createNews_0**](docs/ProjectNewsApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
*OSDNClient.ProjectNewsApi* | [**deleteNews**](docs/ProjectNewsApi.md#deleteNews) | **DELETE** /news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**deleteNews_0**](docs/ProjectNewsApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**getNews**](docs/ProjectNewsApi.md#getNews) | **GET** /news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**getNews_0**](docs/ProjectNewsApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**listNews**](docs/ProjectNewsApi.md#listNews) | **GET** /news | 
*OSDNClient.ProjectNewsApi* | [**listNews_0**](docs/ProjectNewsApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
*OSDNClient.ProjectNewsApi* | [**updateNews**](docs/ProjectNewsApi.md#updateNews) | **PATCH** /news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**updateNews_0**](docs/ProjectNewsApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.UserApi* | [**getUser**](docs/UserApi.md#getUser) | **GET** /user/{id_or_name} | 


## Documentation for Models

 - [OSDNClient.Group](docs/Group.md)
 - [OSDNClient.GroupToolFlags](docs/GroupToolFlags.md)
 - [OSDNClient.ModelPackage](docs/ModelPackage.md)
 - [OSDNClient.News](docs/News.md)
 - [OSDNClient.Pong](docs/Pong.md)
 - [OSDNClient.RelFile](docs/RelFile.md)
 - [OSDNClient.Release](docs/Release.md)
 - [OSDNClient.SimpleChamber](docs/SimpleChamber.md)
 - [OSDNClient.SimpleGroup](docs/SimpleGroup.md)
 - [OSDNClient.SimpleUser](docs/SimpleUser.md)
 - [OSDNClient.Skill](docs/Skill.md)
 - [OSDNClient.Token](docs/Token.md)
 - [OSDNClient.User](docs/User.md)


## Documentation for Authorization


### oauth2-code

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://osdn.net/account/oauth2ui/authorize
- **Scopes**: 
  - profile: Read basic user profile
  - group: read access to group data
  - group_write: write access to group data
  - chamber: read access to chamber data
  - chamber_write: write access to chamber data

### oauth2-implicit

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://osdn.net/account/oauth2ui/authorize
- **Scopes**: 
  - profile: Read basic user profile
  - group: read access to group data
  - group_write: write access to group data
  - chamber: read access to chamber data
  - chamber_write: write access to chamber data

