# OSDNClient.ProjectApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createNews**](ProjectApi.md#createNews) | **POST** /news | 
[**createNews_0**](ProjectApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
[**createPackage**](ProjectApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
[**createRelease**](ProjectApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
[**createReleaseFile**](ProjectApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteNews**](ProjectApi.md#deleteNews) | **DELETE** /news/{news_id} | 
[**deleteNews_0**](ProjectApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
[**deletePackage**](ProjectApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
[**deleteRelease**](ProjectApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteReleaseFile**](ProjectApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**draftRelease**](ProjectApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
[**getNews**](ProjectApi.md#getNews) | **GET** /news/{news_id} | 
[**getNews_0**](ProjectApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
[**getPackage**](ProjectApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
[**getProject**](ProjectApi.md#getProject) | **GET** /project/{id_or_name} | 
[**getRelease**](ProjectApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**getReleaseFile**](ProjectApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**listNews**](ProjectApi.md#listNews) | **GET** /news | 
[**listNews_0**](ProjectApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
[**listPackages**](ProjectApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
[**updateNews**](ProjectApi.md#updateNews) | **PATCH** /news/{news_id} | 
[**updateNews_0**](ProjectApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
[**updatePackage**](ProjectApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
[**updateRelease**](ProjectApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**updateReleaseFile**](ProjectApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 


<a name="createNews"></a>
# **createNews**
> &#39;String&#39; createNews(title, body, groupId)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var title = "title_example"; // String | news title

var body = "body_example"; // String | news body in OSDN Wiki format.

var groupId = 56; // Integer | group_id the news created in


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createNews(title, body, groupId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **title** | **String**| news title | 
 **body** | **String**| news body in OSDN Wiki format. | 
 **groupId** | **Integer**| group_id the news created in | 

### Return type

**&#39;String&#39;**

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createNews_0"></a>
# **createNews_0**
> &#39;String&#39; createNews_0(idOrName, title, body)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var title = "title_example"; // String | news title

var body = "body_example"; // String | news body in OSDN Wiki format.


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createNews_0(idOrName, title, body, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **title** | **String**| news title | 
 **body** | **String**| news body in OSDN Wiki format. | 

### Return type

**&#39;String&#39;**

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createPackage"></a>
# **createPackage**
> ModelPackage createPackage(idOrName, name, opts)



Create a package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | package name

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createPackage(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| package name | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createRelease"></a>
# **createRelease**
> Release createRelease(idOrName, packageId, name, opts)



Create new release in specified package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var name = "name_example"; // String | Release name

var opts = { 
  'visibility': "visibility_example", // String | visibility status (public, hidden or private)
  'time': "time_example", // String | Release datetime. If you set future time, the release hide until specified time.
  'releaseNote': "releaseNote_example", // String | Release note body text.
  'changeLog': "changeLog_example" // String | Changelog body text.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createRelease(idOrName, packageId, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **name** | **String**| Release name | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 
 **time** | **String**| Release datetime. If you set future time, the release hide until specified time. | [optional] 
 **releaseNote** | **String**| Release note body text. | [optional] 
 **changeLog** | **String**| Changelog body text. | [optional] 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createReleaseFile"></a>
# **createReleaseFile**
> RelFile createReleaseFile(idOrName, packageId, releaseId, file, opts)



Create new file in target release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var file = "/path/to/file.txt"; // File | Upload file in \"multipart/form-data\".

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createReleaseFile(idOrName, packageId, releaseId, file, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **file** | **File**| Upload file in \&quot;multipart/form-data\&quot;. | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

<a name="deleteNews"></a>
# **deleteNews**
> deleteNews(newsId)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteNews(newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteNews_0"></a>
# **deleteNews_0**
> deleteNews_0(idOrName, newsId)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteNews_0(idOrName, newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **newsId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deletePackage"></a>
# **deletePackage**
> deletePackage(idOrName, packageId)



Delete taret package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deletePackage(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteRelease"></a>
# **deleteRelease**
> deleteRelease(idOrName, packageId, releaseId)



Delete target release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteRelease(idOrName, packageId, releaseId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteReleaseFile"></a>
# **deleteReleaseFile**
> deleteReleaseFile(idOrName, packageId, releaseId, fileId)



Delete target file.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteReleaseFile(idOrName, packageId, releaseId, fileId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="draftRelease"></a>
# **draftRelease**
> Release draftRelease(idOrName, packageId)



Get release draft in specified package. If draft is not exist, it will be created automatically.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.draftRelease(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getNews"></a>
# **getNews**
> News getNews(newsId)



Get single news object.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getNews(newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getNews_0"></a>
# **getNews_0**
> News getNews_0(idOrName, newsId)



Get single news object.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getNews_0(idOrName, newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **newsId** | **Integer**|  | 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getPackage"></a>
# **getPackage**
> ModelPackage getPackage(idOrName, packageId)



Get specified package info and release list of the package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getPackage(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProject"></a>
# **getProject**
> Group getProject(idOrName)



Get project info.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProject(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**Group**](Group.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getRelease"></a>
# **getRelease**
> Release getRelease(idOrName, packageId, releaseId)



Get specified release info and file list of the release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getRelease(idOrName, packageId, releaseId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getReleaseFile"></a>
# **getReleaseFile**
> RelFile getReleaseFile(idOrName, packageId, releaseId, fileId)



Get single file object.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getReleaseFile(idOrName, packageId, releaseId, fileId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listNews"></a>
# **listNews**
> [News] listNews(opts)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var opts = { 
  'groupId': 56 // Integer | filter by group ID
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listNews(opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **Integer**| filter by group ID | [optional] 

### Return type

[**[News]**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listNews_0"></a>
# **listNews_0**
> [News] listNews_0(idOrName)



Get news list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listNews_0(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[News]**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listPackages"></a>
# **listPackages**
> [ModelPackage] listPackages(idOrName)



Get package list of specified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listPackages(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ModelPackage]**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateNews"></a>
# **updateNews**
> News updateNews(newsId, opts)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 

var opts = { 
  'title': "title_example", // String | news title
  'body': "body_example" // String | news body in OSDN Wiki format.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateNews(newsId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 
 **title** | **String**| news title | [optional] 
 **body** | **String**| news body in OSDN Wiki format. | [optional] 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateNews_0"></a>
# **updateNews_0**
> News updateNews_0(newsId, idOrName, opts)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'title': "title_example", // String | news title
  'body': "body_example" // String | news body in OSDN Wiki format.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateNews_0(newsId, idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 
 **idOrName** | **String**| numeric project id or project name | 
 **title** | **String**| news title | [optional] 
 **body** | **String**| news body in OSDN Wiki format. | [optional] 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updatePackage"></a>
# **updatePackage**
> ModelPackage updatePackage(idOrName, packageId, opts)



Update tagret package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var opts = { 
  'name': "name_example", // String | package name
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updatePackage(idOrName, packageId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **name** | **String**| package name | [optional] 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateRelease"></a>
# **updateRelease**
> Release updateRelease(idOrName, packageId, releaseId, opts)



Update target release. (Note: If you update draft release, the release will be public automatically.) 

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var opts = { 
  'visibility': "visibility_example", // String | visibility status (public, hidden or private)
  'name': "name_example", // String | Release name
  'time': "time_example", // String | Release datetime. If you set future time, the release hide until specified time.
  'moveToPackageId': 56 // Integer | If this parameter is specified, the release move to another package.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateRelease(idOrName, packageId, releaseId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 
 **name** | **String**| Release name | [optional] 
 **time** | **String**| Release datetime. If you set future time, the release hide until specified time. | [optional] 
 **moveToPackageId** | **Integer**| If this parameter is specified, the release move to another package. | [optional] 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateReleaseFile"></a>
# **updateReleaseFile**
> RelFile updateReleaseFile(idOrName, packageId, releaseId, fileId, opts)



Change visibility of target file.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateReleaseFile(idOrName, packageId, releaseId, fileId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

