/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20161003
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/Pong', 'OSDN/OSDN\Model/Token'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../OSDN\Model/Pong'), require('../OSDN\Model/Token'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.DefaultApi = factory(root.OSDNClient.ApiClient, root.OSDNClient.Pong, root.OSDNClient.Token);
  }
}(this, function(ApiClient, Pong, Token) {
  'use strict';

  /**
   * Default service.
   * @module OSDN/OSDN\Api/DefaultApi
   * @version 0.0.20161003
   */

  /**
   * Constructs a new DefaultApi. 
   * @alias module:OSDN/OSDN\Api/DefaultApi
   * @class
   * @param {module:OSDN/ApiClient} apiClient Optional API client implementation to use,
   * default to {@link module:OSDN/ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the ping operation.
     * @callback module:OSDN/OSDN\Api/DefaultApi~pingCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Pong} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * return pong for test 
     * @param {module:OSDN/OSDN\Api/DefaultApi~pingCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Pong}
     */
    this.ping = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Pong;

      return this.apiClient.callApi(
        '/ping', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the token operation.
     * @callback module:OSDN/OSDN\Api/DefaultApi~tokenCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Token} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get access token by access code.
     * @param {String} clientId Your application ID
     * @param {String} clientSecret Your application secret (key)
     * @param {Object} opts Optional parameters
     * @param {String} opts.grantType \&quot;authorization_code\&quot; or \&quot;refresh_token\&quot; (default to authorization_code)
     * @param {String} opts.code Set auth code issued by https://osdn.net/account/oauth2ui/authorize for grant_type&#x3D;authorization_code
     * @param {String} opts.refreshToken Set refresh token to update access token.
     * @param {module:OSDN/OSDN\Api/DefaultApi~tokenCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Token}
     */
    this.token = function(clientId, clientSecret, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'clientId' is set
      if (clientId == undefined || clientId == null) {
        throw "Missing the required parameter 'clientId' when calling token";
      }

      // verify the required parameter 'clientSecret' is set
      if (clientSecret == undefined || clientSecret == null) {
        throw "Missing the required parameter 'clientSecret' when calling token";
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'client_id': clientId,
        'client_secret': clientSecret,
        'grant_type': opts['grantType'],
        'code': opts['code'],
        'refresh_token': opts['refreshToken']
      };

      var authNames = [];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Token;

      return this.apiClient.callApi(
        '/token', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
