/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20161003
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/News'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../OSDN\Model/News'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.ProjectNewsApi = factory(root.OSDNClient.ApiClient, root.OSDNClient.News);
  }
}(this, function(ApiClient, News) {
  'use strict';

  /**
   * ProjectNews service.
   * @module OSDN/OSDN\Api/ProjectNewsApi
   * @version 0.0.20161003
   */

  /**
   * Constructs a new ProjectNewsApi. 
   * @alias module:OSDN/OSDN\Api/ProjectNewsApi
   * @class
   * @param {module:OSDN/ApiClient} apiClient Optional API client implementation to use,
   * default to {@link module:OSDN/ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~createNewsCallback
     * @param {String} error Error message, if any.
     * @param {'String'} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} title news title
     * @param {String} body news body in OSDN Wiki format.
     * @param {Integer} groupId group_id the news created in
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~createNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {'String'}
     */
    this.createNews = function(title, body, groupId, callback) {
      var postBody = null;

      // verify the required parameter 'title' is set
      if (title == undefined || title == null) {
        throw "Missing the required parameter 'title' when calling createNews";
      }

      // verify the required parameter 'body' is set
      if (body == undefined || body == null) {
        throw "Missing the required parameter 'body' when calling createNews";
      }

      // verify the required parameter 'groupId' is set
      if (groupId == undefined || groupId == null) {
        throw "Missing the required parameter 'groupId' when calling createNews";
      }


      var pathParams = {
      };
      var queryParams = {
        'group_id': groupId
      };
      var headerParams = {
      };
      var formParams = {
        'title': title,
        'body': body
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = 'String';

      return this.apiClient.callApi(
        '/news', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~createNews_0Callback
     * @param {String} error Error message, if any.
     * @param {'String'} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} idOrName numeric project id or project name
     * @param {String} title news title
     * @param {String} body news body in OSDN Wiki format.
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~createNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {'String'}
     */
    this.createNews_0 = function(idOrName, title, body, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createNews_0";
      }

      // verify the required parameter 'title' is set
      if (title == undefined || title == null) {
        throw "Missing the required parameter 'title' when calling createNews_0";
      }

      // verify the required parameter 'body' is set
      if (body == undefined || body == null) {
        throw "Missing the required parameter 'body' when calling createNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'title': title,
        'body': body
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = 'String';

      return this.apiClient.callApi(
        '/project/{id_or_name}/news', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~deleteNewsCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~deleteNewsCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteNews = function(newsId, callback) {
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling deleteNews";
      }


      var pathParams = {
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/news/{news_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~deleteNews_0Callback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~deleteNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteNews_0 = function(idOrName, newsId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteNews_0";
      }

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling deleteNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/news/{news_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~getNewsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get single news object.
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~getNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.getNews = function(newsId, callback) {
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling getNews";
      }


      var pathParams = {
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/news/{news_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~getNews_0Callback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get single news object.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~getNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.getNews_0 = function(idOrName, newsId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getNews_0";
      }

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling getNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/project/{id_or_name}/news/{news_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~listNewsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/News>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.groupId filter by group ID
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~listNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/News>}
     */
    this.listNews = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'group_id': opts['groupId']
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [News];

      return this.apiClient.callApi(
        '/news', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~listNews_0Callback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/News>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get news list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~listNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/News>}
     */
    this.listNews_0 = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [News];

      return this.apiClient.callApi(
        '/project/{id_or_name}/news', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~updateNewsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Integer} newsId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.title news title
     * @param {String} opts.body news body in OSDN Wiki format.
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~updateNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.updateNews = function(newsId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling updateNews";
      }


      var pathParams = {
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'title': opts['title'],
        'body': opts['body']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/news/{news_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectNewsApi~updateNews_0Callback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Integer} newsId 
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {String} opts.title news title
     * @param {String} opts.body news body in OSDN Wiki format.
     * @param {module:OSDN/OSDN\Api/ProjectNewsApi~updateNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.updateNews_0 = function(newsId, idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling updateNews_0";
      }

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateNews_0";
      }


      var pathParams = {
        'news_id': newsId,
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'title': opts['title'],
        'body': opts['body']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/project/{id_or_name}/news/{news_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
