<?php
/**
 * RelFile
 *
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20161031
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Model;

use \ArrayAccess;

/**
 * RelFile Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     OSDN
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RelFile implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RelFile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'int',
        'name' => 'string',
        'date' => '\DateTime',
        'url' => 'string',
        'visibility' => 'string',
        'cascaded_visibility' => 'string',
        'release_id' => 'int',
        'size' => 'int',
        'digest_md5' => 'string',
        'digest_sha1' => 'string',
        'digest_sha256' => 'string',
        'download_count' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'date' => 'date',
        'url' => 'url',
        'visibility' => 'visibility',
        'cascaded_visibility' => 'cascaded_visibility',
        'release_id' => 'release_id',
        'size' => 'size',
        'digest_md5' => 'digest_md5',
        'digest_sha1' => 'digest_sha1',
        'digest_sha256' => 'digest_sha256',
        'download_count' => 'download_count'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'date' => 'setDate',
        'url' => 'setUrl',
        'visibility' => 'setVisibility',
        'cascaded_visibility' => 'setCascadedVisibility',
        'release_id' => 'setReleaseId',
        'size' => 'setSize',
        'digest_md5' => 'setDigestMd5',
        'digest_sha1' => 'setDigestSha1',
        'digest_sha256' => 'setDigestSha256',
        'download_count' => 'setDownloadCount'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'date' => 'getDate',
        'url' => 'getUrl',
        'visibility' => 'getVisibility',
        'cascaded_visibility' => 'getCascadedVisibility',
        'release_id' => 'getReleaseId',
        'size' => 'getSize',
        'digest_md5' => 'getDigestMd5',
        'digest_sha1' => 'getDigestSha1',
        'digest_sha256' => 'getDigestSha256',
        'download_count' => 'getDownloadCount'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['url'] = isset($data['url']) ? $data['url'] : null;
        $this->container['visibility'] = isset($data['visibility']) ? $data['visibility'] : null;
        $this->container['cascaded_visibility'] = isset($data['cascaded_visibility']) ? $data['cascaded_visibility'] : null;
        $this->container['release_id'] = isset($data['release_id']) ? $data['release_id'] : null;
        $this->container['size'] = isset($data['size']) ? $data['size'] : null;
        $this->container['digest_md5'] = isset($data['digest_md5']) ? $data['digest_md5'] : null;
        $this->container['digest_sha1'] = isset($data['digest_sha1']) ? $data['digest_sha1'] : null;
        $this->container['digest_sha256'] = isset($data['digest_sha256']) ? $data['digest_sha256'] : null;
        $this->container['download_count'] = isset($data['download_count']) ? $data['download_count'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param int $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets date
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     * @param \DateTime $date
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets url
     * @return string
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     * @param string $url
     * @return $this
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets visibility
     * @return string
     */
    public function getVisibility()
    {
        return $this->container['visibility'];
    }

    /**
     * Sets visibility
     * @param string $visibility
     * @return $this
     */
    public function setVisibility($visibility)
    {
        $this->container['visibility'] = $visibility;

        return $this;
    }

    /**
     * Gets cascaded_visibility
     * @return string
     */
    public function getCascadedVisibility()
    {
        return $this->container['cascaded_visibility'];
    }

    /**
     * Sets cascaded_visibility
     * @param string $cascaded_visibility
     * @return $this
     */
    public function setCascadedVisibility($cascaded_visibility)
    {
        $this->container['cascaded_visibility'] = $cascaded_visibility;

        return $this;
    }

    /**
     * Gets release_id
     * @return int
     */
    public function getReleaseId()
    {
        return $this->container['release_id'];
    }

    /**
     * Sets release_id
     * @param int $release_id
     * @return $this
     */
    public function setReleaseId($release_id)
    {
        $this->container['release_id'] = $release_id;

        return $this;
    }

    /**
     * Gets size
     * @return int
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     * @param int $size
     * @return $this
     */
    public function setSize($size)
    {
        $this->container['size'] = $size;

        return $this;
    }

    /**
     * Gets digest_md5
     * @return string
     */
    public function getDigestMd5()
    {
        return $this->container['digest_md5'];
    }

    /**
     * Sets digest_md5
     * @param string $digest_md5
     * @return $this
     */
    public function setDigestMd5($digest_md5)
    {
        $this->container['digest_md5'] = $digest_md5;

        return $this;
    }

    /**
     * Gets digest_sha1
     * @return string
     */
    public function getDigestSha1()
    {
        return $this->container['digest_sha1'];
    }

    /**
     * Sets digest_sha1
     * @param string $digest_sha1
     * @return $this
     */
    public function setDigestSha1($digest_sha1)
    {
        $this->container['digest_sha1'] = $digest_sha1;

        return $this;
    }

    /**
     * Gets digest_sha256
     * @return string
     */
    public function getDigestSha256()
    {
        return $this->container['digest_sha256'];
    }

    /**
     * Sets digest_sha256
     * @param string $digest_sha256
     * @return $this
     */
    public function setDigestSha256($digest_sha256)
    {
        $this->container['digest_sha256'] = $digest_sha256;

        return $this;
    }

    /**
     * Gets download_count
     * @return int
     */
    public function getDownloadCount()
    {
        return $this->container['download_count'];
    }

    /**
     * Sets download_count
     * @param int $download_count
     * @return $this
     */
    public function setDownloadCount($download_count)
    {
        $this->container['download_count'] = $download_count;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\OSDN\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\OSDN\ObjectSerializer::sanitizeForSerialization($this));
    }
}


