<?php
/**
 * ScmHook
 *
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20161031
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Model;

use \ArrayAccess;

/**
 * ScmHook Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     OSDN
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScmHook implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScmHook';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'int',
        'repository_id' => 'int',
        'repository_type' => 'string',
        'chamber_id' => 'int',
        'group_id' => 'int',
        'target_url' => 'string',
        'message' => 'string',
        'error_count' => 'int',
        'disabled' => 'bool',
        'triggered_at' => '\DateTime',
        'errors_at' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'repository_id' => 'repository_id',
        'repository_type' => 'repository_type',
        'chamber_id' => 'chamber_id',
        'group_id' => 'group_id',
        'target_url' => 'target_url',
        'message' => 'message',
        'error_count' => 'error_count',
        'disabled' => 'disabled',
        'triggered_at' => 'triggered_at',
        'errors_at' => 'errors_at'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'repository_id' => 'setRepositoryId',
        'repository_type' => 'setRepositoryType',
        'chamber_id' => 'setChamberId',
        'group_id' => 'setGroupId',
        'target_url' => 'setTargetUrl',
        'message' => 'setMessage',
        'error_count' => 'setErrorCount',
        'disabled' => 'setDisabled',
        'triggered_at' => 'setTriggeredAt',
        'errors_at' => 'setErrorsAt'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'repository_id' => 'getRepositoryId',
        'repository_type' => 'getRepositoryType',
        'chamber_id' => 'getChamberId',
        'group_id' => 'getGroupId',
        'target_url' => 'getTargetUrl',
        'message' => 'getMessage',
        'error_count' => 'getErrorCount',
        'disabled' => 'getDisabled',
        'triggered_at' => 'getTriggeredAt',
        'errors_at' => 'getErrorsAt'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['repository_id'] = isset($data['repository_id']) ? $data['repository_id'] : null;
        $this->container['repository_type'] = isset($data['repository_type']) ? $data['repository_type'] : null;
        $this->container['chamber_id'] = isset($data['chamber_id']) ? $data['chamber_id'] : null;
        $this->container['group_id'] = isset($data['group_id']) ? $data['group_id'] : null;
        $this->container['target_url'] = isset($data['target_url']) ? $data['target_url'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['error_count'] = isset($data['error_count']) ? $data['error_count'] : null;
        $this->container['disabled'] = isset($data['disabled']) ? $data['disabled'] : null;
        $this->container['triggered_at'] = isset($data['triggered_at']) ? $data['triggered_at'] : null;
        $this->container['errors_at'] = isset($data['errors_at']) ? $data['errors_at'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param int $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets repository_id
     * @return int
     */
    public function getRepositoryId()
    {
        return $this->container['repository_id'];
    }

    /**
     * Sets repository_id
     * @param int $repository_id
     * @return $this
     */
    public function setRepositoryId($repository_id)
    {
        $this->container['repository_id'] = $repository_id;

        return $this;
    }

    /**
     * Gets repository_type
     * @return string
     */
    public function getRepositoryType()
    {
        return $this->container['repository_type'];
    }

    /**
     * Sets repository_type
     * @param string $repository_type
     * @return $this
     */
    public function setRepositoryType($repository_type)
    {
        $this->container['repository_type'] = $repository_type;

        return $this;
    }

    /**
     * Gets chamber_id
     * @return int
     */
    public function getChamberId()
    {
        return $this->container['chamber_id'];
    }

    /**
     * Sets chamber_id
     * @param int $chamber_id
     * @return $this
     */
    public function setChamberId($chamber_id)
    {
        $this->container['chamber_id'] = $chamber_id;

        return $this;
    }

    /**
     * Gets group_id
     * @return int
     */
    public function getGroupId()
    {
        return $this->container['group_id'];
    }

    /**
     * Sets group_id
     * @param int $group_id
     * @return $this
     */
    public function setGroupId($group_id)
    {
        $this->container['group_id'] = $group_id;

        return $this;
    }

    /**
     * Gets target_url
     * @return string
     */
    public function getTargetUrl()
    {
        return $this->container['target_url'];
    }

    /**
     * Sets target_url
     * @param string $target_url
     * @return $this
     */
    public function setTargetUrl($target_url)
    {
        $this->container['target_url'] = $target_url;

        return $this;
    }

    /**
     * Gets message
     * @return string
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     * @param string $message
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets error_count
     * @return int
     */
    public function getErrorCount()
    {
        return $this->container['error_count'];
    }

    /**
     * Sets error_count
     * @param int $error_count
     * @return $this
     */
    public function setErrorCount($error_count)
    {
        $this->container['error_count'] = $error_count;

        return $this;
    }

    /**
     * Gets disabled
     * @return bool
     */
    public function getDisabled()
    {
        return $this->container['disabled'];
    }

    /**
     * Sets disabled
     * @param bool $disabled
     * @return $this
     */
    public function setDisabled($disabled)
    {
        $this->container['disabled'] = $disabled;

        return $this;
    }

    /**
     * Gets triggered_at
     * @return \DateTime
     */
    public function getTriggeredAt()
    {
        return $this->container['triggered_at'];
    }

    /**
     * Sets triggered_at
     * @param \DateTime $triggered_at
     * @return $this
     */
    public function setTriggeredAt($triggered_at)
    {
        $this->container['triggered_at'] = $triggered_at;

        return $this;
    }

    /**
     * Gets errors_at
     * @return \DateTime
     */
    public function getErrorsAt()
    {
        return $this->container['errors_at'];
    }

    /**
     * Sets errors_at
     * @param \DateTime $errors_at
     * @return $this
     */
    public function setErrorsAt($errors_at)
    {
        $this->container['errors_at'] = $errors_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\OSDN\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\OSDN\ObjectSerializer::sanitizeForSerialization($this));
    }
}


