<?php

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20161031
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * An example of a project-specific implementation.
 *
 * After registering this autoload function with SPL, the following line
 * would cause the function to attempt to load the \OSDN\Baz\Qux class
 * from /path/to/project/OSDNClient/Baz/Qux.php:
 *
 *      new \OSDN\Baz\Qux;
 *
 * @param string $class The fully-qualified class name.
 *
 * @return void
 */
spl_autoload_register(function ($class) {

    // project-specific namespace prefix
    $prefix = 'OSDN\\';

    // base directory for the namespace prefix
    $base_dir = __DIR__ . '/OSDNClient/';

    // does the class use the namespace prefix?
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // no, move to the next registered autoloader
        return;
    }

    // get the relative class name
    $relative_class = substr($class, $len);

    // replace the namespace prefix with the base directory, replace namespace
    // separators with directory separators in the relative class name, append
    // with .php
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    // if the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
});
