# OSDN\ProjectApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createNews**](ProjectApi.md#createNews) | **POST** /news | 
[**createNews_0**](ProjectApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
[**createPackage**](ProjectApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
[**createProjectBzr**](ProjectApi.md#createProjectBzr) | **POST** /project/{id_or_name}/bzr | 
[**createProjectGit**](ProjectApi.md#createProjectGit) | **POST** /project/{id_or_name}/git | 
[**createProjectGitHook**](ProjectApi.md#createProjectGitHook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
[**createProjectHg**](ProjectApi.md#createProjectHg) | **POST** /project/{id_or_name}/hg | 
[**createRelease**](ProjectApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
[**createReleaseFile**](ProjectApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteNews**](ProjectApi.md#deleteNews) | **DELETE** /news/{news_id} | 
[**deleteNews_0**](ProjectApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
[**deletePackage**](ProjectApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
[**deleteProjectGitHook**](ProjectApi.md#deleteProjectGitHook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**deleteRelease**](ProjectApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteReleaseFile**](ProjectApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**disableProjectBzr**](ProjectApi.md#disableProjectBzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
[**disableProjectGit**](ProjectApi.md#disableProjectGit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
[**disableProjectHg**](ProjectApi.md#disableProjectHg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
[**draftRelease**](ProjectApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
[**getNews**](ProjectApi.md#getNews) | **GET** /news/{news_id} | 
[**getNews_0**](ProjectApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
[**getPackage**](ProjectApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
[**getProject**](ProjectApi.md#getProject) | **GET** /project/{id_or_name} | 
[**getProjectAdminProjectweb**](ProjectApi.md#getProjectAdminProjectweb) | **GET** /project/{id_or_name}/admin/project_web | 
[**getProjectBzr**](ProjectApi.md#getProjectBzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
[**getProjectGit**](ProjectApi.md#getProjectGit) | **GET** /project/{id_or_name}/git/{repo_id} | 
[**getProjectGitHook**](ProjectApi.md#getProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**getProjectHg**](ProjectApi.md#getProjectHg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
[**getProjectProfile**](ProjectApi.md#getProjectProfile) | **GET** /project/{id_or_name}/admin/profile | 
[**getProjectSvn**](ProjectApi.md#getProjectSvn) | **GET** /project/{id_or_name}/svn | 
[**getProjectTools**](ProjectApi.md#getProjectTools) | **GET** /project/{id_or_name}/admin/tools | 
[**getRelease**](ProjectApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**getReleaseFile**](ProjectApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**listNews**](ProjectApi.md#listNews) | **GET** /news | 
[**listNews_0**](ProjectApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
[**listPackages**](ProjectApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
[**listProjectBzr**](ProjectApi.md#listProjectBzr) | **GET** /project/{id_or_name}/bzr | 
[**listProjectGit**](ProjectApi.md#listProjectGit) | **GET** /project/{id_or_name}/git | 
[**listProjectGitHook**](ProjectApi.md#listProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
[**listProjectHg**](ProjectApi.md#listProjectHg) | **GET** /project/{id_or_name}/hg | 
[**updateNews**](ProjectApi.md#updateNews) | **PATCH** /news/{news_id} | 
[**updateNews_0**](ProjectApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
[**updatePackage**](ProjectApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
[**updateProjectAdminProjectweb**](ProjectApi.md#updateProjectAdminProjectweb) | **PATCH** /project/{id_or_name}/admin/project_web | 
[**updateProjectBzr**](ProjectApi.md#updateProjectBzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
[**updateProjectGit**](ProjectApi.md#updateProjectGit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
[**updateProjectHg**](ProjectApi.md#updateProjectHg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 
[**updateProjectProfile**](ProjectApi.md#updateProjectProfile) | **PATCH** /project/{id_or_name}/admin/profile | 
[**updateProjectTools**](ProjectApi.md#updateProjectTools) | **PATCH** /project/{id_or_name}/admin/tools | 
[**updateRelease**](ProjectApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**updateReleaseFile**](ProjectApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 


# **createNews**
> string createNews($title, $body, $group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.
$group_id = 56; // int | group_id the news created in

try {
    $result = $api_instance->createNews($title, $body, $group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |
 **group_id** | **int**| group_id the news created in |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createNews_0**
> string createNews_0($id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->createNews_0($id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createPackage**
> \OSDN\Model\Package createPackage($id_or_name, $name, $visibility)



Create a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createPackage($id_or_name, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| package name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectBzr**
> \OSDN\Model\ProjectBzr createProjectBzr($id_or_name, $name, $description)



Create a new bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 

try {
    $result = $api_instance->createProjectBzr($id_or_name, $name, $description);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectGit**
> \OSDN\Model\ProjectGit createProjectGit($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward)



Create a new git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 
$mail_enabled = true; // bool | 
$mail_recipients = "mail_recipients_example"; // string | 
$allow_non_fast_forward = true; // bool | 

try {
    $result = $api_instance->createProjectGit($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]
 **mail_enabled** | **bool**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **allow_non_fast_forward** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectGitHook**
> \OSDN\Model\ScmHook createProjectGitHook($id_or_name, $repo_id, $target_url)



Create a new hook for project git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$target_url = "target_url_example"; // string | 

try {
    $result = $api_instance->createProjectGitHook($id_or_name, $repo_id, $target_url);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **target_url** | **string**|  |

### Return type

[**\OSDN\Model\ScmHook**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectHg**
> \OSDN\Model\ProjectHg createProjectHg($id_or_name, $name, $description, $mail_recipients)



Create a new hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 
$mail_recipients = "mail_recipients_example"; // string | 

try {
    $result = $api_instance->createProjectHg($id_or_name, $name, $description, $mail_recipients);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]
 **mail_recipients** | **string**|  | [optional]

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createRelease**
> \OSDN\Model\Release createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log)



Create new release in specified package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | Release name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$time = new \DateTime(); // \DateTime | Release datetime. If you set future time, the release hide until specified time.
$release_note = "release_note_example"; // string | Release note body text.
$change_log = "change_log_example"; // string | Changelog body text.

try {
    $result = $api_instance->createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| Release name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **time** | **\DateTime**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **release_note** | **string**| Release note body text. | [optional]
 **change_log** | **string**| Changelog body text. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createReleaseFile**
> \OSDN\Model\RelFile createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility)



Create new file in target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file = "/path/to/file.txt"; // \SplFileObject | Upload file in \"multipart/form-data\".
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file** | **\SplFileObject**| Upload file in \&quot;multipart/form-data\&quot;. |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews**
> deleteNews($news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 

try {
    $api_instance->deleteNews($news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews_0**
> deleteNews_0($id_or_name, $news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $api_instance->deleteNews_0($id_or_name, $news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deletePackage**
> deletePackage($id_or_name, $package_id)



Delete taret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $api_instance->deletePackage($id_or_name, $package_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deletePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectGitHook**
> deleteProjectGitHook($id_or_name, $repo_id, $hook_id)



Delete a Git repository hook

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$hook_id = 56; // int | 

try {
    $api_instance->deleteProjectGitHook($id_or_name, $repo_id, $hook_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **hook_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRelease**
> deleteRelease($id_or_name, $package_id, $release_id)



Delete target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $api_instance->deleteRelease($id_or_name, $package_id, $release_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteReleaseFile**
> deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Delete target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $api_instance->deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectBzr**
> \OSDN\Model\ProjectBzr disableProjectBzr($id_or_name, $repo_id)



Disable a bzr repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectBzr($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->disableProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectGit**
> \OSDN\Model\ProjectGit disableProjectGit($id_or_name, $repo_id)



Disable a git repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectGit($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->disableProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectHg**
> \OSDN\Model\ProjectHg disableProjectHg($id_or_name, $repo_id)



Disable a hg repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectHg($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->disableProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **draftRelease**
> \OSDN\Model\Release draftRelease($id_or_name, $package_id)



Get release draft in specified package. If draft is not exist, it will be created automatically.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->draftRelease($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->draftRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews**
> \OSDN\Model\News getNews($news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews($news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews_0**
> \OSDN\Model\News getNews_0($id_or_name, $news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews_0($id_or_name, $news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackage**
> \OSDN\Model\Package getPackage($id_or_name, $package_id)



Get specified package info and release list of the package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->getPackage($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProject**
> \OSDN\Model\Group getProject($id_or_name)



Get project info.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProject($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProject: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\Group**](../Model/Group.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectAdminProjectweb**
> \OSDN\Model\ProjectWeb getProjectAdminProjectweb($id_or_name)



Get project homepage url

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectAdminProjectweb($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectAdminProjectweb: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectWeb**](../Model/ProjectWeb.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectBzr**
> \OSDN\Model\ProjectBzr getProjectBzr($id_or_name, $repo_id)



Get a bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectBzr($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectGit**
> \OSDN\Model\ProjectGit getProjectGit($id_or_name, $repo_id)



Get a git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectGit($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectGitHook**
> \OSDN\Model\ScmHook getProjectGitHook($id_or_name, $repo_id, $hook_id)



Get a repository hook

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$hook_id = 56; // int | 

try {
    $result = $api_instance->getProjectGitHook($id_or_name, $repo_id, $hook_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **hook_id** | **int**|  |

### Return type

[**\OSDN\Model\ScmHook**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectHg**
> \OSDN\Model\ProjectHg getProjectHg($id_or_name, $repo_id)



Get a hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectHg($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectProfile**
> \OSDN\Model\GroupProfile getProjectProfile($id_or_name)



Get project profile.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectProfile($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectProfile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\GroupProfile**](../Model/GroupProfile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectSvn**
> \OSDN\Model\ProjectSvn getProjectSvn($id_or_name)



Get Subversion repository of the project

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectSvn($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectSvn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectSvn**](../Model/ProjectSvn.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTools**
> \OSDN\Model\GroupToolFlags getProjectTools($id_or_name)



Get project tools info.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectTools($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\GroupToolFlags**](../Model/GroupToolFlags.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRelease**
> \OSDN\Model\Release getRelease($id_or_name, $package_id, $release_id)



Get specified release info and file list of the release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $result = $api_instance->getRelease($id_or_name, $package_id, $release_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReleaseFile**
> \OSDN\Model\RelFile getReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Get single file object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $result = $api_instance->getReleaseFile($id_or_name, $package_id, $release_id, $file_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews**
> \OSDN\Model\News[] listNews($group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$group_id = 56; // int | filter by group ID

try {
    $result = $api_instance->listNews($group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_id** | **int**| filter by group ID | [optional]

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews_0**
> \OSDN\Model\News[] listNews_0($id_or_name)



Get news list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listNews_0($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listPackages**
> \OSDN\Model\Package[] listPackages($id_or_name)



Get package list of specified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listPackages($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listPackages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\Package[]**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectBzr**
> \OSDN\Model\ProjectBzr[] listProjectBzr($id_or_name)



Get Bazzar repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectBzr($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectBzr[]**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectGit**
> \OSDN\Model\ProjectGit[] listProjectGit($id_or_name)



Get git repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectGit($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectGit[]**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectGitHook**
> \OSDN\Model\ScmHook[] listProjectGitHook($id_or_name, $repo_id)



Get Git repository hook list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->listProjectGitHook($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ScmHook[]**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectHg**
> \OSDN\Model\ProjectHg[] listProjectHg($id_or_name)



Get Mercurial repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectHg($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectHg[]**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews**
> \OSDN\Model\News updateNews($news_id, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews($news_id, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews_0**
> \OSDN\Model\News updateNews_0($news_id, $id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews_0($news_id, $id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updatePackage**
> \OSDN\Model\Package updatePackage($id_or_name, $package_id, $name, $visibility)



Update tagret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updatePackage($id_or_name, $package_id, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updatePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| package name | [optional]
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectAdminProjectweb**
> \OSDN\Model\ProjectWeb updateProjectAdminProjectweb($id_or_name, $homepage)



Update project homepage url

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$homepage = "homepage_example"; // string | Project home page full URL (should start with http:// or https://)

try {
    $result = $api_instance->updateProjectAdminProjectweb($id_or_name, $homepage);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectAdminProjectweb: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **homepage** | **string**| Project home page full URL (should start with http:// or https://) | [optional]

### Return type

[**\OSDN\Model\ProjectWeb**](../Model/ProjectWeb.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectBzr**
> \OSDN\Model\ProjectBzr updateProjectBzr($id_or_name, $repo_id, $description, $active)



Update a bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectBzr($id_or_name, $repo_id, $description, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectGit**
> \OSDN\Model\ProjectGit updateProjectGit($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $active)



Update a git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$mail_enabled = true; // bool | 
$mail_recipients = "mail_recipients_example"; // string | 
$allow_non_fast_forward = true; // bool | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectGit($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **mail_enabled** | **bool**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **allow_non_fast_forward** | **bool**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectHg**
> \OSDN\Model\ProjectHg updateProjectHg($id_or_name, $repo_id, $description, $mail_recipients, $active)



Update a hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$mail_recipients = "mail_recipients_example"; // string | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectHg($id_or_name, $repo_id, $description, $mail_recipients, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectProfile**
> \OSDN\Model\GroupProfile updateProjectProfile($id_or_name, $language_code, $display_name, $description)



Update project profile.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$language_code = "language_code_example"; // string | Language code for updateing display name and/or description (example en, ja, zh-TW)
$display_name = "display_name_example"; // string | Project display name
$description = "description_example"; // string | Project description

try {
    $result = $api_instance->updateProjectProfile($id_or_name, $language_code, $display_name, $description);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectProfile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **language_code** | **string**| Language code for updateing display name and/or description (example en, ja, zh-TW) |
 **display_name** | **string**| Project display name | [optional]
 **description** | **string**| Project description | [optional]

### Return type

[**\OSDN\Model\GroupProfile**](../Model/GroupProfile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTools**
> \OSDN\Model\GroupToolFlags updateProjectTools($id_or_name, $git, $svn, $hg, $bzr, $frs, $ticket, $wiki, $forum, $ml)



Update project tools info.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$git = true; // bool | use git flag
$svn = true; // bool | use Subversion flag
$hg = true; // bool | use Mercurial(Hg) flag
$bzr = true; // bool | use Bazaar flag
$frs = true; // bool | use File Release flag
$ticket = true; // bool | use Ticket flag
$wiki = true; // bool | use Wiki flag
$forum = true; // bool | use Forum flag
$ml = true; // bool | use Mailing List flag

try {
    $result = $api_instance->updateProjectTools($id_or_name, $git, $svn, $hg, $bzr, $frs, $ticket, $wiki, $forum, $ml);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectTools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **git** | **bool**| use git flag | [optional]
 **svn** | **bool**| use Subversion flag | [optional]
 **hg** | **bool**| use Mercurial(Hg) flag | [optional]
 **bzr** | **bool**| use Bazaar flag | [optional]
 **frs** | **bool**| use File Release flag | [optional]
 **ticket** | **bool**| use Ticket flag | [optional]
 **wiki** | **bool**| use Wiki flag | [optional]
 **forum** | **bool**| use Forum flag | [optional]
 **ml** | **bool**| use Mailing List flag | [optional]

### Return type

[**\OSDN\Model\GroupToolFlags**](../Model/GroupToolFlags.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateRelease**
> \OSDN\Model\Release updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id)



Update target release. (Note: If you update draft release, the release will be public automatically.)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$name = "name_example"; // string | Release name
$time = new \DateTime(); // \DateTime | Release datetime. If you set future time, the release hide until specified time.
$move_to_package_id = 56; // int | If this parameter is specified, the release move to another package.

try {
    $result = $api_instance->updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **name** | **string**| Release name | [optional]
 **time** | **\DateTime**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **move_to_package_id** | **int**| If this parameter is specified, the release move to another package. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateReleaseFile**
> \OSDN\Model\RelFile updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility)



Change visibility of target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

