# OSDN\ProjectSCMApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createProjectBzr**](ProjectSCMApi.md#createProjectBzr) | **POST** /project/{id_or_name}/bzr | 
[**createProjectGit**](ProjectSCMApi.md#createProjectGit) | **POST** /project/{id_or_name}/git | 
[**createProjectGitHook**](ProjectSCMApi.md#createProjectGitHook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
[**createProjectHg**](ProjectSCMApi.md#createProjectHg) | **POST** /project/{id_or_name}/hg | 
[**deleteProjectGitHook**](ProjectSCMApi.md#deleteProjectGitHook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**disableProjectBzr**](ProjectSCMApi.md#disableProjectBzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
[**disableProjectGit**](ProjectSCMApi.md#disableProjectGit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
[**disableProjectHg**](ProjectSCMApi.md#disableProjectHg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
[**getProjectBzr**](ProjectSCMApi.md#getProjectBzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
[**getProjectGit**](ProjectSCMApi.md#getProjectGit) | **GET** /project/{id_or_name}/git/{repo_id} | 
[**getProjectGitHook**](ProjectSCMApi.md#getProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**getProjectHg**](ProjectSCMApi.md#getProjectHg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
[**getProjectSvn**](ProjectSCMApi.md#getProjectSvn) | **GET** /project/{id_or_name}/svn | 
[**listProjectBzr**](ProjectSCMApi.md#listProjectBzr) | **GET** /project/{id_or_name}/bzr | 
[**listProjectGit**](ProjectSCMApi.md#listProjectGit) | **GET** /project/{id_or_name}/git | 
[**listProjectGitHook**](ProjectSCMApi.md#listProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
[**listProjectHg**](ProjectSCMApi.md#listProjectHg) | **GET** /project/{id_or_name}/hg | 
[**updateProjectBzr**](ProjectSCMApi.md#updateProjectBzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
[**updateProjectGit**](ProjectSCMApi.md#updateProjectGit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
[**updateProjectHg**](ProjectSCMApi.md#updateProjectHg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 


# **createProjectBzr**
> \OSDN\Model\ProjectBzr createProjectBzr($id_or_name, $name, $description)



Create a new bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 

try {
    $result = $api_instance->createProjectBzr($id_or_name, $name, $description);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->createProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectGit**
> \OSDN\Model\ProjectGit createProjectGit($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward)



Create a new git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 
$mail_enabled = true; // bool | 
$mail_recipients = "mail_recipients_example"; // string | 
$allow_non_fast_forward = true; // bool | 

try {
    $result = $api_instance->createProjectGit($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->createProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]
 **mail_enabled** | **bool**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **allow_non_fast_forward** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectGitHook**
> \OSDN\Model\ScmHook createProjectGitHook($id_or_name, $repo_id, $target_url)



Create a new hook for project git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$target_url = "target_url_example"; // string | 

try {
    $result = $api_instance->createProjectGitHook($id_or_name, $repo_id, $target_url);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->createProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **target_url** | **string**|  |

### Return type

[**\OSDN\Model\ScmHook**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectHg**
> \OSDN\Model\ProjectHg createProjectHg($id_or_name, $name, $description, $mail_recipients)



Create a new hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 
$mail_recipients = "mail_recipients_example"; // string | 

try {
    $result = $api_instance->createProjectHg($id_or_name, $name, $description, $mail_recipients);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->createProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]
 **mail_recipients** | **string**|  | [optional]

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectGitHook**
> deleteProjectGitHook($id_or_name, $repo_id, $hook_id)



Delete a Git repository hook

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$hook_id = 56; // int | 

try {
    $api_instance->deleteProjectGitHook($id_or_name, $repo_id, $hook_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->deleteProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **hook_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectBzr**
> \OSDN\Model\ProjectBzr disableProjectBzr($id_or_name, $repo_id)



Disable a bzr repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectBzr($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->disableProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectGit**
> \OSDN\Model\ProjectGit disableProjectGit($id_or_name, $repo_id)



Disable a git repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectGit($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->disableProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectHg**
> \OSDN\Model\ProjectHg disableProjectHg($id_or_name, $repo_id)



Disable a hg repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectHg($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->disableProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectBzr**
> \OSDN\Model\ProjectBzr getProjectBzr($id_or_name, $repo_id)



Get a bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectBzr($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->getProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectGit**
> \OSDN\Model\ProjectGit getProjectGit($id_or_name, $repo_id)



Get a git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectGit($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->getProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectGitHook**
> \OSDN\Model\ScmHook getProjectGitHook($id_or_name, $repo_id, $hook_id)



Get a repository hook

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$hook_id = 56; // int | 

try {
    $result = $api_instance->getProjectGitHook($id_or_name, $repo_id, $hook_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->getProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **hook_id** | **int**|  |

### Return type

[**\OSDN\Model\ScmHook**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectHg**
> \OSDN\Model\ProjectHg getProjectHg($id_or_name, $repo_id)



Get a hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectHg($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->getProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectSvn**
> \OSDN\Model\ProjectSvn getProjectSvn($id_or_name)



Get Subversion repository of the project

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectSvn($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->getProjectSvn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectSvn**](../Model/ProjectSvn.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectBzr**
> \OSDN\Model\ProjectBzr[] listProjectBzr($id_or_name)



Get Bazzar repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectBzr($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->listProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectBzr[]**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectGit**
> \OSDN\Model\ProjectGit[] listProjectGit($id_or_name)



Get git repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectGit($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->listProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectGit[]**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectGitHook**
> \OSDN\Model\ScmHook[] listProjectGitHook($id_or_name, $repo_id)



Get Git repository hook list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->listProjectGitHook($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->listProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ScmHook[]**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectHg**
> \OSDN\Model\ProjectHg[] listProjectHg($id_or_name)



Get Mercurial repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectHg($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->listProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectHg[]**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectBzr**
> \OSDN\Model\ProjectBzr updateProjectBzr($id_or_name, $repo_id, $description, $active)



Update a bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectBzr($id_or_name, $repo_id, $description, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->updateProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectGit**
> \OSDN\Model\ProjectGit updateProjectGit($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $active)



Update a git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$mail_enabled = true; // bool | 
$mail_recipients = "mail_recipients_example"; // string | 
$allow_non_fast_forward = true; // bool | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectGit($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->updateProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **mail_enabled** | **bool**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **allow_non_fast_forward** | **bool**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectHg**
> \OSDN\Model\ProjectHg updateProjectHg($id_or_name, $repo_id, $description, $mail_recipients, $active)



Update a hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectSCMApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$mail_recipients = "mail_recipients_example"; // string | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectHg($id_or_name, $repo_id, $description, $mail_recipients, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectSCMApi->updateProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

