<?php
/**
 * ProjectApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * ProjectApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProjectApi
{

    /**
     * API Client
     *
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\OSDN\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.net/api/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \OSDN\ApiClient $apiClient set the API client
     *
     * @return ProjectApi
     */
    public function setApiClient(\OSDN\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createNews
     *
     * 
     *
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @param int $group_id group_id the news created in (required)
     * @return string
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNews($title, $body, $group_id)
    {
        list($response) = $this->createNewsWithHttpInfo($title, $body, $group_id);
        return $response;
    }

    /**
     * Operation createNewsWithHttpInfo
     *
     * 
     *
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @param int $group_id group_id the news created in (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNewsWithHttpInfo($title, $body, $group_id)
    {
        // verify the required parameter 'title' is set
        if ($title === null) {
            throw new \InvalidArgumentException('Missing the required parameter $title when calling createNews');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createNews');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling createNews');
        }
        // parse inputs
        $resourcePath = "/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($group_id !== null) {
            $queryParams['group_id'] = $this->apiClient->getSerializer()->toQueryValue($group_id);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @return string
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNews_0($id_or_name, $title, $body)
    {
        list($response) = $this->createNews_0WithHttpInfo($id_or_name, $title, $body);
        return $response;
    }

    /**
     * Operation createNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (required)
     * @param string $body news body in OSDN Wiki format. (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createNews_0WithHttpInfo($id_or_name, $title, $body)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createNews_0');
        }
        // verify the required parameter 'title' is set
        if ($title === null) {
            throw new \InvalidArgumentException('Missing the required parameter $title when calling createNews_0');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/project/{id_or_name}/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createPackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name package name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createPackage($id_or_name, $name, $visibility = null)
    {
        list($response) = $this->createPackageWithHttpInfo($id_or_name, $name, $visibility);
        return $response;
    }

    /**
     * Operation createPackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name package name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createPackageWithHttpInfo($id_or_name, $name, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createPackage');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createPackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package',
                '/project/{id_or_name}/frs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectBzr($id_or_name, $name, $description = null)
    {
        list($response) = $this->createProjectBzrWithHttpInfo($id_or_name, $name, $description);
        return $response;
    }

    /**
     * Operation createProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectBzrWithHttpInfo($id_or_name, $name, $description = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectBzr');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGit($id_or_name, $name, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null)
    {
        list($response) = $this->createProjectGitWithHttpInfo($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch);
        return $response;
    }

    /**
     * Operation createProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGitWithHttpInfo($id_or_name, $name, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectGit');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_enabled !== null) {
            $formParams['mail_enabled'] = $this->apiClient->getSerializer()->toFormValue($mail_enabled);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        // form params
        if ($allow_non_fast_forward !== null) {
            $formParams['allow_non_fast_forward'] = $this->apiClient->getSerializer()->toFormValue($allow_non_fast_forward);
        }
        // form params
        if ($default_branch !== null) {
            $formParams['default_branch'] = $this->apiClient->getSerializer()->toFormValue($default_branch);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $target_url  (required)
     * @return \OSDN\Model\ScmHook
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGitHook($id_or_name, $repo_id, $target_url)
    {
        list($response) = $this->createProjectGitHookWithHttpInfo($id_or_name, $repo_id, $target_url);
        return $response;
    }

    /**
     * Operation createProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $target_url  (required)
     * @return Array of \OSDN\Model\ScmHook, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectGitHookWithHttpInfo($id_or_name, $repo_id, $target_url)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling createProjectGitHook');
        }
        // verify the required parameter 'target_url' is set
        if ($target_url === null) {
            throw new \InvalidArgumentException('Missing the required parameter $target_url when calling createProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($target_url !== null) {
            $formParams['target_url'] = $this->apiClient->getSerializer()->toFormValue($target_url);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ScmHook',
                '/project/{id_or_name}/git/{repo_id}/hooks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ScmHook', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ScmHook', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectHg($id_or_name, $name, $description = null, $mail_recipients = null)
    {
        list($response) = $this->createProjectHgWithHttpInfo($id_or_name, $name, $description, $mail_recipients);
        return $response;
    }

    /**
     * Operation createProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectHgWithHttpInfo($id_or_name, $name, $description = null, $mail_recipients = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectHg');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectProfile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $display_name Project display name (required)
     * @param string $description Project description (required)
     * @return \OSDN\Model\GroupProfile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectProfile($id_or_name, $language_code, $display_name, $description)
    {
        list($response) = $this->createProjectProfileWithHttpInfo($id_or_name, $language_code, $display_name, $description);
        return $response;
    }

    /**
     * Operation createProjectProfileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $display_name Project display name (required)
     * @param string $description Project description (required)
     * @return Array of \OSDN\Model\GroupProfile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectProfileWithHttpInfo($id_or_name, $language_code, $display_name, $description)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectProfile');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling createProjectProfile');
        }
        // verify the required parameter 'display_name' is set
        if ($display_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $display_name when calling createProjectProfile');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectProfile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/profile";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($language_code !== null) {
            $formParams['language_code'] = $this->apiClient->getSerializer()->toFormValue($language_code);
        }
        // form params
        if ($display_name !== null) {
            $formParams['display_name'] = $this->apiClient->getSerializer()->toFormValue($display_name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\GroupProfile',
                '/project/{id_or_name}/admin/profile'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\GroupProfile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\GroupProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Project ticket name (title) (required)
     * @param string $description Project ticket description details (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @return \OSDN\Model\ProjectTicketItem
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicket($id_or_name, $name, $description, $type_id, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null)
    {
        list($response) = $this->createProjectTicketWithHttpInfo($id_or_name, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner);
        return $response;
    }

    /**
     * Operation createProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Project ticket name (title) (required)
     * @param string $description Project ticket description details (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @return Array of \OSDN\Model\ProjectTicketItem, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketWithHttpInfo($id_or_name, $name, $description, $type_id, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicket');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicket');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicket');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling createProjectTicket');
        }
        if ($priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectApi.createProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectApi.createProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectApi.createProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectApi.createProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($owner < 101.0) {
            throw new \InvalidArgumentException('invalid value for "$owner" when calling ProjectApi.createProjectTicket, must be bigger than or equal to 101.0.');
        }

        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($type_id !== null) {
            $formParams['type_id'] = $this->apiClient->getSerializer()->toFormValue($type_id);
        }
        // form params
        if ($milestone_id !== null) {
            $formParams['milestone_id'] = $this->apiClient->getSerializer()->toFormValue($milestone_id);
        }
        // form params
        if ($component_id !== null) {
            $formParams['component_id'] = $this->apiClient->getSerializer()->toFormValue($component_id);
        }
        // form params
        if ($priority !== null) {
            $formParams['priority'] = $this->apiClient->getSerializer()->toFormValue($priority);
        }
        // form params
        if ($severity !== null) {
            $formParams['severity'] = $this->apiClient->getSerializer()->toFormValue($severity);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem',
                '/project/{id_or_name}/ticket'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketComment
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $comment Ticket comment text (required)
     * @return \OSDN\Model\ProjectTicketComment
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketComment($id_or_name, $ticket_id, $comment)
    {
        list($response) = $this->createProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment);
        return $response;
    }

    /**
     * Operation createProjectTicketCommentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $comment Ticket comment text (required)
     * @return Array of \OSDN\Model\ProjectTicketComment, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketComment');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling createProjectTicketComment');
        }
        // verify the required parameter 'comment' is set
        if ($comment === null) {
            throw new \InvalidArgumentException('Missing the required parameter $comment when calling createProjectTicketComment');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}/comment";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($comment !== null) {
            $formParams['comment'] = $this->apiClient->getSerializer()->toFormValue($comment);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComment',
                '/project/{id_or_name}/ticket/{ticket_id}/comment'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComment', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComment', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket component name (required)
     * @param string $description Ticket component description (required)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return \OSDN\Model\ProjectTicketComponent[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketComponent($id_or_name, $name, $description, $owner = null, $active = null)
    {
        list($response) = $this->createProjectTicketComponentWithHttpInfo($id_or_name, $name, $description, $owner, $active);
        return $response;
    }

    /**
     * Operation createProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket component name (required)
     * @param string $description Ticket component description (required)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return Array of \OSDN\Model\ProjectTicketComponent[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketComponentWithHttpInfo($id_or_name, $name, $description, $owner = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketComponent');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicketComponent');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent[]',
                '/project/{id_or_name}/ticket/component'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket milestone name (required)
     * @param string $description Ticket milestone description (required)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @return \OSDN\Model\ProjectTicketMilestone
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketMilestone($id_or_name, $name, $description, $start = null, $end = null)
    {
        list($response) = $this->createProjectTicketMilestoneWithHttpInfo($id_or_name, $name, $description, $start, $end);
        return $response;
    }

    /**
     * Operation createProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket milestone name (required)
     * @param string $description Ticket milestone description (required)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @return Array of \OSDN\Model\ProjectTicketMilestone, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketMilestoneWithHttpInfo($id_or_name, $name, $description, $start = null, $end = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketMilestone');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicketMilestone');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($start !== null) {
            $formParams['start'] = $this->apiClient->getSerializer()->toFormValue($start);
        }
        // form params
        if ($end !== null) {
            $formParams['end'] = $this->apiClient->getSerializer()->toFormValue($end);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketMilestone',
                '/project/{id_or_name}/ticket/milestone'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketMilestone', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketMilestone', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket type name (required)
     * @param string $description Ticket type description (required)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return \OSDN\Model\ProjectTicketType
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketType($id_or_name, $name, $description, $is_public = null)
    {
        list($response) = $this->createProjectTicketTypeWithHttpInfo($id_or_name, $name, $description, $is_public);
        return $response;
    }

    /**
     * Operation createProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket type name (required)
     * @param string $description Ticket type description (required)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return Array of \OSDN\Model\ProjectTicketType, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketTypeWithHttpInfo($id_or_name, $name, $description, $is_public = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketType');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicketType');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($is_public !== null) {
            $formParams['is_public'] = $this->apiClient->getSerializer()->toFormValue($is_public);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType',
                '/project/{id_or_name}/ticket/type'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructionPerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketTypeInstruction($id_or_name, $type_id, $language_code, $instruction)
    {
        list($response) = $this->createProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code, $instruction);
        return $response;
    }

    /**
     * Operation createProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructionPerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code, $instruction)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling createProjectTicketTypeInstruction');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling createProjectTicketTypeInstruction');
        }
        // verify the required parameter 'instruction' is set
        if ($instruction === null) {
            throw new \InvalidArgumentException('Missing the required parameter $instruction when calling createProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($language_code !== null) {
            $formParams['language_code'] = $this->apiClient->getSerializer()->toFormValue($language_code);
        }
        // form params
        if ($instruction !== null) {
            $formParams['instruction'] = $this->apiClient->getSerializer()->toFormValue($instruction);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name Release name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param string $release_note Release note body text. (optional)
     * @param string $change_log Changelog body text. (optional)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createRelease($id_or_name, $package_id, $name, $visibility = null, $time = null, $release_note = null, $change_log = null)
    {
        list($response) = $this->createReleaseWithHttpInfo($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log);
        return $response;
    }

    /**
     * Operation createReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name Release name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param string $release_note Release note body text. (optional)
     * @param string $change_log Changelog body text. (optional)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseWithHttpInfo($id_or_name, $package_id, $name, $visibility = null, $time = null, $release_note = null, $change_log = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling createRelease');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($time !== null) {
            $formParams['time'] = $this->apiClient->getSerializer()->toFormValue($time);
        }
        // form params
        if ($release_note !== null) {
            $formParams['release_note'] = $this->apiClient->getSerializer()->toFormValue($release_note);
        }
        // form params
        if ($change_log !== null) {
            $formParams['change_log'] = $this->apiClient->getSerializer()->toFormValue($change_log);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param \SplFileObject $file Upload file in \&quot;multipart/form-data\&quot;. (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility = null)
    {
        list($response) = $this->createReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file, $visibility);
        return $response;
    }

    /**
     * Operation createReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param \SplFileObject $file Upload file in \&quot;multipart/form-data\&quot;. (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling createReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling createReleaseFile');
        }
        // verify the required parameter 'file' is set
        if ($file === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file when calling createReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('multipart/form-data'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        // form params
        if ($file !== null) {
            // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
            // See: https://wiki.php.net/rfc/curl-file-upload
            if (function_exists('curl_file_create')) {
                $formParams['file'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($file));
            } else {
                $formParams['file'] = '@' . $this->apiClient->getSerializer()->toFormValue($file);
            }
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\RelFile',
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteNews
     *
     * 
     *
     * @param int $news_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNews($news_id)
    {
        list($response) = $this->deleteNewsWithHttpInfo($news_id);
        return $response;
    }

    /**
     * Operation deleteNewsWithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNewsWithHttpInfo($news_id)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling deleteNews');
        }
        // parse inputs
        $resourcePath = "/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/news/{news_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNews_0($id_or_name, $news_id)
    {
        list($response) = $this->deleteNews_0WithHttpInfo($id_or_name, $news_id);
        return $response;
    }

    /**
     * Operation deleteNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteNews_0WithHttpInfo($id_or_name, $news_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteNews_0');
        }
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling deleteNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/news/{news_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deletePackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deletePackage($id_or_name, $package_id)
    {
        list($response) = $this->deletePackageWithHttpInfo($id_or_name, $package_id);
        return $response;
    }

    /**
     * Operation deletePackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deletePackageWithHttpInfo($id_or_name, $package_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deletePackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deletePackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectAdminProjectweb
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectAdminProjectweb($id_or_name)
    {
        list($response) = $this->deleteProjectAdminProjectwebWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation deleteProjectAdminProjectwebWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectAdminProjectwebWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectAdminProjectweb');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/project_web";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/admin/project_web'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectGitHook($id_or_name, $repo_id, $hook_id)
    {
        list($response) = $this->deleteProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id);
        return $response;
    }

    /**
     * Operation deleteProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling deleteProjectGitHook');
        }
        // verify the required parameter 'hook_id' is set
        if ($hook_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $hook_id when calling deleteProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // path params
        if ($hook_id !== null) {
            $resourcePath = str_replace(
                "{" . "hook_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($hook_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectProfile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectProfile($id_or_name, $language_code)
    {
        list($response) = $this->deleteProjectProfileWithHttpInfo($id_or_name, $language_code);
        return $response;
    }

    /**
     * Operation deleteProjectProfileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectProfileWithHttpInfo($id_or_name, $language_code)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectProfile');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling deleteProjectProfile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/profile/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/admin/profile/{language_code}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket component_id (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketComponent($id_or_name, $component_id, $migrate_to)
    {
        list($response) = $this->deleteProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $migrate_to);
        return $response;
    }

    /**
     * Operation deleteProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket component_id (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $migrate_to)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketComponent');
        }
        // verify the required parameter 'component_id' is set
        if ($component_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $component_id when calling deleteProjectTicketComponent');
        }
        // verify the required parameter 'migrate_to' is set
        if ($migrate_to === null) {
            throw new \InvalidArgumentException('Missing the required parameter $migrate_to when calling deleteProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component/{component_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($migrate_to !== null) {
            $queryParams['migrate_to'] = $this->apiClient->getSerializer()->toQueryValue($migrate_to);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($component_id !== null) {
            $resourcePath = str_replace(
                "{" . "component_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($component_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/component/{component_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket milestone_id (optional)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketMilestone($id_or_name, $milestone_id, $migrate_to = null)
    {
        list($response) = $this->deleteProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $migrate_to);
        return $response;
    }

    /**
     * Operation deleteProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket milestone_id (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $migrate_to = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketMilestone');
        }
        // verify the required parameter 'milestone_id' is set
        if ($milestone_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestone_id when calling deleteProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone/{milestone_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($migrate_to !== null) {
            $queryParams['migrate_to'] = $this->apiClient->getSerializer()->toQueryValue($migrate_to);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($milestone_id !== null) {
            $resourcePath = str_replace(
                "{" . "milestone_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestone_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/milestone/{milestone_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket type_id (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketType($id_or_name, $type_id, $migrate_to)
    {
        list($response) = $this->deleteProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $migrate_to);
        return $response;
    }

    /**
     * Operation deleteProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket type_id (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $migrate_to)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketType');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling deleteProjectTicketType');
        }
        // verify the required parameter 'migrate_to' is set
        if ($migrate_to === null) {
            throw new \InvalidArgumentException('Missing the required parameter $migrate_to when calling deleteProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($migrate_to !== null) {
            $queryParams['migrate_to'] = $this->apiClient->getSerializer()->toQueryValue($migrate_to);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/type/{type_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)
    {
        list($response) = $this->deleteProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code);
        return $response;
    }

    /**
     * Operation deleteProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling deleteProjectTicketTypeInstruction');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling deleteProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteRelease($id_or_name, $package_id, $release_id)
    {
        list($response) = $this->deleteReleaseWithHttpInfo($id_or_name, $package_id, $release_id);
        return $response;
    }

    /**
     * Operation deleteReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseWithHttpInfo($id_or_name, $package_id, $release_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deleteRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling deleteRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id)
    {
        list($response) = $this->deleteReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id);
        return $response;
    }

    /**
     * Operation deleteReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deleteReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling deleteReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling deleteReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation disableProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectBzr($id_or_name, $repo_id)
    {
        list($response) = $this->disableProjectBzrWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation disableProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectBzrWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling disableProjectBzr');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling disableProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation disableProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectGit($id_or_name, $repo_id)
    {
        list($response) = $this->disableProjectGitWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation disableProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectGitWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling disableProjectGit');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling disableProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation disableProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectHg($id_or_name, $repo_id)
    {
        list($response) = $this->disableProjectHgWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation disableProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function disableProjectHgWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling disableProjectHg');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling disableProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation draftRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function draftRelease($id_or_name, $package_id)
    {
        list($response) = $this->draftReleaseWithHttpInfo($id_or_name, $package_id);
        return $response;
    }

    /**
     * Operation draftReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function draftReleaseWithHttpInfo($id_or_name, $package_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling draftRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling draftRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/draft";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}/draft'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFrsAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\FrsAdminPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getFrsAdminprefs($id_or_name)
    {
        list($response) = $this->getFrsAdminprefsWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getFrsAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\FrsAdminPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getFrsAdminprefsWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getFrsAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\FrsAdminPrefs',
                '/project/{id_or_name}/frs/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\FrsAdminPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\FrsAdminPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNews
     *
     * 
     *
     * @param int $news_id  (required)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNews($news_id)
    {
        list($response) = $this->getNewsWithHttpInfo($news_id);
        return $response;
    }

    /**
     * Operation getNewsWithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNewsWithHttpInfo($news_id)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling getNews');
        }
        // parse inputs
        $resourcePath = "/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNews_0($id_or_name, $news_id)
    {
        list($response) = $this->getNews_0WithHttpInfo($id_or_name, $news_id);
        return $response;
    }

    /**
     * Operation getNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $news_id  (required)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getNews_0WithHttpInfo($id_or_name, $news_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getNews_0');
        }
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling getNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/project/{id_or_name}/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getPackage($id_or_name, $package_id)
    {
        list($response) = $this->getPackageWithHttpInfo($id_or_name, $package_id);
        return $response;
    }

    /**
     * Operation getPackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getPackageWithHttpInfo($id_or_name, $package_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getPackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getPackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package',
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProject
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\Group
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProject($id_or_name)
    {
        list($response) = $this->getProjectWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getProjectWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\Group, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProject');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Group',
                '/project/{id_or_name}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Group', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Group', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectAdminProjectweb
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectWeb
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectAdminProjectweb($id_or_name)
    {
        list($response) = $this->getProjectAdminProjectwebWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getProjectAdminProjectwebWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectWeb, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectAdminProjectwebWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectAdminProjectweb');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/project_web";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectWeb',
                '/project/{id_or_name}/admin/project_web'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectWeb', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectWeb', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectBzr($id_or_name, $repo_id)
    {
        list($response) = $this->getProjectBzrWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation getProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectBzrWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectBzr');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGit($id_or_name, $repo_id)
    {
        list($response) = $this->getProjectGitWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation getProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGitWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectGit');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return \OSDN\Model\ScmHook
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGitHook($id_or_name, $repo_id, $hook_id)
    {
        list($response) = $this->getProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id);
        return $response;
    }

    /**
     * Operation getProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param int $hook_id  (required)
     * @return Array of \OSDN\Model\ScmHook, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectGitHookWithHttpInfo($id_or_name, $repo_id, $hook_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectGitHook');
        }
        // verify the required parameter 'hook_id' is set
        if ($hook_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $hook_id when calling getProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // path params
        if ($hook_id !== null) {
            $resourcePath = str_replace(
                "{" . "hook_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($hook_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ScmHook',
                '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ScmHook', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ScmHook', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectHg($id_or_name, $repo_id)
    {
        list($response) = $this->getProjectHgWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation getProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectHgWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectHg');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling getProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectHistories
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\History[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectHistories($id_or_name)
    {
        list($response) = $this->getProjectHistoriesWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getProjectHistoriesWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\History[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectHistoriesWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectHistories');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/history";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\History[]',
                '/project/{id_or_name}/history'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\History[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\History[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectProfile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return \OSDN\Model\GroupProfilePerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectProfile($id_or_name, $language_code)
    {
        list($response) = $this->getProjectProfileWithHttpInfo($id_or_name, $language_code);
        return $response;
    }

    /**
     * Operation getProjectProfileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return Array of \OSDN\Model\GroupProfilePerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectProfileWithHttpInfo($id_or_name, $language_code)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectProfile');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling getProjectProfile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/profile/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\GroupProfilePerLanguage',
                '/project/{id_or_name}/admin/profile/{language_code}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\GroupProfilePerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\GroupProfilePerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectProfileList
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\GroupProfile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectProfileList($id_or_name)
    {
        list($response) = $this->getProjectProfileListWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getProjectProfileListWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\GroupProfile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectProfileListWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectProfileList');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/profile";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\GroupProfile',
                '/project/{id_or_name}/admin/profile'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\GroupProfile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\GroupProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectSvn
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectSvn
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectSvn($id_or_name)
    {
        list($response) = $this->getProjectSvnWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getProjectSvnWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectSvn, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectSvnWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectSvn');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/svn";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectSvn',
                '/project/{id_or_name}/svn'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectSvn', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectSvn', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return \OSDN\Model\ProjectTicketItem
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicket($id_or_name, $ticket_id)
    {
        list($response) = $this->getProjectTicketWithHttpInfo($id_or_name, $ticket_id);
        return $response;
    }

    /**
     * Operation getProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return Array of \OSDN\Model\ProjectTicketItem, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketWithHttpInfo($id_or_name, $ticket_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicket');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling getProjectTicket');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem',
                '/project/{id_or_name}/ticket/{ticket_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @return \OSDN\Model\ProjectTicketComponent
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketComponent($id_or_name, $component_id)
    {
        list($response) = $this->getProjectTicketComponentWithHttpInfo($id_or_name, $component_id);
        return $response;
    }

    /**
     * Operation getProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @return Array of \OSDN\Model\ProjectTicketComponent, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketComponentWithHttpInfo($id_or_name, $component_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketComponent');
        }
        // verify the required parameter 'component_id' is set
        if ($component_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $component_id when calling getProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component/{component_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($component_id !== null) {
            $resourcePath = str_replace(
                "{" . "component_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($component_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent',
                '/project/{id_or_name}/ticket/component/{component_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @return \OSDN\Model\ProjectTicketMilestone
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketMilestone($id_or_name, $milestone_id)
    {
        list($response) = $this->getProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id);
        return $response;
    }

    /**
     * Operation getProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @return Array of \OSDN\Model\ProjectTicketMilestone, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketMilestone');
        }
        // verify the required parameter 'milestone_id' is set
        if ($milestone_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestone_id when calling getProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone/{milestone_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($milestone_id !== null) {
            $resourcePath = str_replace(
                "{" . "milestone_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestone_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketMilestone',
                '/project/{id_or_name}/ticket/milestone/{milestone_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketMilestone', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketMilestone', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return \OSDN\Model\ProjectTicketType
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketType($id_or_name, $type_id)
    {
        list($response) = $this->getProjectTicketTypeWithHttpInfo($id_or_name, $type_id);
        return $response;
    }

    /**
     * Operation getProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return Array of \OSDN\Model\ProjectTicketType, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeWithHttpInfo($id_or_name, $type_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketType');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling getProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType',
                '/project/{id_or_name}/ticket/type/{type_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructionPerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)
    {
        list($response) = $this->getProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code);
        return $response;
    }

    /**
     * Operation getProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructionPerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling getProjectTicketTypeInstruction');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling getProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketTypeInstruction_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructionPerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstruction_0($id_or_name, $type_id, $language_code, $instruction)
    {
        list($response) = $this->getProjectTicketTypeInstruction_0WithHttpInfo($id_or_name, $type_id, $language_code, $instruction);
        return $response;
    }

    /**
     * Operation getProjectTicketTypeInstruction_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructionPerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstruction_0WithHttpInfo($id_or_name, $type_id, $language_code, $instruction)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketTypeInstruction_0');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling getProjectTicketTypeInstruction_0');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling getProjectTicketTypeInstruction_0');
        }
        // verify the required parameter 'instruction' is set
        if ($instruction === null) {
            throw new \InvalidArgumentException('Missing the required parameter $instruction when calling getProjectTicketTypeInstruction_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($instruction !== null) {
            $formParams['instruction'] = $this->apiClient->getSerializer()->toFormValue($instruction);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTools
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\GroupToolFlags
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTools($id_or_name)
    {
        list($response) = $this->getProjectToolsWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation getProjectToolsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\GroupToolFlags, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectToolsWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTools');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/tools";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\GroupToolFlags',
                '/project/{id_or_name}/admin/tools'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\GroupToolFlags', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\GroupToolFlags', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getRelease($id_or_name, $package_id, $release_id)
    {
        list($response) = $this->getReleaseWithHttpInfo($id_or_name, $package_id, $release_id);
        return $response;
    }

    /**
     * Operation getReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseWithHttpInfo($id_or_name, $package_id, $release_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling getRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseFile($id_or_name, $package_id, $release_id, $file_id)
    {
        list($response) = $this->getReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id);
        return $response;
    }

    /**
     * Operation getReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling getReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling getReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\RelFile',
                '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listNews
     *
     * 
     *
     * @param int $group_id filter by group ID (optional)
     * @return \OSDN\Model\News[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNews($group_id = null)
    {
        list($response) = $this->listNewsWithHttpInfo($group_id);
        return $response;
    }

    /**
     * Operation listNewsWithHttpInfo
     *
     * 
     *
     * @param int $group_id filter by group ID (optional)
     * @return Array of \OSDN\Model\News[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNewsWithHttpInfo($group_id = null)
    {
        // parse inputs
        $resourcePath = "/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($group_id !== null) {
            $queryParams['group_id'] = $this->apiClient->getSerializer()->toQueryValue($group_id);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News[]',
                '/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listNews_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\News[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNews_0($id_or_name)
    {
        list($response) = $this->listNews_0WithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listNews_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\News[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listNews_0WithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News[]',
                '/project/{id_or_name}/news'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPackages
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\Package[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listPackages($id_or_name)
    {
        list($response) = $this->listPackagesWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listPackagesWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\Package[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listPackagesWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listPackages');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package[]',
                '/project/{id_or_name}/frs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectBzr[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectBzr($id_or_name)
    {
        list($response) = $this->listProjectBzrWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectBzr[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectBzrWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr[]',
                '/project/{id_or_name}/bzr'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectGit[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGit($id_or_name)
    {
        list($response) = $this->listProjectGitWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectGit[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGitWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit[]',
                '/project/{id_or_name}/git'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectGitHook
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return \OSDN\Model\ScmHook[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGitHook($id_or_name, $repo_id)
    {
        list($response) = $this->listProjectGitHookWithHttpInfo($id_or_name, $repo_id);
        return $response;
    }

    /**
     * Operation listProjectGitHookWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @return Array of \OSDN\Model\ScmHook[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectGitHookWithHttpInfo($id_or_name, $repo_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectGitHook');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling listProjectGitHook');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}/hooks";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ScmHook[]',
                '/project/{id_or_name}/git/{repo_id}/hooks'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ScmHook[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ScmHook[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectHg[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectHg($id_or_name)
    {
        list($response) = $this->listProjectHgWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectHg[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectHgWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg[]',
                '/project/{id_or_name}/hg'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string[] $status Tickets are assigned to these type_ids (optional)
     * @param int[] $type_id Listing tickets are assigned to these type_ids (optional)
     * @param int[] $not_type_id Listing tickets are NOT assigned to these type_ids (optional)
     * @param int[] $component_id Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $not_component_id Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $milestone_id Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) (optional)
     * @param int[] $not_milestone_id Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) (optional)
     * @param int $max_priority Listing equal or lower priority tickets (optional)
     * @param int $min_priority Listing equal or higher priority tickets (optional)
     * @param int $priority Listing tickets have this priority (optional)
     * @param int $max_severity Listing equal or lower severity tickets (optional)
     * @param int $min_severity Listing equal or higher severity tickets (optional)
     * @param int $severity Listing tickets have this severity (optional)
     * @param int[] $owner Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $not_owner Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param int[] $not_reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param string $text Listing tickets title or description or comment include the text (optional)
     * @return \OSDN\Model\ProjectTicketItem[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicket($id_or_name, $status = null, $type_id = null, $not_type_id = null, $component_id = null, $not_component_id = null, $milestone_id = null, $not_milestone_id = null, $max_priority = null, $min_priority = null, $priority = null, $max_severity = null, $min_severity = null, $severity = null, $owner = null, $not_owner = null, $reporter = null, $not_reporter = null, $text = null)
    {
        list($response) = $this->listProjectTicketWithHttpInfo($id_or_name, $status, $type_id, $not_type_id, $component_id, $not_component_id, $milestone_id, $not_milestone_id, $max_priority, $min_priority, $priority, $max_severity, $min_severity, $severity, $owner, $not_owner, $reporter, $not_reporter, $text);
        return $response;
    }

    /**
     * Operation listProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string[] $status Tickets are assigned to these type_ids (optional)
     * @param int[] $type_id Listing tickets are assigned to these type_ids (optional)
     * @param int[] $not_type_id Listing tickets are NOT assigned to these type_ids (optional)
     * @param int[] $component_id Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $not_component_id Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $milestone_id Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) (optional)
     * @param int[] $not_milestone_id Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) (optional)
     * @param int $max_priority Listing equal or lower priority tickets (optional)
     * @param int $min_priority Listing equal or higher priority tickets (optional)
     * @param int $priority Listing tickets have this priority (optional)
     * @param int $max_severity Listing equal or lower severity tickets (optional)
     * @param int $min_severity Listing equal or higher severity tickets (optional)
     * @param int $severity Listing tickets have this severity (optional)
     * @param int[] $owner Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $not_owner Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param int[] $not_reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param string $text Listing tickets title or description or comment include the text (optional)
     * @return Array of \OSDN\Model\ProjectTicketItem[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketWithHttpInfo($id_or_name, $status = null, $type_id = null, $not_type_id = null, $component_id = null, $not_component_id = null, $milestone_id = null, $not_milestone_id = null, $max_priority = null, $min_priority = null, $priority = null, $max_severity = null, $min_severity = null, $severity = null, $owner = null, $not_owner = null, $reporter = null, $not_reporter = null, $text = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicket');
        }
        if ($max_priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$max_priority" when calling ProjectApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($max_priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$max_priority" when calling ProjectApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($min_priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$min_priority" when calling ProjectApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($min_priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$min_priority" when calling ProjectApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($max_severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$max_severity" when calling ProjectApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($max_severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$max_severity" when calling ProjectApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($min_severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$min_severity" when calling ProjectApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($min_severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$min_severity" when calling ProjectApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if (is_array($status)) {
            $status = $this->apiClient->getSerializer()->serializeCollection($status, 'csv', true);
        }
        if ($status !== null) {
            $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($status);
        }
        // query params
        if (is_array($type_id)) {
            $type_id = $this->apiClient->getSerializer()->serializeCollection($type_id, 'csv', true);
        }
        if ($type_id !== null) {
            $queryParams['type_id'] = $this->apiClient->getSerializer()->toQueryValue($type_id);
        }
        // query params
        if (is_array($not_type_id)) {
            $not_type_id = $this->apiClient->getSerializer()->serializeCollection($not_type_id, 'csv', true);
        }
        if ($not_type_id !== null) {
            $queryParams['not_type_id'] = $this->apiClient->getSerializer()->toQueryValue($not_type_id);
        }
        // query params
        if (is_array($component_id)) {
            $component_id = $this->apiClient->getSerializer()->serializeCollection($component_id, 'csv', true);
        }
        if ($component_id !== null) {
            $queryParams['component_id'] = $this->apiClient->getSerializer()->toQueryValue($component_id);
        }
        // query params
        if (is_array($not_component_id)) {
            $not_component_id = $this->apiClient->getSerializer()->serializeCollection($not_component_id, 'csv', true);
        }
        if ($not_component_id !== null) {
            $queryParams['not_component_id'] = $this->apiClient->getSerializer()->toQueryValue($not_component_id);
        }
        // query params
        if (is_array($milestone_id)) {
            $milestone_id = $this->apiClient->getSerializer()->serializeCollection($milestone_id, 'csv', true);
        }
        if ($milestone_id !== null) {
            $queryParams['milestone_id'] = $this->apiClient->getSerializer()->toQueryValue($milestone_id);
        }
        // query params
        if (is_array($not_milestone_id)) {
            $not_milestone_id = $this->apiClient->getSerializer()->serializeCollection($not_milestone_id, 'csv', true);
        }
        if ($not_milestone_id !== null) {
            $queryParams['not_milestone_id'] = $this->apiClient->getSerializer()->toQueryValue($not_milestone_id);
        }
        // query params
        if ($max_priority !== null) {
            $queryParams['max_priority'] = $this->apiClient->getSerializer()->toQueryValue($max_priority);
        }
        // query params
        if ($min_priority !== null) {
            $queryParams['min_priority'] = $this->apiClient->getSerializer()->toQueryValue($min_priority);
        }
        // query params
        if ($priority !== null) {
            $queryParams['priority'] = $this->apiClient->getSerializer()->toQueryValue($priority);
        }
        // query params
        if ($max_severity !== null) {
            $queryParams['max_severity'] = $this->apiClient->getSerializer()->toQueryValue($max_severity);
        }
        // query params
        if ($min_severity !== null) {
            $queryParams['min_severity'] = $this->apiClient->getSerializer()->toQueryValue($min_severity);
        }
        // query params
        if ($severity !== null) {
            $queryParams['severity'] = $this->apiClient->getSerializer()->toQueryValue($severity);
        }
        // query params
        if (is_array($owner)) {
            $owner = $this->apiClient->getSerializer()->serializeCollection($owner, 'csv', true);
        }
        if ($owner !== null) {
            $queryParams['owner'] = $this->apiClient->getSerializer()->toQueryValue($owner);
        }
        // query params
        if (is_array($not_owner)) {
            $not_owner = $this->apiClient->getSerializer()->serializeCollection($not_owner, 'csv', true);
        }
        if ($not_owner !== null) {
            $queryParams['not_owner'] = $this->apiClient->getSerializer()->toQueryValue($not_owner);
        }
        // query params
        if (is_array($reporter)) {
            $reporter = $this->apiClient->getSerializer()->serializeCollection($reporter, 'csv', true);
        }
        if ($reporter !== null) {
            $queryParams['reporter'] = $this->apiClient->getSerializer()->toQueryValue($reporter);
        }
        // query params
        if (is_array($not_reporter)) {
            $not_reporter = $this->apiClient->getSerializer()->serializeCollection($not_reporter, 'csv', true);
        }
        if ($not_reporter !== null) {
            $queryParams['not_reporter'] = $this->apiClient->getSerializer()->toQueryValue($not_reporter);
        }
        // query params
        if ($text !== null) {
            $queryParams['text'] = $this->apiClient->getSerializer()->toQueryValue($text);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem[]',
                '/project/{id_or_name}/ticket'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketComment
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return \OSDN\Model\ProjectTicketComment[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketComment($id_or_name, $ticket_id)
    {
        list($response) = $this->listProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id);
        return $response;
    }

    /**
     * Operation listProjectTicketCommentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return Array of \OSDN\Model\ProjectTicketComment[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketComment');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling listProjectTicketComment');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}/comment";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComment[]',
                '/project/{id_or_name}/ticket/{ticket_id}/comment'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComment[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComment[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketComponent[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketComponent($id_or_name)
    {
        list($response) = $this->listProjectTicketComponentWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketComponent[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketComponentWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent[]',
                '/project/{id_or_name}/ticket/component'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketMilestone[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketMilestone($id_or_name)
    {
        list($response) = $this->listProjectTicketMilestoneWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketMilestone[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketMilestoneWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketMilestone[]',
                '/project/{id_or_name}/ticket/milestone'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketMilestone[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketMilestone[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketType[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketType($id_or_name)
    {
        list($response) = $this->listProjectTicketTypeWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketType[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketTypeWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType[]',
                '/project/{id_or_name}/ticket/type'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructions
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketTypeInstruction($id_or_name, $type_id)
    {
        list($response) = $this->listProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id);
        return $response;
    }

    /**
     * Operation listProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructions, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling listProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructions',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructions', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation showProjectTicketAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketAdminprefs($id_or_name)
    {
        list($response) = $this->showProjectTicketAdminprefsWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation showProjectTicketAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketAdminprefsWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling showProjectTicketAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketPrefs',
                '/project/{id_or_name}/ticket/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation showProjectTicketComment
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param int $comment_id numeric project ticket comment id (required)
     * @return \OSDN\Model\ProjectTicketComment
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketComment($id_or_name, $ticket_id, $comment_id)
    {
        list($response) = $this->showProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment_id);
        return $response;
    }

    /**
     * Operation showProjectTicketCommentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param int $comment_id numeric project ticket comment id (required)
     * @return Array of \OSDN\Model\ProjectTicketComment, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling showProjectTicketComment');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling showProjectTicketComment');
        }
        // verify the required parameter 'comment_id' is set
        if ($comment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $comment_id when calling showProjectTicketComment');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // path params
        if ($comment_id !== null) {
            $resourcePath = str_replace(
                "{" . "comment_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($comment_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComment',
                '/project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComment', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComment', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateFrsAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_overwrite Allow overwrite files when filenames are conflict (optional)
     * @return \OSDN\Model\FrsAdminPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateFrsAdminprefs($id_or_name, $allow_overwrite = null)
    {
        list($response) = $this->updateFrsAdminprefsWithHttpInfo($id_or_name, $allow_overwrite);
        return $response;
    }

    /**
     * Operation updateFrsAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_overwrite Allow overwrite files when filenames are conflict (optional)
     * @return Array of \OSDN\Model\FrsAdminPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateFrsAdminprefsWithHttpInfo($id_or_name, $allow_overwrite = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateFrsAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($allow_overwrite !== null) {
            $formParams['allow_overwrite'] = $this->apiClient->getSerializer()->toFormValue($allow_overwrite);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\FrsAdminPrefs',
                '/project/{id_or_name}/frs/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\FrsAdminPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\FrsAdminPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNews
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNews($news_id, $title = null, $body = null)
    {
        list($response) = $this->updateNewsWithHttpInfo($news_id, $title, $body);
        return $response;
    }

    /**
     * Operation updateNewsWithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNewsWithHttpInfo($news_id, $title = null, $body = null)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling updateNews');
        }
        // parse inputs
        $resourcePath = "/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNews_0
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return \OSDN\Model\News
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNews_0($news_id, $id_or_name, $title = null, $body = null)
    {
        list($response) = $this->updateNews_0WithHttpInfo($news_id, $id_or_name, $title, $body);
        return $response;
    }

    /**
     * Operation updateNews_0WithHttpInfo
     *
     * 
     *
     * @param int $news_id  (required)
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $title news title (optional)
     * @param string $body news body in OSDN Wiki format. (optional)
     * @return Array of \OSDN\Model\News, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateNews_0WithHttpInfo($news_id, $id_or_name, $title = null, $body = null)
    {
        // verify the required parameter 'news_id' is set
        if ($news_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $news_id when calling updateNews_0');
        }
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateNews_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/news/{news_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($news_id !== null) {
            $resourcePath = str_replace(
                "{" . "news_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($news_id),
                $resourcePath
            );
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($title !== null) {
            $formParams['title'] = $this->apiClient->getSerializer()->toFormValue($title);
        }
        // form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\News',
                '/project/{id_or_name}/news/{news_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\News', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\News', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name package name (optional)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updatePackage($id_or_name, $package_id, $name = null, $visibility = null)
    {
        list($response) = $this->updatePackageWithHttpInfo($id_or_name, $package_id, $name, $visibility);
        return $response;
    }

    /**
     * Operation updatePackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name package name (optional)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updatePackageWithHttpInfo($id_or_name, $package_id, $name = null, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updatePackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updatePackage');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Package',
                '/project/{id_or_name}/frs/{package_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectAdminProjectweb
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $homepage Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url) (optional)
     * @param bool $reset Project home page URL reset to default value (optional)
     * @return \OSDN\Model\ProjectWeb
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectAdminProjectweb($id_or_name, $homepage = null, $reset = null)
    {
        list($response) = $this->updateProjectAdminProjectwebWithHttpInfo($id_or_name, $homepage, $reset);
        return $response;
    }

    /**
     * Operation updateProjectAdminProjectwebWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $homepage Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url) (optional)
     * @param bool $reset Project home page URL reset to default value (optional)
     * @return Array of \OSDN\Model\ProjectWeb, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectAdminProjectwebWithHttpInfo($id_or_name, $homepage = null, $reset = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectAdminProjectweb');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/project_web";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($homepage !== null) {
            $formParams['homepage'] = $this->apiClient->getSerializer()->toFormValue($homepage);
        }
        // form params
        if ($reset !== null) {
            $formParams['reset'] = $this->apiClient->getSerializer()->toFormValue($reset);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectWeb',
                '/project/{id_or_name}/admin/project_web'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectWeb', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectWeb', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectBzr
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $active  (optional)
     * @return \OSDN\Model\ProjectBzr
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectBzr($id_or_name, $repo_id, $description = null, $active = null)
    {
        list($response) = $this->updateProjectBzrWithHttpInfo($id_or_name, $repo_id, $description, $active);
        return $response;
    }

    /**
     * Operation updateProjectBzrWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $active  (optional)
     * @return Array of \OSDN\Model\ProjectBzr, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectBzrWithHttpInfo($id_or_name, $repo_id, $description = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectBzr');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling updateProjectBzr');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/bzr/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectBzr',
                '/project/{id_or_name}/bzr/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectBzr', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectBzr', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectGit
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @param bool $active  (optional)
     * @return \OSDN\Model\ProjectGit
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectGit($id_or_name, $repo_id, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null, $active = null)
    {
        list($response) = $this->updateProjectGitWithHttpInfo($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch, $active);
        return $response;
    }

    /**
     * Operation updateProjectGitWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param bool $mail_enabled  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $allow_non_fast_forward  (optional)
     * @param string $default_branch  (optional)
     * @param bool $active  (optional)
     * @return Array of \OSDN\Model\ProjectGit, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectGitWithHttpInfo($id_or_name, $repo_id, $description = null, $mail_enabled = null, $mail_recipients = null, $allow_non_fast_forward = null, $default_branch = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectGit');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling updateProjectGit');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/git/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_enabled !== null) {
            $formParams['mail_enabled'] = $this->apiClient->getSerializer()->toFormValue($mail_enabled);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        // form params
        if ($allow_non_fast_forward !== null) {
            $formParams['allow_non_fast_forward'] = $this->apiClient->getSerializer()->toFormValue($allow_non_fast_forward);
        }
        // form params
        if ($default_branch !== null) {
            $formParams['default_branch'] = $this->apiClient->getSerializer()->toFormValue($default_branch);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectGit',
                '/project/{id_or_name}/git/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectGit', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectGit', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectHg
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $active  (optional)
     * @return \OSDN\Model\ProjectHg
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectHg($id_or_name, $repo_id, $description = null, $mail_recipients = null, $active = null)
    {
        list($response) = $this->updateProjectHgWithHttpInfo($id_or_name, $repo_id, $description, $mail_recipients, $active);
        return $response;
    }

    /**
     * Operation updateProjectHgWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $repo_id  (required)
     * @param string $description  (optional)
     * @param string $mail_recipients  (optional)
     * @param bool $active  (optional)
     * @return Array of \OSDN\Model\ProjectHg, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectHgWithHttpInfo($id_or_name, $repo_id, $description = null, $mail_recipients = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectHg');
        }
        // verify the required parameter 'repo_id' is set
        if ($repo_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $repo_id when calling updateProjectHg');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/hg/{repo_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($repo_id !== null) {
            $resourcePath = str_replace(
                "{" . "repo_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($repo_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($mail_recipients !== null) {
            $formParams['mail_recipients'] = $this->apiClient->getSerializer()->toFormValue($mail_recipients);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectHg',
                '/project/{id_or_name}/hg/{repo_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectHg', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectHg', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectProfile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $display_name Project display name (optional)
     * @param string $description Project description (optional)
     * @return \OSDN\Model\GroupProfilePerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectProfile($id_or_name, $language_code, $display_name = null, $description = null)
    {
        list($response) = $this->updateProjectProfileWithHttpInfo($id_or_name, $language_code, $display_name, $description);
        return $response;
    }

    /**
     * Operation updateProjectProfileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $display_name Project display name (optional)
     * @param string $description Project description (optional)
     * @return Array of \OSDN\Model\GroupProfilePerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectProfileWithHttpInfo($id_or_name, $language_code, $display_name = null, $description = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectProfile');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling updateProjectProfile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/profile/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($display_name !== null) {
            $formParams['display_name'] = $this->apiClient->getSerializer()->toFormValue($display_name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\GroupProfilePerLanguage',
                '/project/{id_or_name}/admin/profile/{language_code}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\GroupProfilePerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\GroupProfilePerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $name Project ticket name (title) (optional)
     * @param string $description Project ticket description details (optional)
     * @param int $type_id numeric project ticket type id (optional)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @param string $resolution project ticket resolution text (optional)
     * @param string $status project ticket status (open or close) (optional)
     * @return \OSDN\Model\ProjectTicketItem
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicket($id_or_name, $ticket_id, $name = null, $description = null, $type_id = null, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null, $resolution = null, $status = null)
    {
        list($response) = $this->updateProjectTicketWithHttpInfo($id_or_name, $ticket_id, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner, $resolution, $status);
        return $response;
    }

    /**
     * Operation updateProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $name Project ticket name (title) (optional)
     * @param string $description Project ticket description details (optional)
     * @param int $type_id numeric project ticket type id (optional)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @param string $resolution project ticket resolution text (optional)
     * @param string $status project ticket status (open or close) (optional)
     * @return Array of \OSDN\Model\ProjectTicketItem, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketWithHttpInfo($id_or_name, $ticket_id, $name = null, $description = null, $type_id = null, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null, $resolution = null, $status = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicket');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling updateProjectTicket');
        }
        if ($priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectApi.updateProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectApi.updateProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectApi.updateProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectApi.updateProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($owner < 101.0) {
            throw new \InvalidArgumentException('invalid value for "$owner" when calling ProjectApi.updateProjectTicket, must be bigger than or equal to 101.0.');
        }

        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($type_id !== null) {
            $formParams['type_id'] = $this->apiClient->getSerializer()->toFormValue($type_id);
        }
        // form params
        if ($milestone_id !== null) {
            $formParams['milestone_id'] = $this->apiClient->getSerializer()->toFormValue($milestone_id);
        }
        // form params
        if ($component_id !== null) {
            $formParams['component_id'] = $this->apiClient->getSerializer()->toFormValue($component_id);
        }
        // form params
        if ($priority !== null) {
            $formParams['priority'] = $this->apiClient->getSerializer()->toFormValue($priority);
        }
        // form params
        if ($severity !== null) {
            $formParams['severity'] = $this->apiClient->getSerializer()->toFormValue($severity);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        // form params
        if ($resolution !== null) {
            $formParams['resolution'] = $this->apiClient->getSerializer()->toFormValue($resolution);
        }
        // form params
        if ($status !== null) {
            $formParams['status'] = $this->apiClient->getSerializer()->toFormValue($status);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem',
                '/project/{id_or_name}/ticket/{ticket_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_anonymouse Non login user allows to post new ticket/comment (optional)
     * @param string $frs_autosync Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; (optional)
     * @param string $mailsend_type Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; (optional)
     * @param int $mailing_list_id Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) (optional)
     * @param string $mail_lang Ticket update mail language (optional)
     * @return \OSDN\Model\ProjectTicketPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketAdminprefs($id_or_name, $allow_anonymouse = null, $frs_autosync = null, $mailsend_type = null, $mailing_list_id = null, $mail_lang = null)
    {
        list($response) = $this->updateProjectTicketAdminprefsWithHttpInfo($id_or_name, $allow_anonymouse, $frs_autosync, $mailsend_type, $mailing_list_id, $mail_lang);
        return $response;
    }

    /**
     * Operation updateProjectTicketAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_anonymouse Non login user allows to post new ticket/comment (optional)
     * @param string $frs_autosync Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; (optional)
     * @param string $mailsend_type Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; (optional)
     * @param int $mailing_list_id Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) (optional)
     * @param string $mail_lang Ticket update mail language (optional)
     * @return Array of \OSDN\Model\ProjectTicketPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketAdminprefsWithHttpInfo($id_or_name, $allow_anonymouse = null, $frs_autosync = null, $mailsend_type = null, $mailing_list_id = null, $mail_lang = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($allow_anonymouse !== null) {
            $formParams['allow_anonymouse'] = $this->apiClient->getSerializer()->toFormValue($allow_anonymouse);
        }
        // form params
        if ($frs_autosync !== null) {
            $formParams['frs_autosync'] = $this->apiClient->getSerializer()->toFormValue($frs_autosync);
        }
        // form params
        if ($mailsend_type !== null) {
            $formParams['mailsend_type'] = $this->apiClient->getSerializer()->toFormValue($mailsend_type);
        }
        // form params
        if ($mailing_list_id !== null) {
            $formParams['mailing_list_id'] = $this->apiClient->getSerializer()->toFormValue($mailing_list_id);
        }
        // form params
        if ($mail_lang !== null) {
            $formParams['mail_lang'] = $this->apiClient->getSerializer()->toFormValue($mail_lang);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketPrefs',
                '/project/{id_or_name}/ticket/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param string $name Ticket component name (optional)
     * @param string $description Ticket component description (optional)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return \OSDN\Model\ProjectTicketComponent
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketComponent($id_or_name, $component_id, $name = null, $description = null, $owner = null, $active = null)
    {
        list($response) = $this->updateProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $name, $description, $owner, $active);
        return $response;
    }

    /**
     * Operation updateProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param string $name Ticket component name (optional)
     * @param string $description Ticket component description (optional)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return Array of \OSDN\Model\ProjectTicketComponent, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $name = null, $description = null, $owner = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketComponent');
        }
        // verify the required parameter 'component_id' is set
        if ($component_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $component_id when calling updateProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component/{component_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($component_id !== null) {
            $resourcePath = str_replace(
                "{" . "component_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($component_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent',
                '/project/{id_or_name}/ticket/component/{component_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param string $name Ticket milestone name (optional)
     * @param string $description Ticket milestone description (optional)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @param string $force_status If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; (optional)
     * @return \OSDN\Model\ProjectTicketComponent
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketMilestone($id_or_name, $milestone_id, $name = null, $description = null, $start = null, $end = null, $force_status = null)
    {
        list($response) = $this->updateProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $name, $description, $start, $end, $force_status);
        return $response;
    }

    /**
     * Operation updateProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param string $name Ticket milestone name (optional)
     * @param string $description Ticket milestone description (optional)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @param string $force_status If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; (optional)
     * @return Array of \OSDN\Model\ProjectTicketComponent, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $name = null, $description = null, $start = null, $end = null, $force_status = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketMilestone');
        }
        // verify the required parameter 'milestone_id' is set
        if ($milestone_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestone_id when calling updateProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone/{milestone_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($milestone_id !== null) {
            $resourcePath = str_replace(
                "{" . "milestone_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestone_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($start !== null) {
            $formParams['start'] = $this->apiClient->getSerializer()->toFormValue($start);
        }
        // form params
        if ($end !== null) {
            $formParams['end'] = $this->apiClient->getSerializer()->toFormValue($end);
        }
        // form params
        if ($force_status !== null) {
            $formParams['force_status'] = $this->apiClient->getSerializer()->toFormValue($force_status);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent',
                '/project/{id_or_name}/ticket/milestone/{milestone_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $name Ticket type name (optional)
     * @param string $description Ticket type description (optional)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return \OSDN\Model\ProjectTicketType
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketType($id_or_name, $type_id, $name = null, $description = null, $is_public = null)
    {
        list($response) = $this->updateProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $name, $description, $is_public);
        return $response;
    }

    /**
     * Operation updateProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $name Ticket type name (optional)
     * @param string $description Ticket type description (optional)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return Array of \OSDN\Model\ProjectTicketType, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $name = null, $description = null, $is_public = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketType');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling updateProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($is_public !== null) {
            $formParams['is_public'] = $this->apiClient->getSerializer()->toFormValue($is_public);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType',
                '/project/{id_or_name}/ticket/type/{type_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTools
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $git use git flag (optional)
     * @param bool $svn use Subversion flag (optional)
     * @param bool $hg use Mercurial(Hg) flag (optional)
     * @param bool $bzr use Bazaar flag (optional)
     * @param bool $frs use File Release flag (optional)
     * @param bool $ticket use Ticket flag (optional)
     * @param bool $wiki use Wiki flag (optional)
     * @param bool $forum use Forum flag (optional)
     * @param bool $ml use Mailing List flag (optional)
     * @return \OSDN\Model\GroupToolFlags
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTools($id_or_name, $git = null, $svn = null, $hg = null, $bzr = null, $frs = null, $ticket = null, $wiki = null, $forum = null, $ml = null)
    {
        list($response) = $this->updateProjectToolsWithHttpInfo($id_or_name, $git, $svn, $hg, $bzr, $frs, $ticket, $wiki, $forum, $ml);
        return $response;
    }

    /**
     * Operation updateProjectToolsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $git use git flag (optional)
     * @param bool $svn use Subversion flag (optional)
     * @param bool $hg use Mercurial(Hg) flag (optional)
     * @param bool $bzr use Bazaar flag (optional)
     * @param bool $frs use File Release flag (optional)
     * @param bool $ticket use Ticket flag (optional)
     * @param bool $wiki use Wiki flag (optional)
     * @param bool $forum use Forum flag (optional)
     * @param bool $ml use Mailing List flag (optional)
     * @return Array of \OSDN\Model\GroupToolFlags, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectToolsWithHttpInfo($id_or_name, $git = null, $svn = null, $hg = null, $bzr = null, $frs = null, $ticket = null, $wiki = null, $forum = null, $ml = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTools');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/admin/tools";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($git !== null) {
            $formParams['git'] = $this->apiClient->getSerializer()->toFormValue($git);
        }
        // form params
        if ($svn !== null) {
            $formParams['svn'] = $this->apiClient->getSerializer()->toFormValue($svn);
        }
        // form params
        if ($hg !== null) {
            $formParams['hg'] = $this->apiClient->getSerializer()->toFormValue($hg);
        }
        // form params
        if ($bzr !== null) {
            $formParams['bzr'] = $this->apiClient->getSerializer()->toFormValue($bzr);
        }
        // form params
        if ($frs !== null) {
            $formParams['frs'] = $this->apiClient->getSerializer()->toFormValue($frs);
        }
        // form params
        if ($ticket !== null) {
            $formParams['ticket'] = $this->apiClient->getSerializer()->toFormValue($ticket);
        }
        // form params
        if ($wiki !== null) {
            $formParams['wiki'] = $this->apiClient->getSerializer()->toFormValue($wiki);
        }
        // form params
        if ($forum !== null) {
            $formParams['forum'] = $this->apiClient->getSerializer()->toFormValue($forum);
        }
        // form params
        if ($ml !== null) {
            $formParams['ml'] = $this->apiClient->getSerializer()->toFormValue($ml);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\GroupToolFlags',
                '/project/{id_or_name}/admin/tools'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\GroupToolFlags', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\GroupToolFlags', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $name Release name (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param int $move_to_package_id If this parameter is specified, the release move to another package. (optional)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateRelease($id_or_name, $package_id, $release_id, $visibility = null, $name = null, $time = null, $move_to_package_id = null)
    {
        list($response) = $this->updateReleaseWithHttpInfo($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id);
        return $response;
    }

    /**
     * Operation updateReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $name Release name (optional)
     * @param \DateTime $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param int $move_to_package_id If this parameter is specified, the release move to another package. (optional)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseWithHttpInfo($id_or_name, $package_id, $release_id, $visibility = null, $name = null, $time = null, $move_to_package_id = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updateRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling updateRelease');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($time !== null) {
            $formParams['time'] = $this->apiClient->getSerializer()->toFormValue($time);
        }
        // form params
        if ($move_to_package_id !== null) {
            $formParams['move_to_package_id'] = $this->apiClient->getSerializer()->toFormValue($move_to_package_id);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\Release',
                '/project/{id_or_name}/frs/{package_id}/{release_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility = null)
    {
        list($response) = $this->updateReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id, $visibility);
        return $response;
    }

    /**
     * Operation updateReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id, $visibility = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updateReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling updateReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling updateReleaseFile');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // path params
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\RelFile',
                '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
