<?php
/**
 * ProjectTicketApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * OSDN REST API v0 beta
 *
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * ProjectTicketApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProjectTicketApi
{

    /**
     * API Client
     *
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\OSDN\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.net/api/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \OSDN\ApiClient $apiClient set the API client
     *
     * @return ProjectTicketApi
     */
    public function setApiClient(\OSDN\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Project ticket name (title) (required)
     * @param string $description Project ticket description details (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @return \OSDN\Model\ProjectTicketItem
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicket($id_or_name, $name, $description, $type_id, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null)
    {
        list($response) = $this->createProjectTicketWithHttpInfo($id_or_name, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner);
        return $response;
    }

    /**
     * Operation createProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Project ticket name (title) (required)
     * @param string $description Project ticket description details (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @return Array of \OSDN\Model\ProjectTicketItem, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketWithHttpInfo($id_or_name, $name, $description, $type_id, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicket');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicket');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicket');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling createProjectTicket');
        }
        if ($priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectTicketApi.createProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectTicketApi.createProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectTicketApi.createProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectTicketApi.createProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($owner < 101.0) {
            throw new \InvalidArgumentException('invalid value for "$owner" when calling ProjectTicketApi.createProjectTicket, must be bigger than or equal to 101.0.');
        }

        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($type_id !== null) {
            $formParams['type_id'] = $this->apiClient->getSerializer()->toFormValue($type_id);
        }
        // form params
        if ($milestone_id !== null) {
            $formParams['milestone_id'] = $this->apiClient->getSerializer()->toFormValue($milestone_id);
        }
        // form params
        if ($component_id !== null) {
            $formParams['component_id'] = $this->apiClient->getSerializer()->toFormValue($component_id);
        }
        // form params
        if ($priority !== null) {
            $formParams['priority'] = $this->apiClient->getSerializer()->toFormValue($priority);
        }
        // form params
        if ($severity !== null) {
            $formParams['severity'] = $this->apiClient->getSerializer()->toFormValue($severity);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem',
                '/project/{id_or_name}/ticket'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketComment
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $comment Ticket comment text (required)
     * @return \OSDN\Model\ProjectTicketComment
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketComment($id_or_name, $ticket_id, $comment)
    {
        list($response) = $this->createProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment);
        return $response;
    }

    /**
     * Operation createProjectTicketCommentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $comment Ticket comment text (required)
     * @return Array of \OSDN\Model\ProjectTicketComment, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketComment');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling createProjectTicketComment');
        }
        // verify the required parameter 'comment' is set
        if ($comment === null) {
            throw new \InvalidArgumentException('Missing the required parameter $comment when calling createProjectTicketComment');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}/comment";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($comment !== null) {
            $formParams['comment'] = $this->apiClient->getSerializer()->toFormValue($comment);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComment',
                '/project/{id_or_name}/ticket/{ticket_id}/comment'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComment', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComment', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket component name (required)
     * @param string $description Ticket component description (required)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return \OSDN\Model\ProjectTicketComponent[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketComponent($id_or_name, $name, $description, $owner = null, $active = null)
    {
        list($response) = $this->createProjectTicketComponentWithHttpInfo($id_or_name, $name, $description, $owner, $active);
        return $response;
    }

    /**
     * Operation createProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket component name (required)
     * @param string $description Ticket component description (required)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return Array of \OSDN\Model\ProjectTicketComponent[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketComponentWithHttpInfo($id_or_name, $name, $description, $owner = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketComponent');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicketComponent');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent[]',
                '/project/{id_or_name}/ticket/component'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket milestone name (required)
     * @param string $description Ticket milestone description (required)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @return \OSDN\Model\ProjectTicketMilestone
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketMilestone($id_or_name, $name, $description, $start = null, $end = null)
    {
        list($response) = $this->createProjectTicketMilestoneWithHttpInfo($id_or_name, $name, $description, $start, $end);
        return $response;
    }

    /**
     * Operation createProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket milestone name (required)
     * @param string $description Ticket milestone description (required)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @return Array of \OSDN\Model\ProjectTicketMilestone, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketMilestoneWithHttpInfo($id_or_name, $name, $description, $start = null, $end = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketMilestone');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicketMilestone');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($start !== null) {
            $formParams['start'] = $this->apiClient->getSerializer()->toFormValue($start);
        }
        // form params
        if ($end !== null) {
            $formParams['end'] = $this->apiClient->getSerializer()->toFormValue($end);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketMilestone',
                '/project/{id_or_name}/ticket/milestone'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketMilestone', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketMilestone', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket type name (required)
     * @param string $description Ticket type description (required)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return \OSDN\Model\ProjectTicketType
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketType($id_or_name, $name, $description, $is_public = null)
    {
        list($response) = $this->createProjectTicketTypeWithHttpInfo($id_or_name, $name, $description, $is_public);
        return $response;
    }

    /**
     * Operation createProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name Ticket type name (required)
     * @param string $description Ticket type description (required)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return Array of \OSDN\Model\ProjectTicketType, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketTypeWithHttpInfo($id_or_name, $name, $description, $is_public = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketType');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createProjectTicketType');
        }
        // verify the required parameter 'description' is set
        if ($description === null) {
            throw new \InvalidArgumentException('Missing the required parameter $description when calling createProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($is_public !== null) {
            $formParams['is_public'] = $this->apiClient->getSerializer()->toFormValue($is_public);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType',
                '/project/{id_or_name}/ticket/type'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructionPerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketTypeInstruction($id_or_name, $type_id, $language_code, $instruction)
    {
        list($response) = $this->createProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code, $instruction);
        return $response;
    }

    /**
     * Operation createProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructionPerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code, $instruction)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling createProjectTicketTypeInstruction');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling createProjectTicketTypeInstruction');
        }
        // verify the required parameter 'instruction' is set
        if ($instruction === null) {
            throw new \InvalidArgumentException('Missing the required parameter $instruction when calling createProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($language_code !== null) {
            $formParams['language_code'] = $this->apiClient->getSerializer()->toFormValue($language_code);
        }
        // form params
        if ($instruction !== null) {
            $formParams['instruction'] = $this->apiClient->getSerializer()->toFormValue($instruction);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket component_id (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketComponent($id_or_name, $component_id, $migrate_to)
    {
        list($response) = $this->deleteProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $migrate_to);
        return $response;
    }

    /**
     * Operation deleteProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket component_id (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $migrate_to)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketComponent');
        }
        // verify the required parameter 'component_id' is set
        if ($component_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $component_id when calling deleteProjectTicketComponent');
        }
        // verify the required parameter 'migrate_to' is set
        if ($migrate_to === null) {
            throw new \InvalidArgumentException('Missing the required parameter $migrate_to when calling deleteProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component/{component_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($migrate_to !== null) {
            $queryParams['migrate_to'] = $this->apiClient->getSerializer()->toQueryValue($migrate_to);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($component_id !== null) {
            $resourcePath = str_replace(
                "{" . "component_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($component_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/component/{component_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket milestone_id (optional)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketMilestone($id_or_name, $milestone_id, $migrate_to = null)
    {
        list($response) = $this->deleteProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $migrate_to);
        return $response;
    }

    /**
     * Operation deleteProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket milestone_id (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $migrate_to = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketMilestone');
        }
        // verify the required parameter 'milestone_id' is set
        if ($milestone_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestone_id when calling deleteProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone/{milestone_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($migrate_to !== null) {
            $queryParams['migrate_to'] = $this->apiClient->getSerializer()->toQueryValue($migrate_to);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($milestone_id !== null) {
            $resourcePath = str_replace(
                "{" . "milestone_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestone_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/milestone/{milestone_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket type_id (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketType($id_or_name, $type_id, $migrate_to)
    {
        list($response) = $this->deleteProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $migrate_to);
        return $response;
    }

    /**
     * Operation deleteProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param int $migrate_to Tickets that assigned to delete target will be migrate to the ticket type_id (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $migrate_to)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketType');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling deleteProjectTicketType');
        }
        // verify the required parameter 'migrate_to' is set
        if ($migrate_to === null) {
            throw new \InvalidArgumentException('Missing the required parameter $migrate_to when calling deleteProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if ($migrate_to !== null) {
            $queryParams['migrate_to'] = $this->apiClient->getSerializer()->toQueryValue($migrate_to);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/type/{type_id}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)
    {
        list($response) = $this->deleteProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code);
        return $response;
    }

    /**
     * Operation deleteProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling deleteProjectTicketTypeInstruction');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling deleteProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return \OSDN\Model\ProjectTicketItem
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicket($id_or_name, $ticket_id)
    {
        list($response) = $this->getProjectTicketWithHttpInfo($id_or_name, $ticket_id);
        return $response;
    }

    /**
     * Operation getProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return Array of \OSDN\Model\ProjectTicketItem, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketWithHttpInfo($id_or_name, $ticket_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicket');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling getProjectTicket');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem',
                '/project/{id_or_name}/ticket/{ticket_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @return \OSDN\Model\ProjectTicketComponent
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketComponent($id_or_name, $component_id)
    {
        list($response) = $this->getProjectTicketComponentWithHttpInfo($id_or_name, $component_id);
        return $response;
    }

    /**
     * Operation getProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @return Array of \OSDN\Model\ProjectTicketComponent, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketComponentWithHttpInfo($id_or_name, $component_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketComponent');
        }
        // verify the required parameter 'component_id' is set
        if ($component_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $component_id when calling getProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component/{component_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($component_id !== null) {
            $resourcePath = str_replace(
                "{" . "component_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($component_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent',
                '/project/{id_or_name}/ticket/component/{component_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @return \OSDN\Model\ProjectTicketMilestone
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketMilestone($id_or_name, $milestone_id)
    {
        list($response) = $this->getProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id);
        return $response;
    }

    /**
     * Operation getProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @return Array of \OSDN\Model\ProjectTicketMilestone, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketMilestone');
        }
        // verify the required parameter 'milestone_id' is set
        if ($milestone_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestone_id when calling getProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone/{milestone_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($milestone_id !== null) {
            $resourcePath = str_replace(
                "{" . "milestone_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestone_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketMilestone',
                '/project/{id_or_name}/ticket/milestone/{milestone_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketMilestone', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketMilestone', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return \OSDN\Model\ProjectTicketType
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketType($id_or_name, $type_id)
    {
        list($response) = $this->getProjectTicketTypeWithHttpInfo($id_or_name, $type_id);
        return $response;
    }

    /**
     * Operation getProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return Array of \OSDN\Model\ProjectTicketType, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeWithHttpInfo($id_or_name, $type_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketType');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling getProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType',
                '/project/{id_or_name}/ticket/type/{type_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructionPerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)
    {
        list($response) = $this->getProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code);
        return $response;
    }

    /**
     * Operation getProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructionPerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id, $language_code)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling getProjectTicketTypeInstruction');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling getProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProjectTicketTypeInstruction_0
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructionPerLanguage
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstruction_0($id_or_name, $type_id, $language_code, $instruction)
    {
        list($response) = $this->getProjectTicketTypeInstruction_0WithHttpInfo($id_or_name, $type_id, $language_code, $instruction);
        return $response;
    }

    /**
     * Operation getProjectTicketTypeInstruction_0WithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $language_code Language code for display name and description (example en, ja, zh-TW) (required)
     * @param string $instruction Ticket submit instruction for the type (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructionPerLanguage, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getProjectTicketTypeInstruction_0WithHttpInfo($id_or_name, $type_id, $language_code, $instruction)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getProjectTicketTypeInstruction_0');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling getProjectTicketTypeInstruction_0');
        }
        // verify the required parameter 'language_code' is set
        if ($language_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $language_code when calling getProjectTicketTypeInstruction_0');
        }
        // verify the required parameter 'instruction' is set
        if ($instruction === null) {
            throw new \InvalidArgumentException('Missing the required parameter $instruction when calling getProjectTicketTypeInstruction_0');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // path params
        if ($language_code !== null) {
            $resourcePath = str_replace(
                "{" . "language_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($language_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($instruction !== null) {
            $formParams['instruction'] = $this->apiClient->getSerializer()->toFormValue($instruction);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructionPerLanguage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string[] $status Tickets are assigned to these type_ids (optional)
     * @param int[] $type_id Listing tickets are assigned to these type_ids (optional)
     * @param int[] $not_type_id Listing tickets are NOT assigned to these type_ids (optional)
     * @param int[] $component_id Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $not_component_id Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $milestone_id Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) (optional)
     * @param int[] $not_milestone_id Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) (optional)
     * @param int $max_priority Listing equal or lower priority tickets (optional)
     * @param int $min_priority Listing equal or higher priority tickets (optional)
     * @param int $priority Listing tickets have this priority (optional)
     * @param int $max_severity Listing equal or lower severity tickets (optional)
     * @param int $min_severity Listing equal or higher severity tickets (optional)
     * @param int $severity Listing tickets have this severity (optional)
     * @param int[] $owner Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $not_owner Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param int[] $not_reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param string $text Listing tickets title or description or comment include the text (optional)
     * @return \OSDN\Model\ProjectTicketItem[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicket($id_or_name, $status = null, $type_id = null, $not_type_id = null, $component_id = null, $not_component_id = null, $milestone_id = null, $not_milestone_id = null, $max_priority = null, $min_priority = null, $priority = null, $max_severity = null, $min_severity = null, $severity = null, $owner = null, $not_owner = null, $reporter = null, $not_reporter = null, $text = null)
    {
        list($response) = $this->listProjectTicketWithHttpInfo($id_or_name, $status, $type_id, $not_type_id, $component_id, $not_component_id, $milestone_id, $not_milestone_id, $max_priority, $min_priority, $priority, $max_severity, $min_severity, $severity, $owner, $not_owner, $reporter, $not_reporter, $text);
        return $response;
    }

    /**
     * Operation listProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string[] $status Tickets are assigned to these type_ids (optional)
     * @param int[] $type_id Listing tickets are assigned to these type_ids (optional)
     * @param int[] $not_type_id Listing tickets are NOT assigned to these type_ids (optional)
     * @param int[] $component_id Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $not_component_id Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) (optional)
     * @param int[] $milestone_id Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) (optional)
     * @param int[] $not_milestone_id Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) (optional)
     * @param int $max_priority Listing equal or lower priority tickets (optional)
     * @param int $min_priority Listing equal or higher priority tickets (optional)
     * @param int $priority Listing tickets have this priority (optional)
     * @param int $max_severity Listing equal or lower severity tickets (optional)
     * @param int $min_severity Listing equal or higher severity tickets (optional)
     * @param int $severity Listing tickets have this severity (optional)
     * @param int[] $owner Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $not_owner Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) (optional)
     * @param int[] $reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param int[] $not_reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) (optional)
     * @param string $text Listing tickets title or description or comment include the text (optional)
     * @return Array of \OSDN\Model\ProjectTicketItem[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketWithHttpInfo($id_or_name, $status = null, $type_id = null, $not_type_id = null, $component_id = null, $not_component_id = null, $milestone_id = null, $not_milestone_id = null, $max_priority = null, $min_priority = null, $priority = null, $max_severity = null, $min_severity = null, $severity = null, $owner = null, $not_owner = null, $reporter = null, $not_reporter = null, $text = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicket');
        }
        if ($max_priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$max_priority" when calling ProjectTicketApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($max_priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$max_priority" when calling ProjectTicketApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($min_priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$min_priority" when calling ProjectTicketApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($min_priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$min_priority" when calling ProjectTicketApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectTicketApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectTicketApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($max_severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$max_severity" when calling ProjectTicketApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($max_severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$max_severity" when calling ProjectTicketApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($min_severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$min_severity" when calling ProjectTicketApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($min_severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$min_severity" when calling ProjectTicketApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectTicketApi.listProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectTicketApi.listProjectTicket, must be bigger than or equal to 1.0.');
        }

        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // query params
        if (is_array($status)) {
            $status = $this->apiClient->getSerializer()->serializeCollection($status, 'csv', true);
        }
        if ($status !== null) {
            $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($status);
        }
        // query params
        if (is_array($type_id)) {
            $type_id = $this->apiClient->getSerializer()->serializeCollection($type_id, 'csv', true);
        }
        if ($type_id !== null) {
            $queryParams['type_id'] = $this->apiClient->getSerializer()->toQueryValue($type_id);
        }
        // query params
        if (is_array($not_type_id)) {
            $not_type_id = $this->apiClient->getSerializer()->serializeCollection($not_type_id, 'csv', true);
        }
        if ($not_type_id !== null) {
            $queryParams['not_type_id'] = $this->apiClient->getSerializer()->toQueryValue($not_type_id);
        }
        // query params
        if (is_array($component_id)) {
            $component_id = $this->apiClient->getSerializer()->serializeCollection($component_id, 'csv', true);
        }
        if ($component_id !== null) {
            $queryParams['component_id'] = $this->apiClient->getSerializer()->toQueryValue($component_id);
        }
        // query params
        if (is_array($not_component_id)) {
            $not_component_id = $this->apiClient->getSerializer()->serializeCollection($not_component_id, 'csv', true);
        }
        if ($not_component_id !== null) {
            $queryParams['not_component_id'] = $this->apiClient->getSerializer()->toQueryValue($not_component_id);
        }
        // query params
        if (is_array($milestone_id)) {
            $milestone_id = $this->apiClient->getSerializer()->serializeCollection($milestone_id, 'csv', true);
        }
        if ($milestone_id !== null) {
            $queryParams['milestone_id'] = $this->apiClient->getSerializer()->toQueryValue($milestone_id);
        }
        // query params
        if (is_array($not_milestone_id)) {
            $not_milestone_id = $this->apiClient->getSerializer()->serializeCollection($not_milestone_id, 'csv', true);
        }
        if ($not_milestone_id !== null) {
            $queryParams['not_milestone_id'] = $this->apiClient->getSerializer()->toQueryValue($not_milestone_id);
        }
        // query params
        if ($max_priority !== null) {
            $queryParams['max_priority'] = $this->apiClient->getSerializer()->toQueryValue($max_priority);
        }
        // query params
        if ($min_priority !== null) {
            $queryParams['min_priority'] = $this->apiClient->getSerializer()->toQueryValue($min_priority);
        }
        // query params
        if ($priority !== null) {
            $queryParams['priority'] = $this->apiClient->getSerializer()->toQueryValue($priority);
        }
        // query params
        if ($max_severity !== null) {
            $queryParams['max_severity'] = $this->apiClient->getSerializer()->toQueryValue($max_severity);
        }
        // query params
        if ($min_severity !== null) {
            $queryParams['min_severity'] = $this->apiClient->getSerializer()->toQueryValue($min_severity);
        }
        // query params
        if ($severity !== null) {
            $queryParams['severity'] = $this->apiClient->getSerializer()->toQueryValue($severity);
        }
        // query params
        if (is_array($owner)) {
            $owner = $this->apiClient->getSerializer()->serializeCollection($owner, 'csv', true);
        }
        if ($owner !== null) {
            $queryParams['owner'] = $this->apiClient->getSerializer()->toQueryValue($owner);
        }
        // query params
        if (is_array($not_owner)) {
            $not_owner = $this->apiClient->getSerializer()->serializeCollection($not_owner, 'csv', true);
        }
        if ($not_owner !== null) {
            $queryParams['not_owner'] = $this->apiClient->getSerializer()->toQueryValue($not_owner);
        }
        // query params
        if (is_array($reporter)) {
            $reporter = $this->apiClient->getSerializer()->serializeCollection($reporter, 'csv', true);
        }
        if ($reporter !== null) {
            $queryParams['reporter'] = $this->apiClient->getSerializer()->toQueryValue($reporter);
        }
        // query params
        if (is_array($not_reporter)) {
            $not_reporter = $this->apiClient->getSerializer()->serializeCollection($not_reporter, 'csv', true);
        }
        if ($not_reporter !== null) {
            $queryParams['not_reporter'] = $this->apiClient->getSerializer()->toQueryValue($not_reporter);
        }
        // query params
        if ($text !== null) {
            $queryParams['text'] = $this->apiClient->getSerializer()->toQueryValue($text);
        }
        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem[]',
                '/project/{id_or_name}/ticket'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketComment
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return \OSDN\Model\ProjectTicketComment[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketComment($id_or_name, $ticket_id)
    {
        list($response) = $this->listProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id);
        return $response;
    }

    /**
     * Operation listProjectTicketCommentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @return Array of \OSDN\Model\ProjectTicketComment[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketComment');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling listProjectTicketComment');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}/comment";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComment[]',
                '/project/{id_or_name}/ticket/{ticket_id}/comment'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComment[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComment[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketComponent[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketComponent($id_or_name)
    {
        list($response) = $this->listProjectTicketComponentWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketComponent[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketComponentWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent[]',
                '/project/{id_or_name}/ticket/component'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketMilestone[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketMilestone($id_or_name)
    {
        list($response) = $this->listProjectTicketMilestoneWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketMilestone[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketMilestoneWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketMilestone[]',
                '/project/{id_or_name}/ticket/milestone'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketMilestone[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketMilestone[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketType[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketType($id_or_name)
    {
        list($response) = $this->listProjectTicketTypeWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation listProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketType[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketTypeWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType[]',
                '/project/{id_or_name}/ticket/type'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProjectTicketTypeInstruction
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return \OSDN\Model\ProjectTicketTypeInstructions
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketTypeInstruction($id_or_name, $type_id)
    {
        list($response) = $this->listProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id);
        return $response;
    }

    /**
     * Operation listProjectTicketTypeInstructionWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @return Array of \OSDN\Model\ProjectTicketTypeInstructions, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listProjectTicketTypeInstructionWithHttpInfo($id_or_name, $type_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listProjectTicketTypeInstruction');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling listProjectTicketTypeInstruction');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}/instruction";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketTypeInstructions',
                '/project/{id_or_name}/ticket/type/{type_id}/instruction'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketTypeInstructions', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketTypeInstructions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation showProjectTicketAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\ProjectTicketPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketAdminprefs($id_or_name)
    {
        list($response) = $this->showProjectTicketAdminprefsWithHttpInfo($id_or_name);
        return $response;
    }

    /**
     * Operation showProjectTicketAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\ProjectTicketPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketAdminprefsWithHttpInfo($id_or_name)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling showProjectTicketAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketPrefs',
                '/project/{id_or_name}/ticket/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation showProjectTicketComment
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param int $comment_id numeric project ticket comment id (required)
     * @return \OSDN\Model\ProjectTicketComment
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketComment($id_or_name, $ticket_id, $comment_id)
    {
        list($response) = $this->showProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment_id);
        return $response;
    }

    /**
     * Operation showProjectTicketCommentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param int $comment_id numeric project ticket comment id (required)
     * @return Array of \OSDN\Model\ProjectTicketComment, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function showProjectTicketCommentWithHttpInfo($id_or_name, $ticket_id, $comment_id)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling showProjectTicketComment');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling showProjectTicketComment');
        }
        // verify the required parameter 'comment_id' is set
        if ($comment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $comment_id when calling showProjectTicketComment');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // path params
        if ($comment_id !== null) {
            $resourcePath = str_replace(
                "{" . "comment_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($comment_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComment',
                '/project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComment', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComment', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicket
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $name Project ticket name (title) (optional)
     * @param string $description Project ticket description details (optional)
     * @param int $type_id numeric project ticket type id (optional)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @param string $resolution project ticket resolution text (optional)
     * @param string $status project ticket status (open or close) (optional)
     * @return \OSDN\Model\ProjectTicketItem
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicket($id_or_name, $ticket_id, $name = null, $description = null, $type_id = null, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null, $resolution = null, $status = null)
    {
        list($response) = $this->updateProjectTicketWithHttpInfo($id_or_name, $ticket_id, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner, $resolution, $status);
        return $response;
    }

    /**
     * Operation updateProjectTicketWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $ticket_id numeric project ticket id (required)
     * @param string $name Project ticket name (title) (optional)
     * @param string $description Project ticket description details (optional)
     * @param int $type_id numeric project ticket type id (optional)
     * @param int $milestone_id numeric project ticket milestone id (optional)
     * @param int $component_id numeric project ticket component id (optional)
     * @param int $priority project ticket priority (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $severity project ticket severity (min &#x3D; 1 and max &#x3D; 9) (optional)
     * @param int $owner numeric project ticket owner user id (optional)
     * @param string $resolution project ticket resolution text (optional)
     * @param string $status project ticket status (open or close) (optional)
     * @return Array of \OSDN\Model\ProjectTicketItem, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketWithHttpInfo($id_or_name, $ticket_id, $name = null, $description = null, $type_id = null, $milestone_id = null, $component_id = null, $priority = null, $severity = null, $owner = null, $resolution = null, $status = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicket');
        }
        // verify the required parameter 'ticket_id' is set
        if ($ticket_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ticket_id when calling updateProjectTicket');
        }
        if ($priority > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectTicketApi.updateProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($priority < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$priority" when calling ProjectTicketApi.updateProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($severity > 9.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectTicketApi.updateProjectTicket, must be smaller than or equal to 9.0.');
        }
        if ($severity < 1.0) {
            throw new \InvalidArgumentException('invalid value for "$severity" when calling ProjectTicketApi.updateProjectTicket, must be bigger than or equal to 1.0.');
        }

        if ($owner < 101.0) {
            throw new \InvalidArgumentException('invalid value for "$owner" when calling ProjectTicketApi.updateProjectTicket, must be bigger than or equal to 101.0.');
        }

        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/{ticket_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($ticket_id !== null) {
            $resourcePath = str_replace(
                "{" . "ticket_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($ticket_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($type_id !== null) {
            $formParams['type_id'] = $this->apiClient->getSerializer()->toFormValue($type_id);
        }
        // form params
        if ($milestone_id !== null) {
            $formParams['milestone_id'] = $this->apiClient->getSerializer()->toFormValue($milestone_id);
        }
        // form params
        if ($component_id !== null) {
            $formParams['component_id'] = $this->apiClient->getSerializer()->toFormValue($component_id);
        }
        // form params
        if ($priority !== null) {
            $formParams['priority'] = $this->apiClient->getSerializer()->toFormValue($priority);
        }
        // form params
        if ($severity !== null) {
            $formParams['severity'] = $this->apiClient->getSerializer()->toFormValue($severity);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        // form params
        if ($resolution !== null) {
            $formParams['resolution'] = $this->apiClient->getSerializer()->toFormValue($resolution);
        }
        // form params
        if ($status !== null) {
            $formParams['status'] = $this->apiClient->getSerializer()->toFormValue($status);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketItem',
                '/project/{id_or_name}/ticket/{ticket_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketItem', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketAdminprefs
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_anonymouse Non login user allows to post new ticket/comment (optional)
     * @param string $frs_autosync Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; (optional)
     * @param string $mailsend_type Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; (optional)
     * @param int $mailing_list_id Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) (optional)
     * @param string $mail_lang Ticket update mail language (optional)
     * @return \OSDN\Model\ProjectTicketPrefs
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketAdminprefs($id_or_name, $allow_anonymouse = null, $frs_autosync = null, $mailsend_type = null, $mailing_list_id = null, $mail_lang = null)
    {
        list($response) = $this->updateProjectTicketAdminprefsWithHttpInfo($id_or_name, $allow_anonymouse, $frs_autosync, $mailsend_type, $mailing_list_id, $mail_lang);
        return $response;
    }

    /**
     * Operation updateProjectTicketAdminprefsWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param bool $allow_anonymouse Non login user allows to post new ticket/comment (optional)
     * @param string $frs_autosync Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; (optional)
     * @param string $mailsend_type Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; (optional)
     * @param int $mailing_list_id Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) (optional)
     * @param string $mail_lang Ticket update mail language (optional)
     * @return Array of \OSDN\Model\ProjectTicketPrefs, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketAdminprefsWithHttpInfo($id_or_name, $allow_anonymouse = null, $frs_autosync = null, $mailsend_type = null, $mailing_list_id = null, $mail_lang = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketAdminprefs');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/admin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($allow_anonymouse !== null) {
            $formParams['allow_anonymouse'] = $this->apiClient->getSerializer()->toFormValue($allow_anonymouse);
        }
        // form params
        if ($frs_autosync !== null) {
            $formParams['frs_autosync'] = $this->apiClient->getSerializer()->toFormValue($frs_autosync);
        }
        // form params
        if ($mailsend_type !== null) {
            $formParams['mailsend_type'] = $this->apiClient->getSerializer()->toFormValue($mailsend_type);
        }
        // form params
        if ($mailing_list_id !== null) {
            $formParams['mailing_list_id'] = $this->apiClient->getSerializer()->toFormValue($mailing_list_id);
        }
        // form params
        if ($mail_lang !== null) {
            $formParams['mail_lang'] = $this->apiClient->getSerializer()->toFormValue($mail_lang);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketPrefs',
                '/project/{id_or_name}/ticket/admin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketPrefs', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketPrefs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketComponent
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param string $name Ticket component name (optional)
     * @param string $description Ticket component description (optional)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return \OSDN\Model\ProjectTicketComponent
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketComponent($id_or_name, $component_id, $name = null, $description = null, $owner = null, $active = null)
    {
        list($response) = $this->updateProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $name, $description, $owner, $active);
        return $response;
    }

    /**
     * Operation updateProjectTicketComponentWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $component_id numeric project ticket component id (required)
     * @param string $name Ticket component name (optional)
     * @param string $description Ticket component description (optional)
     * @param int $owner Ticket componet owner user_id (optional)
     * @param bool $active Ticket componet will be shown the component select list when this parameter is true (optional)
     * @return Array of \OSDN\Model\ProjectTicketComponent, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketComponentWithHttpInfo($id_or_name, $component_id, $name = null, $description = null, $owner = null, $active = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketComponent');
        }
        // verify the required parameter 'component_id' is set
        if ($component_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $component_id when calling updateProjectTicketComponent');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/component/{component_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($component_id !== null) {
            $resourcePath = str_replace(
                "{" . "component_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($component_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($owner !== null) {
            $formParams['owner'] = $this->apiClient->getSerializer()->toFormValue($owner);
        }
        // form params
        if ($active !== null) {
            $formParams['active'] = $this->apiClient->getSerializer()->toFormValue($active);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent',
                '/project/{id_or_name}/ticket/component/{component_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketMilestone
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param string $name Ticket milestone name (optional)
     * @param string $description Ticket milestone description (optional)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @param string $force_status If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; (optional)
     * @return \OSDN\Model\ProjectTicketComponent
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketMilestone($id_or_name, $milestone_id, $name = null, $description = null, $start = null, $end = null, $force_status = null)
    {
        list($response) = $this->updateProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $name, $description, $start, $end, $force_status);
        return $response;
    }

    /**
     * Operation updateProjectTicketMilestoneWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $milestone_id numeric project ticket milestone id (required)
     * @param string $name Ticket milestone name (optional)
     * @param string $description Ticket milestone description (optional)
     * @param \DateTime $start Ticket milestone start date (optional)
     * @param \DateTime $end Ticket milestone due date (optional)
     * @param string $force_status If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; (optional)
     * @return Array of \OSDN\Model\ProjectTicketComponent, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketMilestoneWithHttpInfo($id_or_name, $milestone_id, $name = null, $description = null, $start = null, $end = null, $force_status = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketMilestone');
        }
        // verify the required parameter 'milestone_id' is set
        if ($milestone_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestone_id when calling updateProjectTicketMilestone');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/milestone/{milestone_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($milestone_id !== null) {
            $resourcePath = str_replace(
                "{" . "milestone_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestone_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($start !== null) {
            $formParams['start'] = $this->apiClient->getSerializer()->toFormValue($start);
        }
        // form params
        if ($end !== null) {
            $formParams['end'] = $this->apiClient->getSerializer()->toFormValue($end);
        }
        // form params
        if ($force_status !== null) {
            $formParams['force_status'] = $this->apiClient->getSerializer()->toFormValue($force_status);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketComponent',
                '/project/{id_or_name}/ticket/milestone/{milestone_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketComponent', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketComponent', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProjectTicketType
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $name Ticket type name (optional)
     * @param string $description Ticket type description (optional)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return \OSDN\Model\ProjectTicketType
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketType($id_or_name, $type_id, $name = null, $description = null, $is_public = null)
    {
        list($response) = $this->updateProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $name, $description, $is_public);
        return $response;
    }

    /**
     * Operation updateProjectTicketTypeWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $type_id numeric project ticket type id (required)
     * @param string $name Ticket type name (optional)
     * @param string $description Ticket type description (optional)
     * @param bool $is_public if set as false, this type will be shown to project members only. (optional)
     * @return Array of \OSDN\Model\ProjectTicketType, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateProjectTicketTypeWithHttpInfo($id_or_name, $type_id, $name = null, $description = null, $is_public = null)
    {
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateProjectTicketType');
        }
        // verify the required parameter 'type_id' is set
        if ($type_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type_id when calling updateProjectTicketType');
        }
        // parse inputs
        $resourcePath = "/project/{id_or_name}/ticket/type/{type_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/x-www-form-urlencoded'));

        // path params
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($type_id !== null) {
            $resourcePath = str_replace(
                "{" . "type_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($type_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = $this->apiClient->getSerializer()->toFormValue($description);
        }
        // form params
        if ($is_public !== null) {
            $formParams['is_public'] = $this->apiClient->getSerializer()->toFormValue($is_public);
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\OSDN\Model\ProjectTicketType',
                '/project/{id_or_name}/ticket/type/{type_id}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\OSDN\Model\ProjectTicketType', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\OSDN\Model\ProjectTicketType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
