# coding: utf-8

"""
    OSDN REST API v0 beta

    OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 

    OpenAPI spec version: 0.0.20171120
    Contact: admin@osdn.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProjectSCMApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_project_bzr(self, id_or_name, name, **kwargs):
        """
        
        Create a new bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_bzr(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_bzr_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_project_bzr_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_project_bzr_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a new bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_bzr_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_bzr`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_git(self, id_or_name, name, **kwargs):
        """
        
        Create a new git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_git_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_project_git_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_project_git_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a new git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'mail_enabled', 'mail_recipients', 'allow_non_fast_forward', 'default_branch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_git`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_git`")

        resource_path = '/project/{id_or_name}/git'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_enabled' in params:
            form_params.append(('mail_enabled', params['mail_enabled']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))
        if 'allow_non_fast_forward' in params:
            form_params.append(('allow_non_fast_forward', params['allow_non_fast_forward']))
        if 'default_branch' in params:
            form_params.append(('default_branch', params['default_branch']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_git_hook(self, id_or_name, repo_id, target_url, **kwargs):
        """
        
        Create a new hook for project git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git_hook(id_or_name, repo_id, target_url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str target_url:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_git_hook_with_http_info(id_or_name, repo_id, target_url, **kwargs)
        else:
            (data) = self.create_project_git_hook_with_http_info(id_or_name, repo_id, target_url, **kwargs)
            return data

    def create_project_git_hook_with_http_info(self, id_or_name, repo_id, target_url, **kwargs):
        """
        
        Create a new hook for project git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git_hook_with_http_info(id_or_name, repo_id, target_url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str target_url:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'target_url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `create_project_git_hook`")
        # verify the required parameter 'target_url' is set
        if ('target_url' not in params) or (params['target_url'] is None):
            raise ValueError("Missing the required parameter `target_url` when calling `create_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'target_url' in params:
            form_params.append(('target_url', params['target_url']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScmHook',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_hg(self, id_or_name, name, **kwargs):
        """
        
        Create a new hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_hg(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param str mail_recipients: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_hg_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_project_hg_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_project_hg_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a new hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_hg_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param str mail_recipients: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'mail_recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_hg`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_hg`")

        resource_path = '/project/{id_or_name}/hg'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_git_hook(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Delete a Git repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_git_hook(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
        else:
            (data) = self.delete_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
            return data

    def delete_project_git_hook_with_http_info(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Delete a Git repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'hook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `delete_project_git_hook`")
        # verify the required parameter 'hook_id' is set
        if ('hook_id' not in params) or (params['hook_id'] is None):
            raise ValueError("Missing the required parameter `hook_id` when calling `delete_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']
        if 'hook_id' in params:
            path_params['hook_id'] = params['hook_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def disable_project_bzr(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a bzr repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_bzr(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.disable_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def disable_project_bzr_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a bzr repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_bzr_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `disable_project_bzr`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `disable_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def disable_project_git(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a git repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_git(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_project_git_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.disable_project_git_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def disable_project_git_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a git repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_git_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `disable_project_git`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `disable_project_git`")

        resource_path = '/project/{id_or_name}/git/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def disable_project_hg(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a hg repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_hg(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.disable_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def disable_project_hg_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a hg repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_hg_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `disable_project_hg`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `disable_project_hg`")

        resource_path = '/project/{id_or_name}/hg/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_bzr(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_bzr(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.get_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def get_project_bzr_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_bzr_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_bzr`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_git(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_git_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.get_project_git_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def get_project_git_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_git`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_git`")

        resource_path = '/project/{id_or_name}/git/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_git_hook(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Get a repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git_hook(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
        else:
            (data) = self.get_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
            return data

    def get_project_git_hook_with_http_info(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Get a repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'hook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_git_hook`")
        # verify the required parameter 'hook_id' is set
        if ('hook_id' not in params) or (params['hook_id'] is None):
            raise ValueError("Missing the required parameter `hook_id` when calling `get_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']
        if 'hook_id' in params:
            path_params['hook_id'] = params['hook_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScmHook',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_hg(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_hg(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.get_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def get_project_hg_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_hg_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_hg`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_hg`")

        resource_path = '/project/{id_or_name}/hg/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_svn(self, id_or_name, **kwargs):
        """
        
        Get Subversion repository of the project

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_svn(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectSvn
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_svn_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_svn_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_svn_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get Subversion repository of the project

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_svn_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectSvn
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_svn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_svn`")

        resource_path = '/project/{id_or_name}/svn'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectSvn',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_bzr(self, id_or_name, **kwargs):
        """
        
        Get Bazzar repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_bzr(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectBzr]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_bzr_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_bzr_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_bzr_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get Bazzar repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_bzr_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectBzr]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectBzr]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_git(self, id_or_name, **kwargs):
        """
        
        Get git repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectGit]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_git_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_git_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_git_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get git repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectGit]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_git`")

        resource_path = '/project/{id_or_name}/git'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectGit]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_git_hook(self, id_or_name, repo_id, **kwargs):
        """
        
        Get Git repository hook list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git_hook(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: list[ScmHook]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_git_hook_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.list_project_git_hook_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def list_project_git_hook_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get Git repository hook list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git_hook_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: list[ScmHook]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `list_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ScmHook]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_hg(self, id_or_name, **kwargs):
        """
        
        Get Mercurial repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_hg(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectHg]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_hg_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_hg_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_hg_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get Mercurial repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_hg_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectHg]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_hg`")

        resource_path = '/project/{id_or_name}/hg'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectHg]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_bzr(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_bzr(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool active: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.update_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def update_project_bzr_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_bzr_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool active: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'description', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_bzr`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `update_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_git(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_git(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :param bool active: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_git_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.update_project_git_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def update_project_git_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_git_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :param bool active: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'description', 'mail_enabled', 'mail_recipients', 'allow_non_fast_forward', 'default_branch', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_git`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `update_project_git`")

        resource_path = '/project/{id_or_name}/git/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_enabled' in params:
            form_params.append(('mail_enabled', params['mail_enabled']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))
        if 'allow_non_fast_forward' in params:
            form_params.append(('allow_non_fast_forward', params['allow_non_fast_forward']))
        if 'default_branch' in params:
            form_params.append(('default_branch', params['default_branch']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_hg(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_hg(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param str mail_recipients: 
        :param bool active: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.update_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def update_project_hg_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_hg_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param str mail_recipients: 
        :param bool active: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'description', 'mail_recipients', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_hg`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `update_project_hg`")

        resource_path = '/project/{id_or_name}/hg/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
