# coding: utf-8

"""
    OSDN REST API v0 beta

    OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 

    OpenAPI spec version: 0.0.20171120
    Contact: admin@osdn.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class UserApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_user(self, id_or_name, **kwargs):
        """
        
        Get user profile. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_user_with_http_info(id_or_name, **kwargs)
            return data

    def get_user_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get user profile. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_user`")

        resource_path = '/user/{id_or_name}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_user_history(self, id_or_name, **kwargs):
        """
        
        get user monthly stats.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_history(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: list[History]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_history_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_user_history_with_http_info(id_or_name, **kwargs)
            return data

    def get_user_history_with_http_info(self, id_or_name, **kwargs):
        """
        
        get user monthly stats.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_history_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: list[History]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_user_history`")

        resource_path = '/user/{id_or_name}/history'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[History]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_user_stats_daily(self, id_or_name, **kwargs):
        """
        
        get user daily stats.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_stats_daily(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: list[UserStats]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_stats_daily_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_user_stats_daily_with_http_info(id_or_name, **kwargs)
            return data

    def get_user_stats_daily_with_http_info(self, id_or_name, **kwargs):
        """
        
        get user daily stats.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_stats_daily_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: list[UserStats]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_stats_daily" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_user_stats_daily`")

        resource_path = '/user/{id_or_name}/stats/daily'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[UserStats]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_user_stats_monthly(self, id_or_name, **kwargs):
        """
        
        get user monthly stats.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_stats_monthly(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: list[UserStats]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_stats_monthly_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_user_stats_monthly_with_http_info(id_or_name, **kwargs)
            return data

    def get_user_stats_monthly_with_http_info(self, id_or_name, **kwargs):
        """
        
        get user monthly stats.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_stats_monthly_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :return: list[UserStats]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_stats_monthly" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_user_stats_monthly`")

        resource_path = '/user/{id_or_name}/stats/monthly'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[UserStats]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_user_icon(self, id_or_name, image, **kwargs):
        """
        
        Update user icon, the image will be resized to 12x12 automatically. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_icon(id_or_name, image, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :param file image: The image data to update, you need to send with multipart/form-data. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_user_icon_with_http_info(id_or_name, image, **kwargs)
        else:
            (data) = self.update_user_icon_with_http_info(id_or_name, image, **kwargs)
            return data

    def update_user_icon_with_http_info(self, id_or_name, image, **kwargs):
        """
        
        Update user icon, the image will be resized to 12x12 automatically. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_icon_with_http_info(id_or_name, image, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :param file image: The image data to update, you need to send with multipart/form-data. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'image']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_icon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_user_icon`")
        # verify the required parameter 'image' is set
        if ('image' not in params) or (params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `update_user_icon`")

        resource_path = '/user/{id_or_name}/icon'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_user_photo(self, id_or_name, image, **kwargs):
        """
        
        Update user profile photo. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_photo(id_or_name, image, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :param file image: The image data to update, you need to send with multipart/form-data. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_user_photo_with_http_info(id_or_name, image, **kwargs)
        else:
            (data) = self.update_user_photo_with_http_info(id_or_name, image, **kwargs)
            return data

    def update_user_photo_with_http_info(self, id_or_name, image, **kwargs):
        """
        
        Update user profile photo. 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_photo_with_http_info(id_or_name, image, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric user id or user name (required)
        :param file image: The image data to update, you need to send with multipart/form-data. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'image']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_photo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_user_photo`")
        # verify the required parameter 'image' is set
        if ('image' not in params) or (params['image'] is None):
            raise ValueError("Missing the required parameter `image` when calling `update_user_photo`")

        resource_path = '/user/{id_or_name}/photo'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            local_var_files['image'] = params['image']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
