/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.WizardWithLicenses;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class InstallWizard
extends WizardWithLicenses {
    QueryableMetadataRepositoryManager manager;
    AvailableIUsPage mainPage;
    SelectableIUsPage errorReportingPage;

    public InstallWizard(Policy policy, String profileId, IInstallableUnit[] initialSelections, PlannerResolutionOperation initialResolution, QueryableMetadataRepositoryManager manager) {
        super(policy, profileId, null, initialSelections, initialResolution);
        this.manager = manager;
        this.setWindowTitle(ProvUIMessages.InstallIUOperationLabel);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/install_wiz.gif"));
    }

    public InstallWizard(Policy policy, String profileId) {
        this(policy, profileId, null, null, new QueryableMetadataRepositoryManager(policy.getQueryContext(), false));
    }

    protected ResolutionResultsWizardPage createResolutionPage() {
        return new InstallWizardPage(this.policy, this.profileId, this.root, this.resolutionOperation);
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new AvailableIUsPage(this.policy, this.profileId, this.manager);
        if (selections != null && selections.length > 0) {
            this.mainPage.setCheckedElements(selections);
        }
        return this.mainPage;
    }

    protected IUElementListRoot makeResolutionElementRoot(Object[] selectedElements) {
        IUElementListRoot elementRoot = new IUElementListRoot();
        ArrayList<AvailableIUElement> list = new ArrayList<AvailableIUElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            IInstallableUnit iu = ElementUtils.getIU(selectedElements[i]);
            if (iu != null) {
                list.add(new AvailableIUElement(elementRoot, iu, this.profileId, this.policy.getQueryContext().getShowProvisioningPlanChildren()));
            }
            ++i;
        }
        elementRoot.setChildren(list.toArray());
        return elementRoot;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.manager != null) {
            pageContainer.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    InstallWizard.this.manager.reportAccumulatedStatus();
                }
            });
        }
    }

    protected ProvisioningContext getProvisioningContext() {
        return this.mainPage.getProvisioningContext();
    }

    protected ProfileChangeRequest computeProfileChangeRequest(Object[] selectedElements, MultiStatus additionalStatus, IProgressMonitor monitor) {
        IInstallableUnit[] selected = ElementUtils.elementsToIUs(selectedElements);
        return InstallAction.computeProfileChangeRequest(selected, this.profileId, additionalStatus, monitor);
    }

    protected IResolutionErrorReportingPage getErrorReportingPage() {
        if (this.errorReportingPage == null) {
            this.originalRoot = this.root;
            this.errorReportingPage = new SelectableIUsPage(this.policy, this.root, this.root.getChildren(this.root), this.profileId);
            this.errorReportingPage.setTitle(ProvUIMessages.InstallWizardPage_Title);
            this.errorReportingPage.setDescription(ProvUIMessages.PreselectedIUInstallWizard_Description);
            this.errorReportingPage.updateStatus(this.root, this.resolutionOperation);
            this.errorReportingPage.setCheckedElements(this.root.getChildren(this.root));
            this.addPage(this.errorReportingPage);
        }
        return this.errorReportingPage;
    }

    protected void showingErrorPage() {
        if (this.getContainer().getCurrentPage() == this.mainPage) {
            this.originalRoot = this.root;
            this.errorReportingPage.updateStatus(this.originalRoot, this.resolutionOperation);
            this.errorReportingPage.setCheckedElements(this.root.getChildren(this.root));
        }
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.errorReportingPage) {
            this.mainPage.setCheckedElements(this.errorReportingPage.getCheckedIUElements());
            return this.mainPage;
        }
        return super.getPreviousPage(page);
    }
}

