/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RepositoryOperation;

public abstract class AddRepositoryOperation
extends RepositoryOperation {
    protected String[] nicknames;

    public AddRepositoryOperation(String label, URI[] locations) {
        super(label, locations);
    }

    public void setNicknames(String[] nicknames) {
        Assert.isLegal((nicknames != null && nicknames.length == this.locations.length ? 1 : 0) != 0);
        this.nicknames = nicknames;
    }

    public boolean runInBackground() {
        return true;
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ProvisionException {
        boolean batched = false;
        if (this.locations != null && this.locations.length > 1) {
            ProvUI.startBatchOperation();
            batched = true;
        }
        IStatus status = this.doBatchedExecute(monitor);
        if (this.nicknames != null) {
            int i = 0;
            while (i < this.nicknames.length) {
                this.setNickname(this.locations[i], this.nicknames[i]);
                ++i;
            }
        }
        if (batched) {
            ProvUI.endBatchOperation(this.notify);
        }
        return status;
    }

    protected abstract void setNickname(URI var1, String var2) throws ProvisionException;

    protected abstract IStatus doBatchedExecute(IProgressMonitor var1) throws ProvisionException;

    public void setNotify(boolean notify) {
        this.notify = notify;
    }
}

