/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.tags.FilteredTagList;
import org.eclipse.team.internal.ccvs.ui.tags.TagElement;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.ui.contentassist.ContentAssistHandler;

public class TagContentAssistProcessor
implements ISubjectControlContentAssistProcessor {
    private FilteredTagList tags;
    private Map images = new HashMap();

    public static void createContentAssistant(Text text, TagSource tagSource, int includeFlags) {
        TagContentAssistProcessor tagContentAssistProcessor = new TagContentAssistProcessor(tagSource, includeFlags);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TagContentAssistProcessor.this.dispose();
            }
        });
        ContentAssistHandler.createHandlerForText((Text)text, (SubjectControlContentAssistant)TagContentAssistProcessor.createSubjectContentAssistant((IContentAssistProcessor)tagContentAssistProcessor));
    }

    private static SubjectControlContentAssistant createSubjectContentAssistant(IContentAssistProcessor processor) {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setContentAssistProcessor(processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }

    public TagContentAssistProcessor(TagSource tagSource, int includeFlags) {
        this.tags = new FilteredTagList(tagSource, TagSource.convertIncludeFlaqsToTagTypes(includeFlags));
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        Control c = contentAssistSubjectControl.getControl();
        int docLength = contentAssistSubjectControl.getDocument().getLength();
        if (c instanceof Text) {
            Text t = (Text)c;
            String filter = t.getText();
            this.tags.setPattern(filter);
            CVSTag[] matching = this.tags.getMatchingTags();
            if (matching.length > 0) {
                ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
                int i = 0;
                while (i < matching.length) {
                    CVSTag tag = matching[i];
                    String name = tag.getName();
                    ImageDescriptor desc = TagElement.getImageDescriptor(tag);
                    Image image = null;
                    if (desc != null && (image = (Image)this.images.get(desc)) == null) {
                        image = desc.createImage();
                        this.images.put(desc, image);
                    }
                    CompletionProposal proposal = new CompletionProposal(name, 0, docLength, name.length(), image, name, null, null);
                    proposals.add(proposal);
                    ++i;
                }
                return proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public void dispose() {
        Iterator iter = this.images.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
    }
}

