/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.builders.DependencyLoop;
import org.eclipse.pde.internal.core.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.LoopDialog;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginDependenciesAction;
import org.eclipse.pde.internal.ui.views.dependencies.OpenPluginReferencesAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DependencyAnalysisSection
extends PDESection {
    private FormText formText;

    public DependencyAnalysisSection(PDEFormPage page, Composite parent, int style) {
        super(page, parent, 0x102 | style);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private String getFormText() {
        boolean editable = this.getPage().getModel().isEditable();
        if (this.getPage().getModel() instanceof IPluginModel) {
            if (editable) {
                return PDEUIMessages.DependencyAnalysisSection_plugin_editable;
            }
            return PDEUIMessages.DependencyAnalysisSection_plugin_notEditable;
        }
        if (editable) {
            return PDEUIMessages.DependencyAnalysisSection_fragment_editable;
        }
        return PDEUIMessages.DependencyAnalysisSection_fragment_notEditable;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.DependencyAnalysisSection_title);
        this.formText = toolkit.createFormText((Composite)section, true);
        this.formText.setText(this.getFormText(), true, false);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        this.formText.setImage("loops", lp.get(PDEPluginImages.DESC_LOOP_OBJ));
        this.formText.setImage("search", lp.get(PDEPluginImages.DESC_PSEARCH_OBJ));
        this.formText.setImage("hierarchy", lp.get(PDEPluginImages.DESC_CALLEES));
        this.formText.setImage("dependencies", lp.get(PDEPluginImages.DESC_CALLERS));
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref().equals("unused")) {
                    DependencyAnalysisSection.this.doFindUnusedDependencies();
                } else if (e.getHref().equals("loops")) {
                    DependencyAnalysisSection.this.doFindLoops();
                } else if (e.getHref().equals("references")) {
                    new OpenPluginReferencesAction(PluginRegistry.findModel((String)DependencyAnalysisSection.this.getPlugin().getId())).run();
                } else if (e.getHref().equals("hierarchy")) {
                    new OpenPluginDependenciesAction(PluginRegistry.findModel((String)DependencyAnalysisSection.this.getPlugin().getId())).run();
                }
            }
        });
        section.setClient((Control)this.formText);
    }

    protected IPlugin getPlugin() {
        IBaseModel model = this.getPage().getModel();
        IPlugin plugin = null;
        if (model instanceof IPluginModel) {
            plugin = ((IPluginModel)model).getPlugin();
        }
        return plugin;
    }

    protected void doFindLoops() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IPluginModel) {
            IPlugin plugin = ((IPluginModel)model).getPlugin();
            DependencyLoop[] loops = DependencyLoopFinder.findLoops((IPlugin)plugin);
            if (loops.length == 0) {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.DependencyAnalysisSection_loops, (String)PDEUIMessages.DependencyAnalysisSection_noCycles);
            } else {
                LoopDialog dialog = new LoopDialog(PDEPlugin.getActiveWorkbenchShell(), loops);
                dialog.open();
            }
        }
    }

    protected void doFindUnusedDependencies() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IPluginModelBase) {
            new UnusedDependenciesAction((IPluginModelBase)model, false).run();
        }
    }
}

