/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.product.BrandingPage;
import org.eclipse.pde.internal.ui.editor.product.ConfigurationPage;
import org.eclipse.pde.internal.ui.editor.product.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.product.LaunchingPage;
import org.eclipse.pde.internal.ui.editor.product.LicensingPage;
import org.eclipse.pde.internal.ui.editor.product.OverviewPage;
import org.eclipse.pde.internal.ui.editor.product.ProductExportAction;
import org.eclipse.pde.internal.ui.editor.product.ProductInputContext;
import org.eclipse.pde.internal.ui.editor.product.ProductInputContextManager;
import org.eclipse.pde.internal.ui.editor.product.ProductLauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.product.ProductOutlinePage;
import org.eclipse.pde.internal.ui.editor.product.ProductValidateAction;
import org.eclipse.pde.internal.ui.editor.product.SplashPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class ProductEditor
extends PDELauncherFormEditor {
    private ProductExportAction fExportAction;
    private ILauncherFormPageHelper fLauncherHelper;

    protected String getEditorID() {
        return "org.eclipse.pde.ui.productEditor";
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "product-context";
    }

    protected InputContextManager createInputContextManager() {
        return new ProductInputContextManager(this);
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        manager.putContext((IEditorInput)input, new ProductInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(input.getFile());
    }

    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        String name;
        File file = new File(input.getURI());
        if (file != null && (name = file.getName()).endsWith(".product")) {
            try {
                IFileStore store = EFS.getStore((URI)file.toURI());
                FileStoreEditorInput in = new FileStoreEditorInput(store);
                manager.putContext((IEditorInput)in, new ProductInputContext(this, (IEditorInput)in, true));
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input.getName().endsWith(".product")) {
            manager.putContext((IEditorInput)input, new ProductInputContext(this, (IEditorInput)input, true));
        }
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new ProductOutlinePage(this);
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("product-context");
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this));
            this.addPage((IFormPage)new DependenciesPage(this, this.useFeatures()));
            this.addPage((IFormPage)new ConfigurationPage(this, false));
            this.addPage((IFormPage)new LaunchingPage(this));
            this.addPage((IFormPage)new SplashPage(this));
            this.addPage((IFormPage)new BrandingPage(this));
            this.addPage((IFormPage)new LicensingPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    public void updateConfigurationPage() {
        try {
            this.removePage(1);
            this.addPage(1, (IFormPage)new DependenciesPage(this, this.useFeatures()));
        }
        catch (PartInitException partInitException) {}
    }

    public boolean useFeatures() {
        IBaseModel model = this.getAggregateModel();
        return ((IProductModel)model).getProduct().useFeatures();
    }

    public void editorContextAdded(InputContext context) {
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public void contributeToToolbar(IToolBarManager manager) {
        this.contributeLaunchersToToolbar(manager);
        manager.add((IAction)this.getExportAction());
        IProduct product = ((IProductModel)this.getAggregateModel()).getProduct();
        manager.add((IAction)new ProductValidateAction(product));
    }

    private ProductExportAction getExportAction() {
        if (this.fExportAction == null) {
            this.fExportAction = new ProductExportAction(this);
            this.fExportAction.setToolTipText(PDEUIMessages.ProductEditor_exportTooltip);
            this.fExportAction.setImageDescriptor(PDEPluginImages.DESC_EXPORT_PRODUCT_TOOL);
        }
        return this.fExportAction;
    }

    protected ILauncherFormPageHelper getLauncherHelper() {
        if (this.fLauncherHelper == null) {
            this.fLauncherHelper = new ProductLauncherFormPageHelper(this);
        }
        return this.fLauncherHelper;
    }
}

