/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;

public class BundleLauncherHelper {
    public static final char VERSION_SEPARATOR = '*';

    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getWorkspaceBundleMap(configuration, null, "workspace_bundles");
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getTargetBundleMap(configuration, null, "target_bundles");
    }

    public static Map getMergedBundleMap(ILaunchConfiguration configuration, boolean osgi) throws CoreException {
        HashSet set = new HashSet();
        Map map = new HashMap();
        if (!osgi) {
            BundleLauncherHelper.checkBackwardCompatibility(configuration, true);
            if (configuration.getAttribute("default", true)) {
                IPluginModelBase[] models = PluginRegistry.getActiveModels();
                int i = 0;
                while (i < models.length) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], "default:default");
                    ++i;
                }
                return map;
            }
            if (configuration.getAttribute("usefeatures", false)) {
                IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
                int i = 0;
                while (i < models.length) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], "default:default");
                    ++i;
                }
                return map;
            }
        }
        String workspace = !osgi ? "selected_workspace_plugins" : "workspace_bundles";
        String target = !osgi ? "selected_target_plugins" : "target_bundles";
        map = BundleLauncherHelper.getWorkspaceBundleMap(configuration, set, workspace);
        map.putAll(BundleLauncherHelper.getTargetBundleMap(configuration, set, target));
        return map;
    }

    public static IPluginModelBase[] getMergedBundles(ILaunchConfiguration configuration, boolean osgi) throws CoreException {
        Map map = BundleLauncherHelper.getMergedBundleMap(configuration, osgi);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration, Set set, String attribute) throws CoreException {
        String selected = configuration.getAttribute(attribute, "");
        HashMap map = new HashMap();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            String version;
            String idVersion;
            int versionIndex;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            if (index < 0) {
                token = token.concat("@default:default");
                index = token.indexOf(64);
            }
            String id = (versionIndex = (idVersion = token.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set != null) {
                set.add(id);
            }
            if ((entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                IPluginBase base = models[i].getPluginBase();
                if (base.getVersion().equals(version) || version == null || models.length == 1) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], token.substring(index + 1));
                }
                ++i;
            }
        }
        if (configuration.getAttribute("automaticAdd", true)) {
            Set deselectedPlugins = LaunchPluginValidator.parsePlugins(configuration, "deselected_workspace_plugins");
            IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && !deselectedPlugins.contains(models[i])) {
                    if (set != null) {
                        set.add(id);
                    }
                    if (!map.containsKey(models[i])) {
                        BundleLauncherHelper.addBundleToMap(map, models[i], "default:default");
                    }
                }
                ++i;
            }
        }
        return map;
    }

    private static void addBundleToMap(Map map, IPluginModelBase bundle, String sl) {
        boolean defaultsl;
        BundleDescription desc = bundle.getBundleDescription();
        boolean bl = defaultsl = sl == null || sl.equals("default:default");
        if (desc != null && defaultsl) {
            String modelName = desc.getSymbolicName();
            if ("org.eclipse.equinox.ds".equals(modelName)) {
                map.put(bundle, "1:true");
            } else if ("org.eclipse.equinox.simpleconfigurator".equals(modelName)) {
                map.put(bundle, "1:true");
            } else if ("org.eclipse.equinox.common".equals(modelName)) {
                map.put(bundle, "2:true");
            } else if ("org.eclipse.osgi".equals(modelName)) {
                map.put(bundle, "-1:true");
            } else if ("org.eclipse.update.configurator".equals(modelName)) {
                map.put(bundle, "3:true");
            } else if ("org.eclipse.core.runtime".equals(modelName)) {
                if (TargetPlatformHelper.getTargetVersion() > 3.1) {
                    map.put(bundle, "default:true");
                } else {
                    map.put(bundle, "2:true");
                }
            } else {
                map.put(bundle, sl);
            }
        } else {
            map.put(bundle, sl);
        }
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration, Set set, String attribute) throws CoreException {
        String selected = configuration.getAttribute(attribute, "");
        HashMap map = new HashMap();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            String version;
            String idVersion;
            int versionIndex;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            if (index < 0) {
                token = token.concat("@default:default");
                index = token.indexOf(64);
            }
            String id = (versionIndex = (idVersion = token.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set != null && set.contains(id) || (entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                IPluginBase base;
                if (models[i].isEnabled() && ((base = models[i].getPluginBase()).getVersion().equals(version) || version == null || models.length == 1)) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], token.substring(index + 1));
                }
                ++i;
            }
        }
        return map;
    }

    public static String writeBundleEntry(IPluginModelBase model, String startLevel, String autoStart) {
        boolean hasAutoStart;
        IPluginBase base = model.getPluginBase();
        String id = base.getId();
        StringBuffer buffer = new StringBuffer(id);
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry.getActiveModels().length > 1) {
            buffer.append('*');
            buffer.append(model.getPluginBase().getVersion());
        }
        boolean hasStartLevel = startLevel != null && startLevel.length() > 0;
        boolean bl = hasAutoStart = autoStart != null && autoStart.length() > 0;
        if (hasStartLevel || hasAutoStart) {
            buffer.append('@');
        }
        if (hasStartLevel) {
            buffer.append(startLevel);
        }
        if (hasStartLevel || hasAutoStart) {
            buffer.append(':');
        }
        if (hasAutoStart) {
            buffer.append(autoStart);
        }
        return buffer.toString();
    }

    public static void checkBackwardCompatibility(ILaunchConfiguration configuration, boolean save) throws CoreException {
        boolean upgrade;
        String value2;
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String value = configuration.getAttribute("wsproject", null);
        if (value != null) {
            wc.setAttribute("wsproject", null);
            if (value.indexOf(59) != -1) {
                value = value.replace(';', ',');
            } else if (value.indexOf(58) != -1) {
                value = value.replace(':', ',');
            }
            value = value.length() == 0 || value.equals(",") ? null : value.substring(0, value.length() - 1);
            boolean automatic = configuration.getAttribute("automaticAdd", true);
            String attr = automatic ? "deselected_workspace_plugins" : "selected_workspace_plugins";
            wc.setAttribute(attr, value);
        }
        if ((value2 = configuration.getAttribute("extplugins", null)) != null) {
            wc.setAttribute("extplugins", null);
            if (value2.indexOf(59) != -1) {
                value2 = value2.replace(';', ',');
            } else if (value2.indexOf(58) != -1) {
                value2 = value2.replace(':', ',');
            }
            value2 = value2.length() == 0 || value2.equals(",") ? null : value2.substring(0, value2.length() - 1);
            wc.setAttribute("selected_target_plugins", value2);
        }
        String version = configuration.getAttribute("pde.version", null);
        boolean newApp = TargetPlatformHelper.usesNewApplicationModel();
        boolean bl = upgrade = !"3.3".equals(version) && newApp;
        if (!upgrade) {
            boolean bl2 = upgrade = TargetPlatformHelper.getTargetVersion() >= 3.2 && version == null;
        }
        if (upgrade) {
            wc.setAttribute("pde.version", newApp ? "3.3" : "3.2a");
            boolean usedefault = configuration.getAttribute("default", true);
            boolean useFeatures = configuration.getAttribute("usefeatures", false);
            boolean automaticAdd = configuration.getAttribute("automaticAdd", true);
            if (!usedefault && !useFeatures) {
                ArrayList<String> list = new ArrayList<String>();
                if (version == null) {
                    list.add("org.eclipse.core.contenttype");
                    list.add("org.eclipse.core.jobs");
                    list.add("org.eclipse.equinox.common");
                    list.add("org.eclipse.equinox.preferences");
                    list.add("org.eclipse.equinox.registry");
                    list.add("org.eclipse.core.runtime.compatibility.registry");
                }
                if (!"3.3".equals(version) && newApp) {
                    list.add("org.eclipse.equinox.app");
                }
                StringBuffer extensions = new StringBuffer(configuration.getAttribute("selected_workspace_plugins", ""));
                StringBuffer target = new StringBuffer(configuration.getAttribute("selected_target_plugins", ""));
                int i = 0;
                while (i < list.size()) {
                    String plugin = list.get(i).toString();
                    IPluginModelBase model = PluginRegistry.findModel((String)plugin);
                    if (model != null) {
                        if (model.getUnderlyingResource() != null) {
                            if (!automaticAdd) {
                                if (extensions.length() > 0) {
                                    extensions.append(",");
                                }
                                extensions.append(plugin);
                            }
                        } else {
                            if (target.length() > 0) {
                                target.append(",");
                            }
                            target.append(plugin);
                        }
                    }
                    ++i;
                }
                if (extensions.length() > 0) {
                    wc.setAttribute("selected_workspace_plugins", extensions.toString());
                }
                if (target.length() > 0) {
                    wc.setAttribute("selected_target_plugins", target.toString());
                }
            }
        }
        if (save && (value != null || value2 != null || upgrade)) {
            wc.doSave();
        }
    }
}

