/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IUPropertyUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.PropertyDialogAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AvailableIUGroup;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.IRepositorySelectionListener;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.RepositorySelectionGroup;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.ColocatedRepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditIUContainerPage
extends WizardPage
implements IEditBundleContainerPage {
    private static final IStatus BAD_IU_SELECTION = new Status(4, PDEPlugin.getPluginId(), Messages.EditIUContainerPage_0);
    private IStatus fSelectedIUStatus = Status.OK_STATUS;
    private static final String SETTINGS_GROUP_BY_CATEGORY = "groupByCategory";
    private static final String SETTINGS_SHOW_OLD_VERSIONS = "showVersions";
    private static final String SETTINGS_SELECTED_REPOSITORY = "selectedRepository";
    private URI fRepoLocation;
    private IUBundleContainer fEditContainer;
    private IProfile fProfile;
    private IUViewQueryContext fQueryContext;
    private ITargetDefinition fTarget;
    private RepositorySelectionGroup fRepoSelector;
    private AvailableIUGroup fAvailableIUGroup;
    private Button fPropertiesButton;
    private IAction fPropertyAction;
    private Button fShowCategoriesButton;
    private Button fShowOldVersionsButton;
    private Button fIncludeRequiredButton;
    private Button fAllPlatformsButton;
    private Text fDetailsText;
    static /* synthetic */ Class class$0;

    protected EditIUContainerPage(ITargetDefinition definition, IProfile profile) {
        super("AddP2Container");
        this.setTitle(Messages.EditIUContainerPage_5);
        this.setMessage(Messages.EditIUContainerPage_6);
        this.fTarget = definition;
        this.fProfile = profile;
    }

    protected EditIUContainerPage(IUBundleContainer container, ITargetDefinition definition, IProfile profile) {
        this(definition, profile);
        this.setTitle(Messages.EditIUContainerPage_7);
        this.setMessage(Messages.EditIUContainerPage_6);
        this.fEditContainer = container;
    }

    public IBundleContainer getBundleContainer() {
        URI[] uRIArray;
        ITargetPlatformService service;
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((service = (ITargetPlatformService)pDECore.acquireService(clazz.getName())) == null) {
            PDEPlugin.log((IStatus)new Status(4, PDEPlugin.getPluginId(), Messages.EditIUContainerPage_9));
        }
        IInstallableUnit[] iInstallableUnitArray = this.fAvailableIUGroup.getCheckedLeafIUs();
        if (this.fRepoLocation != null) {
            URI[] uRIArray2 = new URI[1];
            uRIArray = uRIArray2;
            uRIArray2[0] = this.fRepoLocation;
        } else {
            uRIArray = null;
        }
        IUBundleContainer container = (IUBundleContainer)service.newIUContainer(iInstallableUnitArray, uRIArray);
        container.setIncludeAllRequired(this.fIncludeRequiredButton.getSelection(), this.fTarget);
        container.setIncludeAllEnvironments(this.fAllPlatformsButton.getSelection(), this.fTarget);
        return container;
    }

    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(SETTINGS_GROUP_BY_CATEGORY, this.fShowCategoriesButton.getSelection());
            settings.put(SETTINGS_SHOW_OLD_VERSIONS, this.fShowOldVersionsButton.getSelection());
            settings.put(SETTINGS_SELECTED_REPOSITORY, this.fRepoLocation != null ? this.fRepoLocation.toString() : null);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        this.createQueryContext();
        this.createRepositoryComboArea(composite);
        this.createAvailableIUArea(composite);
        this.createDetailsArea(composite);
        this.createCheckboxArea(composite);
        this.setPageComplete(false);
        this.restoreWidgetState();
        this.setControl((Control)composite);
        this.setPageComplete(false);
        if (this.fEditContainer == null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.location_add_site_wizard");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.location_edit_site_wizard");
        }
    }

    private void createRepositoryComboArea(Composite parent) {
        Policy policy = new Policy();
        policy.setRepositoryManipulator((RepositoryManipulator)new ColocatedRepositoryManipulator(policy, null));
        this.fRepoSelector = new RepositorySelectionGroup(this.getContainer(), parent, policy, this.fQueryContext);
        this.fRepoSelector.addRepositorySelectionListener(new IRepositorySelectionListener(){

            public void repositorySelectionChanged(int repoChoice, URI repoLocation) {
                EditIUContainerPage.this.fAvailableIUGroup.setRepositoryFilter(repoChoice, repoLocation);
                EditIUContainerPage.this.fRepoLocation = repoChoice == 4 ? repoLocation : null;
                if (repoChoice == 2) {
                    EditIUContainerPage.this.setDescription(Messages.EditIUContainerPage_10);
                } else {
                    EditIUContainerPage.this.setDescription(Messages.EditIUContainerPage_11);
                }
                EditIUContainerPage.this.pageChanged();
            }
        });
    }

    private void createAvailableIUArea(Composite parent) {
        this.fAvailableIUGroup = new AvailableIUGroup(parent);
        this.fAvailableIUGroup.getCheckboxTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IInstallableUnit[] units = EditIUContainerPage.this.fAvailableIUGroup.getCheckedLeafIUs();
                if (units.length > 0) {
                    EditIUContainerPage.this.fSelectedIUStatus = Status.OK_STATUS;
                } else {
                    EditIUContainerPage.this.fSelectedIUStatus = BAD_IU_SELECTION;
                }
                EditIUContainerPage.this.pageChanged();
            }
        });
        this.fAvailableIUGroup.getCheckboxTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditIUContainerPage.this.updateDetails();
                EditIUContainerPage.this.fPropertiesButton.setEnabled(EditIUContainerPage.this.fAvailableIUGroup.getSelectedIUElements().length == 1);
            }
        });
        this.fAvailableIUGroup.setUseBoldFontForFilteredItems(true);
        GridData data = (GridData)this.fAvailableIUGroup.getStructuredViewer().getControl().getLayoutData();
        data.heightHint = 200;
    }

    private void createDetailsArea(Composite parent) {
        Group detailsGroup = SWTFactory.createGroup(parent, Messages.EditIUContainerPage_12, 1, 1, 768);
        this.fDetailsText = SWTFactory.createText((Composite)detailsGroup, 72, 1, 768);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 50;
        gd.widthHint = 400;
        this.fDetailsText.setLayoutData((Object)gd);
        this.fPropertiesButton = SWTFactory.createPushButton((Composite)detailsGroup, Messages.EditIUContainerPage_13, null);
        ((GridData)this.fPropertiesButton.getLayoutData()).horizontalAlignment = 131072;
        this.fPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditIUContainerPage.this.fPropertyAction.run();
            }
        });
        this.fPropertyAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this.fAvailableIUGroup.getStructuredViewer());
        this.fPropertiesButton.setEnabled(false);
    }

    private void createCheckboxArea(Composite parent) {
        Composite checkComp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        checkComp.setLayout((Layout)new GridLayout(2, true));
        this.fShowCategoriesButton = SWTFactory.createCheckButton(checkComp, Messages.EditIUContainerPage_14, null, true, 1);
        this.fShowCategoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIUContainerPage.this.updateViewContext();
            }
        });
        this.fShowOldVersionsButton = SWTFactory.createCheckButton(checkComp, Messages.EditIUContainerPage_15, null, true, 1);
        this.fShowOldVersionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIUContainerPage.this.updateViewContext();
            }
        });
        Group slicerGroup = SWTFactory.createGroup(parent, Messages.EditIUContainerPage_1, 1, 1, 768);
        SWTFactory.createWrapLabel((Composite)slicerGroup, Messages.EditIUContainerPage_2, 1, 400);
        this.fIncludeRequiredButton = SWTFactory.createCheckButton((Composite)slicerGroup, Messages.EditIUContainerPage_3, null, true, 1);
        this.fIncludeRequiredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIUContainerPage.this.fAllPlatformsButton.setEnabled(!EditIUContainerPage.this.fIncludeRequiredButton.getSelection());
                EditIUContainerPage.this.warnIfGlobalSettingChanged();
            }
        });
        this.fAllPlatformsButton = SWTFactory.createCheckButton((Composite)slicerGroup, Messages.EditIUContainerPage_8, null, false, 1);
        this.fAllPlatformsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIUContainerPage.this.warnIfGlobalSettingChanged();
            }
        });
        ((GridData)this.fAllPlatformsButton.getLayoutData()).horizontalIndent = 10;
    }

    private void warnIfGlobalSettingChanged() {
        IBundleContainer[] containers;
        boolean warn = false;
        if (this.fTarget != null && (containers = this.fTarget.getBundleContainers()) != null) {
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IUBundleContainer && containers[i] != this.fEditContainer) {
                    IUBundleContainer container = (IUBundleContainer)containers[i];
                    if (container.getIncludeAllRequired() != this.fIncludeRequiredButton.getSelection()) {
                        warn = true;
                        break;
                    }
                    if (!this.fIncludeRequiredButton.getSelection() && container.getIncludeAllEnvironments() != this.fAllPlatformsButton.getSelection()) {
                        warn = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (warn) {
            this.setMessage(Messages.EditIUContainerPage_4, 2);
        } else {
            this.setMessage(Messages.EditIUContainerPage_6);
        }
    }

    private void createQueryContext() {
        this.fQueryContext = Policy.getDefault().getQueryContext();
        this.fQueryContext.setInstalledProfileId(this.fProfile.getProfileId());
        this.fQueryContext.showAlreadyInstalled();
    }

    private void updateViewContext() {
        if (this.fShowCategoriesButton.getSelection()) {
            this.fQueryContext.setViewType(1);
        } else {
            this.fQueryContext.setViewType(3);
        }
        this.fQueryContext.setShowLatestVersionsOnly(this.fShowOldVersionsButton.getSelection());
        this.fAvailableIUGroup.updateAvailableViewState();
    }

    private void updateDetails() {
        IInstallableUnit[] selected = this.fAvailableIUGroup.getSelectedIUs();
        if (selected.length == 1) {
            StringBuffer result = new StringBuffer();
            String description = IUPropertyUtils.getIUProperty((IInstallableUnit)selected[0], (String)"org.eclipse.equinox.p2.description");
            if (description != null) {
                result.append(description);
            } else {
                String name = IUPropertyUtils.getIUProperty((IInstallableUnit)selected[0], (String)"org.eclipse.equinox.p2.name");
                if (name != null) {
                    result.append(name);
                } else {
                    result.append(selected[0].getId());
                }
                result.append(" ");
                result.append(selected[0].getVersion().toString());
            }
            this.fDetailsText.setText(result.toString());
            return;
        }
        this.fDetailsText.setText("");
    }

    void pageChanged() {
        if (this.fSelectedIUStatus.getSeverity() == 4) {
            this.setErrorMessage(this.fSelectedIUStatus.getMessage());
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private void restoreWidgetState() {
        IBundleContainer[] containers;
        IDialogSettings settings = this.getDialogSettings();
        URI uri = null;
        boolean showCategories = this.fQueryContext.shouldGroupByCategories();
        boolean showOldVersions = this.fQueryContext.getShowLatestVersionsOnly();
        if (this.fEditContainer != null) {
            if (this.fEditContainer.getRepositories() != null) {
                uri = this.fEditContainer.getRepositories()[0];
            }
        } else if (settings != null) {
            String stringURI = settings.get(SETTINGS_SELECTED_REPOSITORY);
            if (stringURI != null && stringURI.trim().length() > 0) {
                try {
                    uri = new URI(stringURI);
                }
                catch (URISyntaxException e) {
                    PDEPlugin.log(e);
                }
            }
            if (settings.get(SETTINGS_GROUP_BY_CATEGORY) != null) {
                showCategories = settings.getBoolean(SETTINGS_GROUP_BY_CATEGORY);
            }
            if (settings.get(SETTINGS_SHOW_OLD_VERSIONS) != null) {
                showOldVersions = settings.getBoolean(SETTINGS_SHOW_OLD_VERSIONS);
            }
        }
        if (uri != null) {
            this.fRepoSelector.setRepositorySelection(4, uri);
        } else if (this.fEditContainer != null) {
            this.fRepoSelector.setRepositorySelection(1, null);
        } else {
            this.fRepoSelector.setRepositorySelection(2, null);
        }
        this.fShowCategoriesButton.setSelection(showCategories);
        this.fShowOldVersionsButton.setSelection(showOldVersions);
        if (this.fEditContainer != null) {
            this.fIncludeRequiredButton.setSelection(this.fEditContainer.getIncludeAllRequired());
            this.fAllPlatformsButton.setSelection(this.fEditContainer.getIncludeAllEnvironments());
        } else {
            IBundleContainer[] knownContainers = this.fTarget.getBundleContainers();
            if (knownContainers != null) {
                int i = 0;
                while (i < knownContainers.length) {
                    if (knownContainers[i] instanceof IUBundleContainer) {
                        this.fIncludeRequiredButton.setSelection(((IUBundleContainer)knownContainers[i]).getIncludeAllRequired());
                    }
                    ++i;
                }
            }
        }
        if (this.fTarget != null && (containers = this.fTarget.getBundleContainers()) != null) {
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IUBundleContainer && containers[i] != this.fEditContainer) {
                    this.fIncludeRequiredButton.setSelection(((IUBundleContainer)containers[i]).getIncludeAllRequired());
                    this.fAllPlatformsButton.setSelection(((IUBundleContainer)containers[i]).getIncludeAllEnvironments());
                    break;
                }
                ++i;
            }
        }
        this.fAllPlatformsButton.setEnabled(!this.fIncludeRequiredButton.getSelection());
        this.updateViewContext();
        this.fRepoSelector.getDefaultFocusControl().setFocus();
        this.updateDetails();
        if (this.fEditContainer != null) {
            try {
                this.fQueryContext.setViewType(3);
                this.fAvailableIUGroup.updateAvailableViewState();
                this.fAvailableIUGroup.setChecked((Object[])this.fEditContainer.getInstallableUnits(this.fProfile));
                this.updateViewContext();
                IInstallableUnit[] units = this.fAvailableIUGroup.getCheckedLeafIUs();
                if (units.length > 0) {
                    this.fAvailableIUGroup.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection((Object)units[0]), true);
                }
                this.fAvailableIUGroup.getCheckboxTreeViewer().collapseAll();
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }
    }
}

