/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.shared.target.ArgumentsFromContainerSelectionDialog;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.pde.internal.ui.shared.target.TargetContentsGroup;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationsGroup;
import org.eclipse.pde.internal.ui.util.LocaleUtil;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.UIJob;

public class TargetDefinitionContentPage
extends TargetDefinitionPage {
    private static final String EMPTY_STRING = "";
    private Text fNameText;
    private TabItem fLocationTab;
    private TargetLocationsGroup fLocationTree;
    private TargetContentsGroup fContentTree;
    private Combo fOSCombo;
    private Combo fWSCombo;
    private Combo fArchCombo;
    private Combo fNLCombo;
    private TreeSet fNLChoices;
    private TreeSet fOSChoices;
    private TreeSet fWSChoices;
    private TreeSet fArchChoices;
    private Button fDefaultJREButton;
    private Button fNamedJREButton;
    private Button fExecEnvButton;
    private Combo fNamedJREsCombo;
    private Combo fExecEnvsCombo;
    private TreeSet fExecEnvChoices;
    private Text fProgramArgs;
    private Text fVMArgs;
    private TableViewer fElementViewer;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fRemoveAllButton;

    public TargetDefinitionContentPage(ITargetDefinition target) {
        super("targetContent", target);
        this.setTitle(PDEUIMessages.TargetDefinitionContentPage_1);
        this.setDescription(PDEUIMessages.TargetDefinitionContentPage_2);
        this.setImageDescriptor(PDEPluginImages.DESC_TARGET_WIZ);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        Composite nameComp = SWTFactory.createComposite(comp, 2, 1, 768, 0, 0);
        SWTFactory.createLabel(nameComp, PDEUIMessages.TargetDefinitionContentPage_4, 1);
        this.fNameText = SWTFactory.createSingleText(nameComp, 1);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = TargetDefinitionContentPage.this.fNameText.getText().trim();
                if (name.length() == 0) {
                    TargetDefinitionContentPage.this.setErrorMessage(PDEUIMessages.TargetDefinitionContentPage_7);
                } else {
                    TargetDefinitionContentPage.this.setErrorMessage(null);
                    TargetDefinitionContentPage.this.setMessage(PDEUIMessages.TargetDefinitionContentPage_2);
                }
                TargetDefinitionContentPage.this.getTargetDefinition().setName(name);
                TargetDefinitionContentPage.this.setPageComplete(TargetDefinitionContentPage.this.isPageComplete());
            }
        });
        TabFolder tabs = new TabFolder(comp, 0);
        tabs.setLayoutData((Object)new GridData(1808));
        this.fLocationTab = new TabItem(tabs, 0);
        this.fLocationTab.setText(PDEUIMessages.LocationSection_0);
        Composite pluginTabContainer = SWTFactory.createComposite((Composite)tabs, 1, 1, 1808);
        SWTFactory.createWrapLabel(pluginTabContainer, PDEUIMessages.ContentSection_1, 2, 400);
        this.fLocationTree = TargetLocationsGroup.createInDialog(pluginTabContainer);
        this.fLocationTab.setControl((Control)pluginTabContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pluginTabContainer, "org.eclipse.pde.doc.user.edit_target_wizard_locations_tab");
        TabItem contentTab = new TabItem(tabs, 0);
        contentTab.setText(PDEUIMessages.TargetDefinitionContentPage_6);
        Composite contentTabContainer = SWTFactory.createComposite((Composite)tabs, 1, 1, 1808);
        SWTFactory.createWrapLabel(contentTabContainer, PDEUIMessages.ContentSection_1, 2, 400);
        this.fContentTree = new TargetContentsGroup(contentTabContainer);
        contentTab.setControl((Control)contentTabContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)contentTabContainer, "org.eclipse.pde.doc.user.edit_target_wizard_content_tab");
        TabItem envTab = new TabItem(tabs, 0);
        envTab.setText(PDEUIMessages.TargetDefinitionEnvironmentPage_3);
        Composite envTabContainer = SWTFactory.createComposite((Composite)tabs, 1, 1, 1808);
        this.createTargetEnvironmentGroup(envTabContainer);
        this.createJREGroup(envTabContainer);
        envTab.setControl((Control)envTabContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)envTabContainer, "org.eclipse.pde.doc.user.edit_target_wizard_environment_tab");
        TabItem argsTab = new TabItem(tabs, 0);
        argsTab.setText(PDEUIMessages.TargetDefinitionEnvironmentPage_4);
        argsTab.setControl(this.createArgumentsGroup((Composite)tabs));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(argsTab.getControl(), "org.eclipse.pde.doc.user.edit_target_wizard_argument_tab");
        TabItem depTab = new TabItem(tabs, 0);
        depTab.setText(PDEUIMessages.TargetDefinitionEnvironmentPage_5);
        depTab.setControl(this.createImplicitTabContents((Composite)tabs));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(depTab.getControl(), "org.eclipse.pde.doc.user.edit_target_wizard_implicit_tab");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.pde.doc.user.edit_target_wizard");
        this.initializeListeners();
        this.targetChanged(this.getTargetDefinition());
        this.setControl((Control)comp);
    }

    private void initializeListeners() {
        ITargetChangedListener listener = new ITargetChangedListener(){

            public void contentsChanged(ITargetDefinition definition, Object source, boolean resolve, boolean forceResolve) {
                if (forceResolve || resolve && !definition.isResolved()) {
                    try {
                        TargetDefinitionContentPage.this.getContainer().run(true, true, new IRunnableWithProgress(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                2.access$0(this.this$1).getTargetDefinition().resolve((IProgressMonitor)2.access$0(this.this$1).new ResolutionProgressMonitor(monitor));
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        PDECore.log((Throwable)e);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (TargetDefinitionContentPage.this.fContentTree != source) {
                    TargetDefinitionContentPage.this.fContentTree.setInput(definition);
                }
                if (TargetDefinitionContentPage.this.fLocationTree != source) {
                    TargetDefinitionContentPage.this.fLocationTree.setInput(definition);
                }
                if (definition.isResolved() && definition.getBundleStatus().getSeverity() == 4) {
                    TargetDefinitionContentPage.this.fLocationTab.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                } else {
                    TargetDefinitionContentPage.this.fLocationTab.setImage(null);
                }
            }

            static /* synthetic */ TargetDefinitionContentPage access$0(2 var0) {
                return var0.TargetDefinitionContentPage.this;
            }
        };
        this.fContentTree.addTargetChangedListener(listener);
        this.fLocationTree.addTargetChangedListener(listener);
    }

    protected void targetChanged(ITargetDefinition definition) {
        super.targetChanged(definition);
        if (definition != null) {
            new UIJob(PDEUIMessages.TargetDefinitionContentPage_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ITargetDefinition definition = TargetDefinitionContentPage.this.getTargetDefinition();
                    if (!definition.isResolved()) {
                        try {
                            TargetDefinitionContentPage.this.getContainer().run(true, true, new IRunnableWithProgress(this){
                                final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    4.access$0(this.this$1).getTargetDefinition().resolve((IProgressMonitor)4.access$0(this.this$1).new ResolutionProgressMonitor(monitor));
                                    if (monitor.isCanceled()) {
                                        throw new InterruptedException();
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            PDECore.log((Throwable)e);
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    TargetDefinitionContentPage.this.fContentTree.setInput(definition);
                    TargetDefinitionContentPage.this.fLocationTree.setInput(definition);
                    if (definition.isResolved() && definition.getBundleStatus().getSeverity() == 4) {
                        TargetDefinitionContentPage.this.fLocationTab.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                    } else {
                        TargetDefinitionContentPage.this.fLocationTab.setImage(null);
                    }
                    return Status.OK_STATUS;
                }

                static /* synthetic */ TargetDefinitionContentPage access$0(4 var0) {
                    return var0.TargetDefinitionContentPage.this;
                }
            }.schedule();
            String name = definition.getName();
            if (name == null) {
                name = EMPTY_STRING;
            }
            if (name.trim().length() > 0) {
                this.fNameText.setText(name);
            } else {
                this.setMessage(PDEUIMessages.TargetDefinitionContentPage_8);
            }
            this.fLocationTree.setInput(definition);
            this.fContentTree.setInput(definition);
            String presetValue = definition.getOS() == null ? EMPTY_STRING : definition.getOS();
            this.fOSCombo.setText(presetValue);
            presetValue = definition.getWS() == null ? EMPTY_STRING : definition.getWS();
            this.fWSCombo.setText(presetValue);
            presetValue = definition.getArch() == null ? EMPTY_STRING : definition.getArch();
            this.fArchCombo.setText(presetValue);
            presetValue = definition.getNL() == null ? EMPTY_STRING : LocaleUtil.expandLocaleName(definition.getNL());
            this.fNLCombo.setText(presetValue);
            IPath jrePath = definition.getJREContainer();
            if (jrePath == null || jrePath.equals((Object)JavaRuntime.newDefaultJREContainerPath())) {
                this.fDefaultJREButton.setSelection(true);
            } else {
                String ee = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
                if (ee != null) {
                    this.fExecEnvButton.setSelection(true);
                    this.fExecEnvsCombo.select(this.fExecEnvsCombo.indexOf(ee));
                } else {
                    String vm = JavaRuntime.getVMInstallName((IPath)jrePath);
                    if (vm != null) {
                        this.fNamedJREButton.setSelection(true);
                        this.fNamedJREsCombo.select(this.fNamedJREsCombo.indexOf(vm));
                    }
                }
            }
            if (this.fExecEnvsCombo.getSelectionIndex() == -1) {
                this.fExecEnvsCombo.setText(this.fExecEnvChoices.first().toString());
            }
            if (this.fNamedJREsCombo.getSelectionIndex() == -1) {
                this.fNamedJREsCombo.setText(VMUtil.getDefaultVMInstallName());
            }
            this.updateJREWidgets();
            presetValue = definition.getProgramArguments() == null ? EMPTY_STRING : definition.getProgramArguments();
            this.fProgramArgs.setText(presetValue);
            presetValue = definition.getVMArguments() == null ? EMPTY_STRING : definition.getVMArguments();
            this.fVMArgs.setText(presetValue);
            this.fElementViewer.refresh();
        }
    }

    private void createTargetEnvironmentGroup(Composite container) {
        Group group = SWTFactory.createGroup(container, PDEUIMessages.EnvironmentBlock_targetEnv, 2, 1, 768);
        this.initializeChoices();
        SWTFactory.createLabel((Composite)group, PDEUIMessages.Preferences_TargetEnvironmentPage_os, 1);
        this.fOSCombo = SWTFactory.createCombo((Composite)group, 2052, 1, this.fOSChoices.toArray(new String[this.fOSChoices.size()]));
        this.fOSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setOS(TargetDefinitionContentPage.this.getModelValue(TargetDefinitionContentPage.this.fOSCombo.getText()));
            }
        });
        this.fOSCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setOS(TargetDefinitionContentPage.this.getModelValue(TargetDefinitionContentPage.this.fOSCombo.getText()));
            }
        });
        SWTFactory.createLabel((Composite)group, PDEUIMessages.Preferences_TargetEnvironmentPage_ws, 1);
        this.fWSCombo = SWTFactory.createCombo((Composite)group, 2052, 1, this.fWSChoices.toArray(new String[this.fWSChoices.size()]));
        this.fWSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setWS(TargetDefinitionContentPage.this.getModelValue(TargetDefinitionContentPage.this.fWSCombo.getText()));
            }
        });
        this.fWSCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setWS(TargetDefinitionContentPage.this.getModelValue(TargetDefinitionContentPage.this.fWSCombo.getText()));
            }
        });
        SWTFactory.createLabel((Composite)group, PDEUIMessages.Preferences_TargetEnvironmentPage_arch, 1);
        this.fArchCombo = SWTFactory.createCombo((Composite)group, 2052, 1, this.fArchChoices.toArray(new String[this.fArchChoices.size()]));
        this.fArchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setArch(TargetDefinitionContentPage.this.getModelValue(TargetDefinitionContentPage.this.fArchCombo.getText()));
            }
        });
        this.fArchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setArch(TargetDefinitionContentPage.this.getModelValue(TargetDefinitionContentPage.this.fArchCombo.getText()));
            }
        });
        SWTFactory.createLabel((Composite)group, PDEUIMessages.Preferences_TargetEnvironmentPage_nl, 1);
        this.fNLCombo = SWTFactory.createCombo((Composite)group, 2052, 1, this.fNLChoices.toArray(new String[this.fNLChoices.size()]));
        this.fNLCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = TargetDefinitionContentPage.this.fNLCombo.getText();
                int index = value.indexOf("-");
                if (index > 0) {
                    value = value.substring(0, index);
                }
                TargetDefinitionContentPage.this.getTargetDefinition().setNL(TargetDefinitionContentPage.this.getModelValue(value));
            }
        });
        this.fNLCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = TargetDefinitionContentPage.this.fNLCombo.getText();
                int index = value.indexOf("-");
                if (index > 0) {
                    value = value.substring(0, index);
                }
                TargetDefinitionContentPage.this.getTargetDefinition().setNL(TargetDefinitionContentPage.this.getModelValue(value));
            }
        });
    }

    private String getModelValue(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    private void addExtraChoices(Set set, String preference) {
        StringTokenizer tokenizer = new StringTokenizer(preference, ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
    }

    private void initializeChoices() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.pde.core");
        this.fOSChoices = new TreeSet();
        String[] os = Platform.knownOSValues();
        int i = 0;
        while (i < os.length) {
            this.fOSChoices.add(os[i]);
            ++i;
        }
        String pref = node.get("org.eclipse.pde.os.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fOSChoices, pref);
        }
        this.fWSChoices = new TreeSet();
        String[] ws = Platform.knownWSValues();
        int i2 = 0;
        while (i2 < ws.length) {
            this.fWSChoices.add(ws[i2]);
            ++i2;
        }
        pref = node.get("org.eclipse.pde.ws.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fWSChoices, pref);
        }
        this.fArchChoices = new TreeSet();
        String[] arch = Platform.knownOSArchValues();
        int i3 = 0;
        while (i3 < arch.length) {
            this.fArchChoices.add(arch[i3]);
            ++i3;
        }
        pref = node.get("org.eclipse.pde.arch.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fArchChoices, pref);
        }
        this.fNLChoices = new TreeSet();
        String[] nl = LocaleUtil.getLocales();
        int i4 = 0;
        while (i4 < nl.length) {
            this.fNLChoices.add(nl[i4]);
            ++i4;
        }
        pref = node.get("org.eclipse.pde.nl.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fNLChoices, pref);
        }
    }

    private void createJREGroup(Composite container) {
        Group group = SWTFactory.createGroup(container, PDEUIMessages.EnvironmentBlock_jreTitle, 2, 1, 768);
        this.initializeJREValues();
        SWTFactory.createWrapLabel((Composite)group, PDEUIMessages.JRESection_description, 2);
        this.fDefaultJREButton = SWTFactory.createRadioButton((Composite)group, PDEUIMessages.JRESection_defaultJRE, 2);
        this.fDefaultJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.updateJREWidgets();
                TargetDefinitionContentPage.this.getTargetDefinition().setJREContainer(JavaRuntime.newDefaultJREContainerPath());
            }
        });
        this.fNamedJREButton = SWTFactory.createRadioButton((Composite)group, PDEUIMessages.JRESection_JREName);
        this.fNamedJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.updateJREWidgets();
                TargetDefinitionContentPage.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IVMInstall)VMUtil.getVMInstall((String)TargetDefinitionContentPage.this.fNamedJREsCombo.getText())));
            }
        });
        this.fNamedJREsCombo = SWTFactory.createCombo((Composite)group, 2060, 1, VMUtil.getVMInstallNames());
        this.fNamedJREsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IVMInstall)VMUtil.getVMInstall((String)TargetDefinitionContentPage.this.fNamedJREsCombo.getText())));
            }
        });
        this.fExecEnvButton = SWTFactory.createRadioButton((Composite)group, PDEUIMessages.JRESection_ExecutionEnv);
        this.fExecEnvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.updateJREWidgets();
                TargetDefinitionContentPage.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IExecutionEnvironment)VMUtil.getExecutionEnvironment((String)TargetDefinitionContentPage.this.fExecEnvsCombo.getText())));
            }
        });
        this.fExecEnvsCombo = SWTFactory.createCombo((Composite)group, 2060, 1, this.fExecEnvChoices.toArray(new String[this.fExecEnvChoices.size()]));
        this.fExecEnvsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IExecutionEnvironment)VMUtil.getExecutionEnvironment((String)TargetDefinitionContentPage.this.fExecEnvsCombo.getText())));
            }
        });
    }

    protected void initializeJREValues() {
        this.fExecEnvChoices = new TreeSet();
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
        int i = 0;
        while (i < envs.length) {
            this.fExecEnvChoices.add(envs[i].getId());
            ++i;
        }
    }

    protected void updateJREWidgets() {
        this.fNamedJREsCombo.setEnabled(this.fNamedJREButton.getSelection());
        this.fExecEnvsCombo.setEnabled(this.fExecEnvButton.getSelection());
    }

    private Control createArgumentsGroup(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, 1, 1, 1808);
        SWTFactory.createWrapLabel(container, PDEUIMessages.JavaArgumentsTab_description, 1);
        Group programGroup = SWTFactory.createGroup(container, PDEUIMessages.JavaArgumentsTab_progamArgsGroup, 1, 1, 768);
        this.fProgramArgs = SWTFactory.createText((Composite)programGroup, 2626, 1, 200, 60, 1808);
        this.fProgramArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setProgramArguments(TargetDefinitionContentPage.this.fProgramArgs.getText().trim());
            }
        });
        Button programVars = new Button((Composite)programGroup, 0);
        programVars.setLayoutData((Object)new GridData(128));
        programVars.setText(PDEUIMessages.JavaArgumentsTab_programVariables);
        programVars.addSelectionListener(this.getVariablesListener(this.fProgramArgs));
        Group vmGroup = new Group(container, 0);
        vmGroup.setLayout((Layout)new GridLayout(1, false));
        vmGroup.setLayoutData((Object)new GridData(768));
        vmGroup.setText(PDEUIMessages.JavaArgumentsTab_vmArgsGroup);
        this.fVMArgs = SWTFactory.createText((Composite)vmGroup, 2626, 1, 200, 60, 1808);
        this.fVMArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionContentPage.this.getTargetDefinition().setVMArguments(TargetDefinitionContentPage.this.fVMArgs.getText().trim());
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)vmGroup, 2, 1, 128, 0, 0);
        Button vmArgs = SWTFactory.createPushButton(buttons, PDEUIMessages.JavaArgumentsTab_addVMArgs, null, 128);
        vmArgs.addSelectionListener(this.getVMArgsListener(this.fVMArgs));
        Button vmVars = SWTFactory.createPushButton(buttons, PDEUIMessages.JavaArgumentsTab_vmVariables, null, 128);
        vmVars.addSelectionListener(this.getVariablesListener(this.fVMArgs));
        return container;
    }

    private SelectionListener getVMArgsListener(Text textControl) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] args;
                ArgumentsFromContainerSelectionDialog dialog = new ArgumentsFromContainerSelectionDialog(TargetDefinitionContentPage.this.getShell(), TargetDefinitionContentPage.this.getTargetDefinition());
                if (dialog.open() == 0 && (args = dialog.getSelectedArguments()) != null && args.length > 0) {
                    StringBuffer resultBuffer = new StringBuffer();
                    int index = 0;
                    while (index < args.length) {
                        resultBuffer.append(String.valueOf(args[index]) + " ");
                        ++index;
                    }
                    TargetDefinitionContentPage.this.fVMArgs.insert(resultBuffer.toString());
                }
            }
        };
    }

    private SelectionListener getVariablesListener(final Text textControl) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(TargetDefinitionContentPage.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    textControl.insert(variable);
                }
            }
        };
    }

    private Control createImplicitTabContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createImpLabel(container);
        this.createImpTable(container);
        this.createImpButtons(container);
        return container;
    }

    private void createImpLabel(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.TargetImplicitPluginsTab_desc);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    private void createImpTable(Composite container) {
        this.fElementViewer = new TableViewer(container, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.fElementViewer.getControl().setLayoutData((Object)gd);
        this.fElementViewer.setContentProvider((IContentProvider)new DefaultTableProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] bundles;
                ITargetDefinition target = TargetDefinitionContentPage.this.getTargetDefinition();
                if (target != null && (bundles = target.getImplicitDependencies()) != null) {
                    return bundles;
                }
                return new BundleInfo[0];
            }
        });
        this.fElementViewer.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(false, false));
        this.fElementViewer.setInput((Object)PDEPlugin.getDefault());
        this.fElementViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                BundleInfo bundle1 = (BundleInfo)e1;
                BundleInfo bundle2 = (BundleInfo)e2;
                return super.compare(viewer, (Object)bundle1.getSymbolicName(), (Object)bundle2.getSymbolicName());
            }
        });
        this.fElementViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetDefinitionContentPage.this.updateImpButtons();
            }
        });
        this.fElementViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && e.stateMask == 0) {
                    TargetDefinitionContentPage.this.handleRemove();
                }
            }
        });
    }

    private void createImpButtons(Composite container) {
        Composite buttonContainer = SWTFactory.createComposite(container, 1, 1, 1040, 0, 0);
        this.fAddButton = new Button(buttonContainer, 8);
        this.fAddButton.setText(PDEUIMessages.SourceBlock_add);
        this.fAddButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.handleAdd();
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.fRemoveButton.setText(PDEUIMessages.SourceBlock_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.handleRemove();
            }
        });
        this.fRemoveAllButton = new Button(buttonContainer, 8);
        this.fRemoveAllButton.setText(PDEUIMessages.TargetImplicitPluginsTab_removeAll3);
        this.fRemoveAllButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fRemoveAllButton);
        this.fRemoveAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionContentPage.this.handleRemoveAll();
            }
        });
        this.updateImpButtons();
    }

    protected void handleAdd() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new StyledBundleLabelProvider(false, false));
        try {
            dialog.setElements((Object[])this.getValidBundles());
        }
        catch (CoreException e) {
            dialog.setMessage(e.getMessage());
        }
        dialog.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        dialog.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            Object[] models = dialog.getResult();
            ArrayList<BundleInfo> pluginsToAdd = new ArrayList<BundleInfo>();
            int i = 0;
            while (i < models.length) {
                BundleInfo desc = (BundleInfo)models[i];
                pluginsToAdd.add(new BundleInfo(desc.getSymbolicName(), null, null, -1, false));
                ++i;
            }
            HashSet<BundleInfo> allDependencies = new HashSet<BundleInfo>();
            allDependencies.addAll(pluginsToAdd);
            BundleInfo[] currentBundles = this.getTargetDefinition().getImplicitDependencies();
            if (currentBundles != null) {
                allDependencies.addAll(Arrays.asList(currentBundles));
            }
            this.getTargetDefinition().setImplicitDependencies(allDependencies.toArray(new BundleInfo[allDependencies.size()]));
            this.fElementViewer.refresh();
            this.updateImpButtons();
        }
    }

    protected BundleInfo[] getValidBundles() throws CoreException {
        BundleInfo[] current = this.getTargetDefinition().getImplicitDependencies();
        HashSet<String> currentBundles = new HashSet<String>();
        if (current != null) {
            int i = 0;
            while (i < current.length) {
                if (!currentBundles.contains(current[i].getSymbolicName())) {
                    currentBundles.add(current[i].getSymbolicName());
                }
                ++i;
            }
        }
        ArrayList<BundleInfo> targetBundles = new ArrayList<BundleInfo>();
        IResolvedBundle[] allTargetBundles = this.getTargetDefinition().getAllBundles();
        if (allTargetBundles == null || allTargetBundles.length == 0) {
            throw new CoreException((IStatus)new Status(2, PDEPlugin.getPluginId(), PDEUIMessages.ImplicitDependenciesSection_0));
        }
        int i = 0;
        while (i < allTargetBundles.length) {
            BundleInfo bundleInfo = allTargetBundles[i].getBundleInfo();
            if (!currentBundles.contains(bundleInfo.getSymbolicName())) {
                currentBundles.add(bundleInfo.getSymbolicName());
                targetBundles.add(bundleInfo);
            }
            ++i;
        }
        return targetBundles.toArray(new BundleInfo[targetBundles.size()]);
    }

    private void handleRemove() {
        LinkedList<BundleInfo> bundles = new LinkedList<BundleInfo>();
        bundles.addAll(Arrays.asList(this.getTargetDefinition().getImplicitDependencies()));
        Object[] removeBundles = ((IStructuredSelection)this.fElementViewer.getSelection()).toArray();
        if (removeBundles.length > 0) {
            int i = 0;
            while (i < removeBundles.length) {
                if (removeBundles[i] instanceof BundleInfo) {
                    bundles.remove(removeBundles[i]);
                }
                ++i;
            }
            this.getTargetDefinition().setImplicitDependencies(bundles.toArray(new BundleInfo[bundles.size()]));
            this.fElementViewer.refresh();
            this.updateImpButtons();
        }
    }

    private void handleRemoveAll() {
        this.getTargetDefinition().setImplicitDependencies(null);
        this.fElementViewer.refresh();
        this.updateImpButtons();
    }

    private void updateImpButtons() {
        boolean empty = this.fElementViewer.getSelection().isEmpty();
        this.fRemoveButton.setEnabled(!empty);
        boolean hasElements = this.fElementViewer.getTable().getItemCount() > 0;
        this.fRemoveAllButton.setEnabled(hasElements);
    }

    public boolean isPageComplete() {
        return this.fNameText.getText().trim().length() != 0;
    }

    class ResolutionProgressMonitor
    extends ProgressMonitorWrapper {
        ResolutionProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public void setBlocked(IStatus reason) {
            this.subTask(reason.getMessage());
        }

        public void clearBlocked() {
            this.subTask(TargetDefinitionContentPage.EMPTY_STRING);
        }
    }
}

