/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.UndoManagerAdapter;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.UndoManagerAction;
import org.eclipse.swt.widgets.Shell;

public class RedoRefactoringAction
extends UndoManagerAction {
    private int fPatternLength;

    protected String getName() {
        return RefactoringUIMessages.RedoRefactoringAction_name;
    }

    protected IRunnableWithProgress createOperation(Shell parent) {
        final UndoManagerAction.Query query = new UndoManagerAction.Query(parent, RefactoringUIMessages.RedoRefactoringAction_error_title){

            protected String getFullMessage(String errorMessage) {
                return Messages.format(RefactoringUIMessages.RedoRefactoringAction_error_message, errorMessage);
            }
        };
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    RefactoringCore.getUndoManager().performRedo(query, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    protected UndoManagerAdapter createUndoManagerListener() {
        return new UndoManagerAdapter(){

            public void redoStackChanged(IUndoManager manager) {
                IAction action = RedoRefactoringAction.this.getAction();
                if (action == null) {
                    return;
                }
                boolean enabled = false;
                String text = null;
                if (manager.anythingToRedo()) {
                    enabled = true;
                    text = RedoRefactoringAction.this.getActionText();
                } else {
                    text = RefactoringUIMessages.RedoRefactoringAction_label;
                }
                action.setEnabled(enabled);
                action.setText(text);
            }
        };
    }

    public void selectionChanged(IAction action, ISelection s) {
        if (!this.isHooked()) {
            this.hookListener(action);
            this.fPatternLength = RefactoringUIMessages.RedoRefactoringAction_extendedLabel.length();
            IUndoManager undoManager = RefactoringCore.getUndoManager();
            if (undoManager.anythingToRedo()) {
                if (undoManager.peekRedoName() != null) {
                    action.setText(this.getActionText());
                }
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
        }
    }

    private String getActionText() {
        return this.shortenText(Messages.format(RefactoringUIMessages.RedoRefactoringAction_extendedLabel, RefactoringCore.getUndoManager().peekRedoName()), this.fPatternLength);
    }
}

