/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.intro.impl.model.IntroStandbyContentPart;
import org.eclipse.ui.internal.intro.impl.model.IntroURLAction;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.Util;

public class SharedConfigExtensionsManager {
    private IExtensionRegistry registry;
    private Hashtable standbyParts = new Hashtable();
    private Hashtable commands = new Hashtable();

    protected SharedConfigExtensionsManager(IExtensionRegistry registry) {
        this.registry = registry;
    }

    protected void loadSharedConfigExtensions() {
        long start = 0L;
        if (Log.logPerformance) {
            start = System.currentTimeMillis();
        }
        IConfigurationElement[] configExtensionElements = this.registry.getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        if (Log.logPerformance) {
            Util.logPerformanceTime("quering registry for configExtensions took: ", start);
        }
        int i = 0;
        while (i < configExtensionElements.length) {
            IConfigurationElement element = configExtensionElements[i];
            if (ModelLoaderUtil.isValidElementName(element, "standbyContentPart") || ModelLoaderUtil.isValidElementName(element, "action")) {
                this.createModelClass(element);
            }
            ++i;
        }
    }

    private void createModelClass(IConfigurationElement element) {
        if (element.getName().equals("standbyContentPart")) {
            IntroStandbyContentPart standbyPartContent = new IntroStandbyContentPart(element);
            if (standbyPartContent.getId() == null) {
                return;
            }
            this.standbyParts.put(standbyPartContent.getId(), standbyPartContent);
        } else {
            IntroURLAction introURLCommand = new IntroURLAction(element);
            if (introURLCommand.getName() == null || introURLCommand.getReplaceValue() == null) {
                return;
            }
            this.commands.put(introURLCommand.getName(), introURLCommand);
        }
    }

    public IntroStandbyContentPart getStandbyPart(String partId) {
        if (partId == null) {
            return null;
        }
        return (IntroStandbyContentPart)this.standbyParts.get(partId);
    }

    public IntroURLAction getCommand(String commandName) {
        if (commandName == null) {
            return null;
        }
        return (IntroURLAction)this.commands.get(commandName);
    }
}

