/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result {
    private int fCount = 0;
    private int fIgnoreCount = 0;
    private final List<Failure> fFailures = new ArrayList<Failure>();
    private long fRunTime = 0L;
    private long fStartTime;

    public int getRunCount() {
        return this.fCount;
    }

    public int getFailureCount() {
        return this.fFailures.size();
    }

    public long getRunTime() {
        return this.fRunTime;
    }

    public List<Failure> getFailures() {
        return this.fFailures;
    }

    public int getIgnoreCount() {
        return this.fIgnoreCount;
    }

    public boolean wasSuccessful() {
        return this.getFailureCount() == 0;
    }

    public RunListener createListener() {
        return new Listener();
    }

    private class Listener
    extends RunListener {
        private boolean fIgnoredDuringExecution = false;

        private Listener() {
        }

        public void testRunStarted(Description description) throws Exception {
            Result.this.fStartTime = System.currentTimeMillis();
        }

        public void testRunFinished(Result result) throws Exception {
            long endTime = System.currentTimeMillis();
            Result.this.fRunTime += endTime - Result.this.fStartTime;
        }

        public void testFinished(Description description) throws Exception {
            if (!this.fIgnoredDuringExecution) {
                Result.this.fCount++;
            }
            this.fIgnoredDuringExecution = false;
        }

        public void testFailure(Failure failure) throws Exception {
            Result.this.fFailures.add(failure);
        }

        public void testIgnored(Description description) throws Exception {
            Result.this.fIgnoreCount++;
            this.fIgnoredDuringExecution = true;
        }

        public void testAssumptionFailure(Failure failure) {
        }
    }
}

