/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XHTMLCharsetHandler
extends ProcessorHandler {
    private static final String ELEMENT_META = "meta";
    private static final String ATTRIBUTE_CONTENT = "content";
    private static final String PREFIX_CHARSET = "text/html; charset=";
    private static final String ENCODING_UTF8 = "UTF-8";

    public short handle(UAElement element, String id) {
        Element domElement;
        String content;
        if (ELEMENT_META.equals(element.getElementName()) && (content = element.getAttribute(ATTRIBUTE_CONTENT)) != null && content.startsWith(PREFIX_CHARSET)) {
            element.setAttribute(ATTRIBUTE_CONTENT, "text/html; charset=UTF-8");
            return 1;
        }
        if ("script".equalsIgnoreCase(element.getElementName()) && (domElement = element.getElement()).getFirstChild() == null) {
            Document document = domElement.getOwnerDocument();
            Text child = document.createTextNode(" ");
            domElement.appendChild(child);
        }
        return 0;
    }
}

