/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.swt.graphics.Image;

public class JUnitClasspathFixProcessor
extends ClasspathFixProcessor {
    private static final int JUNIT3 = 1;
    private static final int JUNIT4 = 2;

    public ClasspathFixProcessor.ClasspathFixProposal[] getFixImportProposals(IJavaProject project, String missingType) throws CoreException {
        String s = missingType;
        int res = 0;
        if (s.startsWith("org.junit.")) {
            res = 2;
        } else if (s.equals("TestCase") || s.equals("TestSuite") || s.startsWith("junit.")) {
            res = 1;
        } else if (s.equals("Test")) {
            res = 3;
        } else if (s.equals("RunWith")) {
            res = 2;
        }
        if (res != 0) {
            ArrayList<JUnitClasspathFixProposal> proposals = new ArrayList<JUnitClasspathFixProposal>();
            if ((res & 2) != 0 && JUnitStubUtility.is50OrHigher(project)) {
                proposals.add(new JUnitClasspathFixProposal(project, true, 15));
            }
            if ((res & 1) != 0) {
                proposals.add(new JUnitClasspathFixProposal(project, false, 15));
            }
            return proposals.toArray(new ClasspathFixProcessor.ClasspathFixProposal[proposals.size()]);
        }
        return null;
    }

    private static class JUnitClasspathFixProposal
    extends ClasspathFixProcessor.ClasspathFixProposal {
        private final boolean fIsJunit4;
        private final int fRelevance;
        private final IJavaProject fProject;

        public JUnitClasspathFixProposal(IJavaProject project, boolean isJunit4, int relevance) {
            this.fProject = project;
            this.fIsJunit4 = isJunit4;
            this.fRelevance = relevance;
        }

        public String getAdditionalProposalInfo() {
            if (this.fIsJunit4) {
                return JUnitMessages.JUnitAddLibraryProposal_junit4_info;
            }
            return JUnitMessages.JUnitAddLibraryProposal_info;
        }

        public Change createChange(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(JUnitMessages.JUnitClasspathFixProcessor_progress_desc, 1);
            try {
                IClasspathEntry[] newCPEntries;
                Change newClasspathChange;
                IClasspathEntry entry = null;
                entry = this.fIsJunit4 ? BuildPathSupport.getJUnit4ClasspathEntry() : BuildPathSupport.getJUnit3ClasspathEntry();
                IClasspathEntry[] oldEntries = this.fProject.getRawClasspath();
                ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(oldEntries.length + 1);
                boolean added = false;
                int i = 0;
                while (i < oldEntries.length) {
                    IPath path;
                    IClasspathEntry curr = oldEntries[i];
                    if (curr.getEntryKind() == 5) {
                        path = curr.getPath();
                        if (path.equals((Object)entry.getPath())) {
                            NullChange nullChange = new NullChange();
                            return nullChange;
                        }
                        if (path.matchingFirstSegments(entry.getPath()) > 0) {
                            if (!added) {
                                curr = entry;
                                added = true;
                            } else {
                                curr = null;
                            }
                        }
                    } else if (curr.getEntryKind() == 4 && (path = curr.getPath()).segmentCount() > 0 && "JUNIT_HOME".equals(path.segment(0))) {
                        if (!added) {
                            curr = entry;
                            added = true;
                        } else {
                            curr = null;
                        }
                    }
                    if (curr != null) {
                        newEntries.add(curr);
                    }
                    ++i;
                }
                if (!added) {
                    newEntries.add(entry);
                }
                if ((newClasspathChange = JUnitClasspathFixProposal.newClasspathChange((IJavaProject)this.fProject, (IClasspathEntry[])(newCPEntries = newEntries.toArray(new IClasspathEntry[newEntries.size()])), (IPath)this.fProject.getOutputLocation())) != null) {
                    Change change = newClasspathChange;
                    return change;
                }
            }
            finally {
                monitor.done();
            }
            return new NullChange();
        }

        public String getDisplayString() {
            if (this.fIsJunit4) {
                return JUnitMessages.JUnitAddLibraryProposa_junit4_label;
            }
            return JUnitMessages.JUnitAddLibraryProposal_label;
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
        }

        public int getRelevance() {
            return this.fRelevance;
        }
    }
}

