/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.FeatureContentConsumer;
import org.eclipse.update.internal.core.ISiteContentConsumer;
import org.eclipse.update.internal.core.NonPluginEntryContentConsumer;
import org.eclipse.update.internal.core.PluginEntryContentConsumer;
import org.eclipse.update.internal.core.SiteFile;

public class FeatureExecutableContentConsumer
extends FeatureContentConsumer {
    private IFeature feature;
    private boolean closed = false;
    private boolean aborted = false;
    private ISiteContentConsumer contentConsumer;
    private IFeatureContentConsumer parent = null;
    private List children;

    public IContentConsumer open(INonPluginEntry nonPluginEntry) throws CoreException {
        NonPluginEntryContentConsumer cons = new NonPluginEntryContentConsumer(this.getContentConsumer().open(nonPluginEntry));
        return cons;
    }

    public IContentConsumer open(IPluginEntry pluginEntry) throws CoreException {
        PluginEntryContentConsumer cons = new PluginEntryContentConsumer(this.getContentConsumer().open(pluginEntry));
        return cons;
    }

    public void addChild(IFeature child) throws CoreException {
        IFeatureContentConsumer childConsumer = child.getFeatureContentConsumer();
        childConsumer.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(childConsumer);
    }

    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        this.getContentConsumer().store(contentReference, monitor);
    }

    public IFeatureReference close() throws CoreException {
        if (!this.closed && this.getParent() != null) {
            this.closed = true;
            return null;
        }
        if (this.getParent() == null) {
            ErrorRecoveryLog.getLog().append("ALL_FEATURES_INSTALLED");
        }
        IFeatureReference ref = null;
        if (this.contentConsumer != null) {
            ref = this.contentConsumer.close();
        }
        IFeatureContentConsumer[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].close();
            ++i;
        }
        return ref;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public void setParent(IFeatureContentConsumer featureContentConsumer) {
        this.parent = featureContentConsumer;
    }

    private ISiteContentConsumer getContentConsumer() throws CoreException {
        if (this.contentConsumer == null) {
            if (this.feature.getSite() instanceof SiteFile) {
                SiteFile site = (SiteFile)this.feature.getSite();
                this.contentConsumer = site.createSiteContentConsumer(this.feature);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.contentConsumer;
    }

    public void abort() throws CoreException {
        if (this.aborted) {
            return;
        }
        IFeatureContentConsumer[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            try {
                children[i].abort();
            }
            catch (Exception exception) {}
            ++i;
        }
        if (this.contentConsumer != null) {
            this.contentConsumer.abort();
        }
        this.aborted = true;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public IFeatureContentConsumer getParent() {
        return this.parent;
    }

    public IFeatureContentConsumer[] getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return new IFeatureContentConsumer[0];
        }
        return (IFeatureContentConsumer[])this.children.toArray(this.arrayTypeFor(this.children));
    }
}

