/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.TextChanges;
import org.eclipse.text.edits.UndoEdit;

public class UndoDocumentChange
extends Change {
    private String fName;
    private UndoEdit fUndo;
    private IDocument fDocument;
    private int fLength;

    public UndoDocumentChange(String name, IDocument document, UndoEdit undo) {
        this.fName = name;
        this.fUndo = undo;
        this.fDocument = document;
    }

    public String getName() {
        return this.fName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        this.fLength = this.fDocument.getLength();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        RefactoringStatus result = TextChanges.isValid(this.fDocument, this.fLength);
        pm.worked(1);
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            UndoEdit redo = this.fUndo.apply(this.fDocument, 1);
            UndoDocumentChange result = new UndoDocumentChange(this.getName(), this.fDocument, redo);
            return result;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
    }
}

