/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EclipseLauncherImpl;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.provisional.configuratormanipulator.ConfiguratorManipulator;
import org.eclipse.equinox.internal.provisional.configuratormanipulator.ConfiguratorManipulatorFactory;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class EquinoxFwAdminImpl
implements FrameworkAdmin {
    BundleContext context = null;
    boolean active = false;
    private boolean runningFw = false;
    private ConfiguratorManipulator configuratorManipulator = null;

    static boolean isRunningFw(BundleContext context) {
        String fwVendor = context.getProperty("org.osgi.framework.vendor");
        if (!"Eclipse".equals(fwVendor)) {
            return false;
        }
        Dictionary header = context.getBundle(0L).getHeaders();
        String versionSt = (String)header.get("Bundle-Version");
        Version version = new Version(versionSt);
        int value = version.compareTo((Object)new Version("3.3"));
        return value > 0;
    }

    EquinoxFwAdminImpl() {
        this(null, false);
    }

    EquinoxFwAdminImpl(BundleContext context) {
        this(context, false);
    }

    EquinoxFwAdminImpl(String configuratorManipulatorFactoryName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.context = null;
        this.active = true;
        this.runningFw = false;
        this.loadConfiguratorManipulator(configuratorManipulatorFactoryName);
    }

    private void loadConfiguratorManipulator(String configuratorManipulatorFactoryName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.configuratorManipulator = configuratorManipulatorFactoryName == null ? null : ConfiguratorManipulatorFactory.getInstance((String)configuratorManipulatorFactoryName);
    }

    EquinoxFwAdminImpl(BundleContext context, boolean runningFw) {
        this.context = context;
        this.active = true;
        this.runningFw = runningFw;
    }

    void deactivate() {
        this.active = false;
    }

    public Manipulator getManipulator() {
        return new EquinoxManipulatorImpl(this.context, this);
    }

    public Manipulator getRunningManipulator() {
        if (this.runningFw) {
            return new EquinoxManipulatorImpl(this.context, this, true);
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public Process launch(Manipulator manipulator, File cwd) throws IllegalArgumentException, FrameworkAdminRuntimeException, IOException {
        return new EclipseLauncherImpl(this).launch(manipulator, cwd);
    }

    public ConfiguratorManipulator getConfiguratorManipulator() {
        return this.configuratorManipulator;
    }
}

