/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPoolEntry;

public class ClassFileAttribute
extends ClassFileStruct {
    public static final ClassFileAttribute[] NO_ATTRIBUTES = new ClassFileAttribute[0];
    private long attributeLength;
    private int attributeNameIndex;
    private char[] attributeName;

    public ClassFileAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        this.attributeNameIndex = this.u2At(classFileBytes, 0, offset);
        this.attributeLength = this.u4At(classFileBytes, 2, offset);
        ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.attributeNameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.attributeName = constantPoolEntry.getUtf8Value();
    }

    public int getAttributeNameIndex() {
        return this.attributeNameIndex;
    }

    public char[] getAttributeName() {
        return this.attributeName;
    }

    public long getAttributeLength() {
        return this.attributeLength;
    }
}

