/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.views.markers.MarkerItem;

class MarkerMap {
    static final MarkerMap EMPTY_MAP = new MarkerMap();
    private MarkerEntry[] markers;
    private Map markerToEntryMap = null;
    private Integer[] markerCounts;

    public MarkerMap() {
        this(new MarkerEntry[0]);
    }

    public MarkerMap(MarkerEntry[] markers) {
        this.markers = markers;
    }

    public MarkerEntry elementAt(int index) {
        return this.markers[index];
    }

    Integer[] getMarkerCounts() {
        if (this.markerCounts == null) {
            int[] ints = new int[4];
            int idx = 0;
            while (idx < this.markers.length) {
                MarkerEntry marker = this.markers[idx];
                int severity = marker.getMarker().getAttribute("severity", -1);
                if (severity >= 0) {
                    int n = severity;
                    ints[n] = ints[n] + 1;
                } else {
                    ints[3] = ints[3] + 1;
                }
                ++idx;
            }
            this.markerCounts = new Integer[]{new Integer(ints[2]), new Integer(ints[1]), new Integer(ints[0]), new Integer(ints[3])};
        }
        return this.markerCounts;
    }

    public MarkerItem getMarkerItem(IMarker marker) {
        if (this.markerToEntryMap == null) {
            this.markerToEntryMap = new HashMap();
            int i = 0;
            while (i < this.markers.length) {
                IMarker nextMarker = this.markers[i].getMarker();
                if (nextMarker != null) {
                    this.markerToEntryMap.put(nextMarker, this.markers[i]);
                }
                ++i;
            }
        }
        if (this.markerToEntryMap.containsKey(marker)) {
            return (MarkerItem)this.markerToEntryMap.get(marker);
        }
        return null;
    }

    public int getSize() {
        return this.markers.length;
    }

    public MarkerEntry[] toArray() {
        return this.markers;
    }

    void clearAttributeCaches() {
        int i = 0;
        while (i < this.markers.length) {
            this.markers[i].clearCache();
            ++i;
        }
    }
}

