/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.markers.QuickFixWizard;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class QuickFixHandler
extends MarkerViewHandler {
    static /* synthetic */ Class class$0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final MarkerSupportView view = this.getView(event);
        if (view == null) {
            return this;
        }
        final LinkedHashMap resolutions = new LinkedHashMap();
        final IMarker selected = view.getSelectedMarkers()[0];
        IRunnableWithProgress resolutionsRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(MarkerMessages.resolveMarkerAction_computationManyAction, 100);
                IMarker[] allMarkers = view.getAllMarkers();
                monitor.worked(20);
                IMarkerResolution[] found = IDE.getMarkerHelpRegistry().getResolutions(selected);
                int progressCount = 80;
                if (found.length > 1) {
                    progressCount /= found.length;
                }
                int i = 0;
                while (i < found.length) {
                    IMarkerResolution markerResolution = found[i];
                    if (markerResolution instanceof WorkbenchMarkerResolution) {
                        IMarker[] other = ((WorkbenchMarkerResolution)markerResolution).findOtherMarkers(allMarkers);
                        ArrayList<IMarker> markers = new ArrayList<IMarker>();
                        markers.add(selected);
                        int j = 0;
                        while (j < other.length) {
                            markers.add(other[j]);
                            ++j;
                        }
                        resolutions.put(markerResolution, markers);
                    } else {
                        ArrayList<IMarker> markers = new ArrayList<IMarker>();
                        markers.add(selected);
                        resolutions.put(markerResolution, markers);
                    }
                    monitor.worked(progressCount);
                    ++i;
                }
                monitor.done();
            }
        };
        IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object service = iWorkbenchPartSite.getAdapter((Class)clazz);
        ProgressMonitorDialog context = new ProgressMonitorDialog(view.getSite().getShell());
        try {
            if (service == null) {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, resolutionsRunnable, null);
            } else {
                ((IWorkbenchSiteProgressService)service).runInUI((IRunnableContext)context, resolutionsRunnable, null);
            }
        }
        catch (InvocationTargetException exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        catch (InterruptedException exception) {
            throw new ExecutionException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        String markerDescription = selected.getAttribute("message", "");
        if (resolutions.isEmpty()) {
            Status newStatus = new Status(1, "org.eclipse.ui.ide", NLS.bind((String)MarkerMessages.MarkerResolutionDialog_NoResolutionsFound, (Object[])new Object[]{markerDescription}));
            StatusAdapter adapter = new StatusAdapter((IStatus)newStatus);
            adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)MarkerMessages.MarkerResolutionDialog_CannotFixTitle);
            StatusManager.getManager().handle(adapter, 2);
        } else {
            String description = NLS.bind((String)MarkerMessages.MarkerResolutionDialog_Description, (Object)markerDescription);
            QuickFixWizard wizard = new QuickFixWizard(description, resolutions, view.getSite());
            wizard.setWindowTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
            QuickFixWizardDialog dialog = new QuickFixWizardDialog(view.getSite().getShell(), (IWizard)wizard);
            dialog.open();
        }
        return this;
    }

    private class QuickFixWizardDialog
    extends WizardDialog {
        public QuickFixWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
            this.setShellStyle(0xC70 | QuickFixWizardDialog.getDefaultOrientation());
        }
    }
}

