/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.FieldArray;

class Pointer {
    protected Buffer buffer;
    protected int offset;

    public Pointer(Buffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
    }

    public Pointer dec(int n) {
        this.offset -= n;
        return this;
    }

    public FieldArray getArray(int length, int stride, int count) {
        return new FieldArray(this.buffer, this.offset, length, stride, count);
    }

    public Field getField(int offset, int length) {
        return new Field(this.buffer, this.offset + offset, length);
    }

    public Pointer inc(int n) {
        this.offset += n;
        return this;
    }

    public Pointer put(byte[] bytes) {
        this.buffer.put(this.offset, bytes);
        return this;
    }
}

