/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStore2;
import org.eclipse.core.internal.localstore.HistoryStoreConverter;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.properties.PropertyStoreConverter;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class ResourcesCompatibility {
    public static IHistoryStore createHistoryStore(IPath location, int limit, boolean newImpl, boolean convert, boolean rename) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        if (!newImpl) {
            return new HistoryStore(workspace, location, limit);
        }
        IFileStore store = EFS.getLocalFileSystem().getStore(location);
        HistoryStore2 newHistoryStore = new HistoryStore2(workspace, store, limit);
        if (!convert) {
            return newHistoryStore;
        }
        IStatus result = new HistoryStoreConverter().convertHistory(workspace, location, limit, newHistoryStore, rename);
        if (result.getSeverity() != 0) {
            Policy.log((IStatus)result);
        }
        return newHistoryStore;
    }

    public static IPropertyManager createPropertyManager(boolean newImpl, boolean convert) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        if (!newImpl) {
            return new PropertyManager(workspace);
        }
        PropertyManager2 newPropertyManager = new PropertyManager2(workspace);
        if (!convert) {
            return newPropertyManager;
        }
        IStatus result = new PropertyStoreConverter().convertProperties(workspace, newPropertyManager);
        if (result.getSeverity() != 0) {
            Policy.log((IStatus)result);
        }
        return newPropertyManager;
    }
}

