/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class AddCustomConstructorOperation
implements IWorkspaceRunnable {
    private boolean fApply = true;
    private final IMethodBinding fConstructorBinding;
    private final IVariableBinding[] fFieldBindings;
    private TextEdit fResultingEdit = null;
    private final IJavaElement fInsert;
    private boolean fOmitSuper = false;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final ITypeBinding fParentType;
    private final CompilationUnit fASTRoot;
    private int fVisibility = 0;

    public AddCustomConstructorOperation(CompilationUnit astRoot, ITypeBinding parentType, IVariableBinding[] variables, IMethodBinding constructor, IJavaElement insert, CodeGenerationSettings settings, boolean apply, boolean save) {
        Assert.isTrue((astRoot != null && astRoot.getTypeRoot() instanceof ICompilationUnit ? 1 : 0) != 0);
        Assert.isNotNull((Object)parentType);
        Assert.isNotNull((Object)variables);
        Assert.isNotNull((Object)constructor);
        Assert.isNotNull((Object)settings);
        this.fParentType = parentType;
        this.fInsert = insert;
        this.fASTRoot = astRoot;
        this.fFieldBindings = variables;
        this.fConstructorBinding = constructor;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
    }

    public final TextEdit getResultingEdit() {
        return this.fResultingEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final int getVisibility() {
        return this.fVisibility;
    }

    public final boolean isOmitSuper() {
        return this.fOmitSuper;
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 2);
            monitor.setTaskName(CodeGenerationMessages.AddCustomConstructorOperation_description);
            ICompilationUnit cu = (ICompilationUnit)this.fASTRoot.getTypeRoot();
            ASTRewrite astRewrite = ASTRewrite.create((AST)this.fASTRoot.getAST());
            ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite(this.fASTRoot, true);
            ListRewrite listRewriter = null;
            ASTNode typeDecl = this.fASTRoot.findDeclaringNode((IBinding)this.fParentType);
            if (typeDecl instanceof AbstractTypeDeclaration) {
                listRewriter = astRewrite.getListRewrite(typeDecl, ((AbstractTypeDeclaration)typeDecl).getBodyDeclarationsProperty());
            } else if (typeDecl instanceof AnonymousClassDeclaration) {
                listRewriter = astRewrite.getListRewrite(typeDecl, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            }
            if (listRewriter != null) {
                MethodDeclaration stub = StubUtility2.createConstructorStub(cu, astRewrite, importRewrite, this.fParentType, this.fOmitSuper ? null : this.fConstructorBinding, this.fFieldBindings, this.fVisibility, this.fSettings);
                if (stub != null) {
                    ASTNode insertion = StubUtility2.getNodeToInsertBefore(listRewriter, this.fInsert);
                    if (insertion != null && insertion.getParent() == typeDecl) {
                        listRewriter.insertBefore((ASTNode)stub, insertion, null);
                    } else {
                        listRewriter.insertLast((ASTNode)stub, null);
                    }
                }
                this.fResultingEdit = new MultiTextEdit();
                this.fResultingEdit.addChild(astRewrite.rewriteAST());
                this.fResultingEdit.addChild(importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                if (this.fApply) {
                    JavaModelUtil.applyEdit(cu, this.fResultingEdit, this.fSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public final void setOmitSuper(boolean omit) {
        this.fOmitSuper = omit;
    }

    public final void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }
}

