/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistLightBulbUpdater;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaCorrectionAssistant
extends QuickAssistAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;
    private Annotation[] fCurrentAnnotations;
    private QuickAssistLightBulbUpdater fLightBulbUpdater;
    private boolean fIsCompletionActive;
    private boolean fIsProblemLocationAvailable;
    static /* synthetic */ Class class$0;

    public JavaCorrectionAssistant(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        JavaCorrectionProcessor processor = new JavaCorrectionProcessor(this);
        this.setQuickAssistProcessor(processor);
        this.enableColoredLabels(PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS"));
        this.setInformationControlCreator(this.getInformationControlCreator());
        this.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                JavaCorrectionAssistant.this.fIsCompletionActive = false;
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                JavaCorrectionAssistant.this.fIsCompletionActive = true;
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, JavaPlugin.getAdditionalInfoAffordanceString());
            }
        };
    }

    public void install(ISourceViewer sourceViewer) {
        super.install(sourceViewer);
        this.fViewer = sourceViewer;
        this.fLightBulbUpdater = new QuickAssistLightBulbUpdater(this.fEditor, (ITextViewer)sourceViewer);
        this.fLightBulbUpdater.install();
    }

    public void uninstall() {
        if (this.fLightBulbUpdater != null) {
            this.fLightBulbUpdater.uninstall();
            this.fLightBulbUpdater = null;
        }
        super.uninstall();
    }

    public String showPossibleQuickAssists() {
        boolean isReinvoked = false;
        this.fIsProblemLocationAvailable = false;
        if (this.fIsCompletionActive && this.isUpdatedOffset()) {
            isReinvoked = true;
            this.restorePosition();
            this.hide();
            this.fIsProblemLocationAvailable = true;
        }
        this.fPosition = null;
        this.fCurrentAnnotations = null;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleQuickAssists();
        }
        ArrayList resultingAnnotations = new ArrayList(20);
        try {
            Point selectedRange = this.fViewer.getSelectedRange();
            int currOffset = selectedRange.x;
            int currLength = selectedRange.y;
            boolean goToClosest = currLength == 0 && !isReinvoked;
            int newOffset = JavaCorrectionAssistant.collectQuickFixableAnnotations(this.fEditor, currOffset, goToClosest, resultingAnnotations);
            if (newOffset != currOffset) {
                this.storePosition(currOffset, currLength);
                this.fViewer.setSelectedRange(newOffset, 0);
                this.fViewer.revealRange(newOffset, 0);
                this.fIsProblemLocationAvailable = true;
                if (this.fIsCompletionActive) {
                    this.hide();
                }
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        this.fCurrentAnnotations = resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
        return super.showPossibleQuickAssists();
    }

    private static IRegion getRegionOfInterest(ITextEditor editor, int invocationLocation) throws BadLocationException {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document.getLineInformationOfOffset(invocationLocation);
    }

    /*
     * Unable to fully structure code
     */
    public static int collectQuickFixableAnnotations(ITextEditor editor, int invocationLocation, boolean goToClosest, ArrayList resultingAnnotations) throws BadLocationException {
        model = JavaUI.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        if (model == null) {
            return invocationLocation;
        }
        JavaCorrectionAssistant.ensureUpdatedAnnotations(editor);
        iter = model.getAnnotationIterator();
        if (!goToClosest) ** GOTO lbl39
        lineInfo = JavaCorrectionAssistant.getRegionOfInterest(editor, invocationLocation);
        if (lineInfo == null) {
            return invocationLocation;
        }
        rangeStart = lineInfo.getOffset();
        rangeEnd = rangeStart + lineInfo.getLength();
        allAnnotations = new ArrayList<Annotation>();
        allPositions = new ArrayList<Position>();
        bestOffset = 0x7FFFFFFF;
        while (iter.hasNext()) {
            annot = (Annotation)iter.next();
            if (!JavaCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !JavaCorrectionAssistant.isInside(pos.offset, rangeStart, rangeEnd)) continue;
            allAnnotations.add(annot);
            allPositions.add(pos);
            bestOffset = JavaCorrectionAssistant.processAnnotation(annot, pos, invocationLocation, bestOffset);
        }
        if (bestOffset == 0x7FFFFFFF) {
            return invocationLocation;
        }
        i = 0;
        while (i < allPositions.size()) {
            pos = (Position)allPositions.get(i);
            if (JavaCorrectionAssistant.isInside(bestOffset, pos.offset, pos.offset + pos.length)) {
                resultingAnnotations.add(allAnnotations.get(i));
            }
            ++i;
        }
        return bestOffset;
lbl-1000:
        // 1 sources

        {
            annot = (Annotation)iter.next();
            if (!JavaCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !JavaCorrectionAssistant.isInside(invocationLocation, pos.offset, pos.offset + pos.length)) continue;
            resultingAnnotations.add(annot);
lbl39:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl40:
        // 1 sources

        return invocationLocation;
    }

    private static void ensureUpdatedAnnotations(ITextEditor editor) {
        Object inputElement;
        IEditorInput iEditorInput = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((inputElement = iEditorInput.getAdapter((Class)clazz)) instanceof ICompilationUnit) {
            SharedASTProvider.getAST((ITypeRoot)((ICompilationUnit)inputElement), SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        }
    }

    private static int processAnnotation(Annotation annot, Position pos, int invocationLocation, int bestOffset) {
        int newClosestPosition;
        int posBegin = pos.offset;
        int posEnd = posBegin + pos.length;
        if (JavaCorrectionAssistant.isInside(invocationLocation, posBegin, posEnd)) {
            return invocationLocation;
        }
        if (bestOffset != invocationLocation && (newClosestPosition = JavaCorrectionAssistant.computeBestOffset(posBegin, invocationLocation, bestOffset)) != -1 && newClosestPosition != bestOffset && JavaCorrectionProcessor.hasCorrections(annot)) {
            return newClosestPosition;
        }
        return bestOffset;
    }

    private static boolean isInside(int offset, int start, int end) {
        return offset == start || offset == end || offset > start && offset < end;
    }

    private static int computeBestOffset(int newOffset, int invocationLocation, int bestOffset) {
        if (newOffset <= invocationLocation) {
            if (bestOffset > invocationLocation) {
                return newOffset;
            }
            if (bestOffset <= newOffset) {
                return newOffset;
            }
            return -1;
        }
        if (newOffset <= bestOffset) {
            return newOffset;
        }
        return -1;
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private void storePosition(int currOffset, int currLength) {
        this.fPosition = new Position(currOffset, currLength);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }

    public boolean isProblemLocationAvailable() {
        return this.fIsProblemLocationAvailable;
    }

    public Annotation[] getAnnotationsAtOffset() {
        return this.fCurrentAnnotations;
    }
}

