/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ImportCompletionProposal
extends AbstractJavaCompletionProposal {
    private final ICompilationUnit fCompilationUnit;
    private final int fParentProposalKind;
    private ImportRewrite fImportRewrite;
    private ContextSensitiveImportRewriteContext fImportContext;
    private final CompletionProposal fProposal;
    private boolean fReplacementStringComputed;

    public ImportCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context, int parentProposalKind) {
        super(context);
        this.fProposal = proposal;
        this.fParentProposalKind = parentProposalKind;
        this.fCompilationUnit = context.getCompilationUnit();
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    private String computeReplacementString() {
        int proposalKind = this.fProposal.getKind();
        String qualifiedTypeName = null;
        char[] qualifiedType = null;
        if (proposalKind == 23) {
            qualifiedType = this.fProposal.getSignature();
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else if (proposalKind == 22 || proposalKind == 21) {
            qualifiedType = Signature.getTypeErasure((char[])this.fProposal.getDeclarationSignature());
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fImportRewrite = this.createImportRewrite();
        if (this.fImportRewrite != null) {
            if (proposalKind == 23) {
                String simpleType = this.fImportRewrite.addImport(qualifiedTypeName, (ImportRewrite.ImportRewriteContext)this.fImportContext);
                if (this.fParentProposalKind == 6) {
                    return String.valueOf(simpleType) + ".";
                }
            } else {
                String res = this.fImportRewrite.addStaticImport(qualifiedTypeName, String.valueOf(this.fProposal.getName()), proposalKind == 21, (ImportRewrite.ImportRewriteContext)this.fImportContext);
                int dot = res.lastIndexOf(46);
                if (dot != -1) {
                    String typeName = this.fImportRewrite.addImport(res.substring(0, dot), (ImportRewrite.ImportRewriteContext)this.fImportContext);
                    return String.valueOf(typeName) + '.';
                }
            }
            return "";
        }
        if (this.fCompilationUnit != null && JavaModelUtil.isImplicitImport(Signature.getQualifier((String)qualifiedTypeName), this.fCompilationUnit)) {
            if (this.fProposal.getKind() == 23 && this.fParentProposalKind == 2) {
                return "";
            }
            qualifiedTypeName = String.valueOf(Signature.getSignatureSimpleName((char[])qualifiedType));
        }
        return String.valueOf(qualifiedTypeName) + ".";
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            super.apply(document, trigger, offset);
            if (this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                int oldLen = document.getLength();
                this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private ImportRewrite createImportRewrite() {
        if (this.fCompilationUnit != null && this.shouldAddImports()) {
            try {
                CompilationUnit cu = this.getASTRoot(this.fCompilationUnit);
                if (cu == null) {
                    ImportRewrite rewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    this.fImportContext = null;
                    return rewrite;
                }
                ImportRewrite rewrite = StubUtility.createImportRewrite(cu, true);
                this.fImportContext = new ContextSensitiveImportRewriteContext(cu, this.fInvocationContext.getInvocationOffset(), rewrite);
                return rewrite;
            }
            catch (CoreException x) {
                JavaPlugin.log(x);
            }
        }
        return null;
    }

    private CompilationUnit getASTRoot(ICompilationUnit compilationUnit) {
        return SharedASTProvider.getAST((ITypeRoot)compilationUnit, SharedASTProvider.WAIT_NO, null);
    }

    private boolean shouldAddImports() {
        if (this.isInJavadoc() && !this.isJavadocProcessingEnabled()) {
            return false;
        }
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isJavadocProcessingEnabled() {
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        boolean processJavadoc = project == null ? "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.doc.comment.support")) : "enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true));
        return processJavadoc;
    }
}

