/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.Activator;
import org.eclipse.equinox.internal.p2.metadata.generator.Messages;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleDescriptionFactory {
    static final String DIR = "dir";
    static final String JAR = "jar";
    private static final String FEATURE_FILENAME_DESCRIPTOR = "feature.xml";
    private static final String PLUGIN_FILENAME_DESCRIPTOR = "plugin.xml";
    private static final String FRAGMENT_FILENAME_DESCRIPTOR = "fragment.xml";
    static String BUNDLE_FILE_KEY = "eclipse.p2.bundle.format";
    StateObjectFactory factory;
    State state;
    static /* synthetic */ Class class$0;

    public BundleDescriptionFactory(StateObjectFactory factory, State state) {
        this.factory = factory;
        this.state = state;
    }

    private PluginConverter acquirePluginConverter() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PluginConverter)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    private Dictionary convertPluginManifest(File bundleLocation, boolean logConversionException) {
        PluginConverter converter;
        block6: {
            try {
                converter = this.acquirePluginConverter();
                if (converter != null) break block6;
                LogHelper.log((IStatus)new Status(4, Activator.ID, "Unable to aquire PluginConverter service during generation for: " + bundleLocation));
                return null;
            }
            catch (PluginConversionException convertException) {
                if (bundleLocation.getName().equals(FEATURE_FILENAME_DESCRIPTOR)) {
                    return null;
                }
                if (!new File(bundleLocation, PLUGIN_FILENAME_DESCRIPTOR).exists() && !new File(bundleLocation, FRAGMENT_FILENAME_DESCRIPTOR).exists()) {
                    return null;
                }
                if (logConversionException) {
                    Status status = new Status(2, Activator.ID, 0, NLS.bind((String)Messages.exception_errorConverting, (Object)bundleLocation.getAbsolutePath()), (Throwable)convertException);
                    LogHelper.log((IStatus)status);
                }
                return null;
            }
        }
        return converter.convertManifest(bundleLocation, false, null, true, null);
    }

    public BundleDescription getBundleDescription(Dictionary enhancedManifest, File bundleLocation) {
        try {
            BundleDescription descriptor = this.factory.createBundleDescription(this.state, enhancedManifest, bundleLocation != null ? bundleLocation.getAbsolutePath() : null, 1L);
            descriptor.setUserObject((Object)enhancedManifest);
            return descriptor;
        }
        catch (BundleException e) {
            String message = NLS.bind((String)Messages.exception_stateAddition, (Object)(bundleLocation == null ? null : bundleLocation.getAbsoluteFile()));
            Status status = new Status(2, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
            return null;
        }
    }

    public BundleDescription getBundleDescription(File bundleLocation) {
        Dictionary manifest = this.loadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        return this.getBundleDescription(manifest, bundleLocation);
    }

    public BundleDescription getBundleDescription(InputStream manifestStream, File bundleLocation) {
        Hashtable entries = new Hashtable();
        try {
            ManifestElement.parseBundleManifest((InputStream)manifestStream, entries);
            return this.getBundleDescription(entries, bundleLocation);
        }
        catch (IOException e) {
            String message = "An error occurred while reading the bundle description " + (bundleLocation == null ? "" : String.valueOf(bundleLocation.getAbsolutePath()) + '.');
            Status status = new Status(4, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
        }
        catch (BundleException e) {
            String message = "An error occurred while reading the bundle description " + (bundleLocation == null ? "" : String.valueOf(bundleLocation.getAbsolutePath()) + '.');
            Status status = new Status(4, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
        }
        return null;
    }

    public Dictionary loadManifest(File bundleLocation) {
        InputStream manifestStream = null;
        ZipFile jarFile = null;
        try {
            if (JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File manifestFile = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (manifestFile.exists()) {
                    manifestStream = new BufferedInputStream(new FileInputStream(manifestFile));
                }
            }
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(2, Activator.ID, "An error occurred while loading the bundle manifest " + bundleLocation, (Throwable)e));
        }
        Dictionary manifest = null;
        if (manifestStream != null) {
            try {
                Map manifestMap = ManifestElement.parseBundleManifest(manifestStream, null);
                manifest = new Hashtable<String, String>(manifestMap);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, "An error occurred while loading the bundle manifest " + bundleLocation, (Throwable)e));
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
            catch (BundleException e) {
                try {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, "An error occurred while loading the bundle manifest " + bundleLocation, (Throwable)e));
                }
                catch (Throwable throwable) {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        } else {
            manifest = this.convertPluginManifest(bundleLocation, true);
        }
        if (manifest == null) {
            return null;
        }
        if (((Dictionary)manifest).get("Bundle-SymbolicName") == null) {
            manifest = this.convertPluginManifest(bundleLocation, true);
        }
        if (manifest == null) {
            return null;
        }
        ((Dictionary)manifest).put(BUNDLE_FILE_KEY, bundleLocation.isDirectory() ? DIR : JAR);
        return manifest;
    }
}

