/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.list;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class MultiListProperty
extends ListProperty {
    private IListProperty[] properties;
    private Object elementType;

    public MultiListProperty(IListProperty[] properties) {
        this(properties, null);
    }

    public MultiListProperty(IListProperty[] properties, Object elementType) {
        this.properties = properties;
        this.elementType = elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public IObservableList observe(Realm realm, Object source) {
        IObservableList[] lists = new IObservableList[this.properties.length];
        int i = 0;
        while (i < lists.length) {
            lists[i] = this.properties[i].observe(realm, source);
            ++i;
        }
        MultiList multiList = new MultiList(lists, this.elementType);
        int i2 = 0;
        while (i2 < lists.length) {
            PropertyObservableUtil.cascadeDispose((IObservable)multiList, (IObservable)lists[i2]);
            ++i2;
        }
        return multiList;
    }
}

