/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.core.refactoring.MethodBreakpointMethodChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;

public class BreakpointRenameMethodParticipant
extends BreakpointRenameParticipant {
    protected boolean accepts(IJavaElement element) {
        return element instanceof IMethod;
    }

    protected void gatherChanges(IMarker[] markers, List changes, String destMethodName) throws CoreException, OperationCanceledException {
        IMethod originalMethod = (IMethod)this.getOriginalElement();
        int i = 0;
        while (i < markers.length) {
            IJavaMethodBreakpoint methodBreakpoint;
            IType breakpointType;
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaMethodBreakpoint && (breakpointType = BreakpointUtils.getType((IJavaBreakpoint)(methodBreakpoint = (IJavaMethodBreakpoint)breakpoint))) != null && originalMethod.getDeclaringType().equals(breakpointType)) {
                IMethod destMethod = originalMethod.getDeclaringType().getMethod(destMethodName, originalMethod.getParameterTypes());
                changes.add(new MethodBreakpointMethodChange(methodBreakpoint, destMethod));
            }
            ++i;
        }
    }
}

