/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ShowStratumAction
implements IObjectActionDelegate,
IMenuCreator {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fPart;
    static /* synthetic */ Class class$0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            action.setMenuCreator((IMenuCreator)this);
        } else {
            action.setMenuCreator(null);
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                ShowStratumAction.this.fillMenu(m);
            }
        });
        return menu;
    }

    private void fillMenu(Menu m) {
        IStackFrame frame = (IStackFrame)this.fSelection.getFirstElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJavaStackFrame javaStackFrame = (IJavaStackFrame)frame.getAdapter((Class)clazz);
        try {
            IJavaReferenceType declaringType = javaStackFrame.getReferenceType();
            IJavaDebugTarget target = (IJavaDebugTarget)javaStackFrame.getDebugTarget();
            String currentStratum = target.getDefaultStratum();
            String[] strata = declaringType.getAvailableStrata();
            int i = 0;
            while (i < strata.length) {
                String stratum = strata[i];
                MenuItem item = this.createMenuItem(m, stratum, javaStackFrame, target);
                item.setSelection(stratum.equals(currentStratum));
                ++i;
            }
            MenuItem item = this.createMenuItem(m, null, javaStackFrame, target);
            item.setSelection(currentStratum == null);
        }
        catch (DebugException debugException) {}
    }

    private MenuItem createMenuItem(Menu m, final String stratum, final IJavaStackFrame frame, final IJavaDebugTarget target) {
        MenuItem item = new MenuItem(m, 32);
        if (stratum == null) {
            item.setText(ActionMessages.ShowStratumAction_0);
        } else {
            item.setText(stratum);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((MenuItem)e.getSource()).getSelection()) {
                    target.setDefaultStratum(stratum);
                } else {
                    target.setDefaultStratum(null);
                }
                DebugEvent event = new DebugEvent((Object)frame, 16, 512);
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
                SourceLookupManager.getDefault().displaySource((Object)frame, ShowStratumAction.this.fPart.getSite().getPage(), true);
            }
        });
        return item;
    }

    public void dispose() {
    }
}

