/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CleanupzipAction;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class UnzipAction
extends ProvisioningAction {
    public static final String ACTION_UNZIP = "unzip";
    static /* synthetic */ Class class$0;

    public IStatus execute(Map parameters) {
        return UnzipAction.unzip(parameters, true);
    }

    public IStatus undo(Map parameters) {
        return CleanupzipAction.cleanupzip(parameters, false);
    }

    public static IStatus unzip(Map parameters, boolean restoreable) {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_UNZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        if (source.equals("@artifact")) {
            IFileArtifactRepository downloadCache;
            if (iu.getArtifacts() == null || iu.getArtifacts().length == 0) {
                return Status.OK_STATUS;
            }
            IArtifactKey artifactKey = iu.getArtifacts()[0];
            try {
                downloadCache = Util.getDownloadCacheRepo();
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
            File fileLocation = downloadCache.getArtifactFile(artifactKey);
            if (fileLocation == null || !fileLocation.exists()) {
                return Util.createError(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = fileLocation.getAbsolutePath();
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        File[] unzippedFiles = UnzipAction.unzip(source, target, store);
        StringBuffer unzippedFileNameBuffer = new StringBuffer();
        int i = 0;
        while (i < unzippedFiles.length) {
            unzippedFileNameBuffer.append(unzippedFiles[i].getAbsolutePath()).append("|");
            ++i;
        }
        profile.setInstallableUnitProperty(iu, "unzipped|" + originalSource + "|" + target, unzippedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    private static File[] unzip(String source, String destination, IBackupStore store) {
        File zipFile = new File(source);
        if (zipFile == null || !zipFile.exists()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.log(String.valueOf(clazz.getName()) + " the files to be unzipped is not here");
        }
        try {
            String taskName = NLS.bind((String)Messages.unzipping, (Object)source);
            return Util.unzipFile(zipFile, new File(destination), store, taskName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.log(String.valueOf(clazz.getName()) + " error unzipping zipfile: " + zipFile.getAbsolutePath() + "destination: " + destination);
            return new File[0];
        }
    }
}

