/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.artifact.repository;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;

public class ArtifactDescriptor
implements IArtifactDescriptor {
    public static final String ARTIFACT_REFERENCE = "artifact.reference";
    private static final ProcessingStepDescriptor[] EMPTY_STEPS = new ProcessingStepDescriptor[0];
    protected IArtifactKey key;
    protected ProcessingStepDescriptor[] processingSteps = EMPTY_STEPS;
    protected Map properties = new OrderedProperties();
    protected Map repositoryProperties = new OrderedProperties();
    protected transient IArtifactRepository repository;

    public ArtifactDescriptor(IArtifactDescriptor base) {
        this.key = base.getArtifactKey();
        this.processingSteps = base.getProcessingSteps();
        this.properties.putAll(base.getProperties());
        this.repository = base.getRepository();
    }

    public ArtifactDescriptor(ArtifactDescriptor base) {
        this.key = base.key;
        this.processingSteps = base.processingSteps;
        this.properties = base.properties;
        this.repository = base.repository;
    }

    public ArtifactDescriptor(IArtifactKey key) {
        this.key = key;
    }

    public IArtifactKey getArtifactKey() {
        return this.key;
    }

    public String getProperty(String propertyKey) {
        return (String)this.properties.get(propertyKey);
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public void addProperties(Map additionalProperties) {
        this.properties.putAll(additionalProperties);
    }

    public Map getProperties() {
        return OrderedProperties.unmodifiableProperties((Map)this.properties);
    }

    public String getRepositoryProperty(String propertyKey) {
        return (String)this.repositoryProperties.get(propertyKey);
    }

    public void setRepositoryProperty(String key, String value) {
        if (value == null) {
            this.repositoryProperties.remove(key);
        } else {
            this.repositoryProperties.put(key, value);
        }
    }

    public void addRepositoryProperties(Map additionalProperties) {
        this.repositoryProperties.putAll(additionalProperties);
    }

    public Map getRepositoryProperties() {
        return OrderedProperties.unmodifiableProperties((Map)this.repositoryProperties);
    }

    public ProcessingStepDescriptor[] getProcessingSteps() {
        return this.processingSteps;
    }

    public void setProcessingSteps(ProcessingStepDescriptor[] value) {
        this.processingSteps = value == null ? EMPTY_STEPS : value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactDescriptor other = (ArtifactDescriptor)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (!Arrays.equals(this.processingSteps, other.processingSteps)) {
            return false;
        }
        String locationProperty = this.getRepositoryProperty(ARTIFACT_REFERENCE);
        String otherProperty = other.getRepositoryProperty(ARTIFACT_REFERENCE);
        if (locationProperty != null ? !locationProperty.equals(otherProperty) : otherProperty != null) {
            return false;
        }
        locationProperty = this.getProperty("format");
        otherProperty = other.getProperty("format");
        return !(locationProperty != null ? !locationProperty.equals(otherProperty) : otherProperty != null);
    }

    private int hashCode(Object[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = prime * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.hashCode(this.processingSteps);
        Object[] hashProperties = new String[]{this.getRepositoryProperty(ARTIFACT_REFERENCE), this.getProperty("format")};
        result = 31 * result + this.hashCode(hashProperties);
        return result;
    }

    public IArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IArtifactRepository value) {
        this.repository = value;
    }

    public String toString() {
        String format = this.getProperty("format");
        if (format == null) {
            return "canonical: " + this.key.toString();
        }
        return String.valueOf(format) + ": " + this.key.toString();
    }
}

